/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.Access;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.analysis.ReferenceTreeNode;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.Translator;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class BehaviorReferenceTreeNode
extends DefaultMutableTreeNode
implements ReferenceTreeNode<BehaviorEntry, BehaviorEntry> {
    private static final long serialVersionUID = -3658163700783307520L;
    private Translator m_deobfuscatingTranslator;
    private BehaviorEntry m_entry;
    private EntryReference<BehaviorEntry, BehaviorEntry> m_reference;
    private Access m_access;

    public BehaviorReferenceTreeNode(Translator deobfuscatingTranslator, BehaviorEntry entry) {
        this.m_deobfuscatingTranslator = deobfuscatingTranslator;
        this.m_entry = entry;
        this.m_reference = null;
    }

    public BehaviorReferenceTreeNode(Translator deobfuscatingTranslator, EntryReference<BehaviorEntry, BehaviorEntry> reference, Access access) {
        this.m_deobfuscatingTranslator = deobfuscatingTranslator;
        this.m_entry = (BehaviorEntry)reference.entry;
        this.m_reference = reference;
        this.m_access = access;
    }

    @Override
    public BehaviorEntry getEntry() {
        return this.m_entry;
    }

    @Override
    public EntryReference<BehaviorEntry, BehaviorEntry> getReference() {
        return this.m_reference;
    }

    @Override
    public String toString() {
        if (this.m_reference != null) {
            return String.format("%s (%s)", new Object[]{this.m_deobfuscatingTranslator.translateEntry((BehaviorEntry)this.m_reference.context), this.m_access});
        }
        return this.m_deobfuscatingTranslator.translateEntry(this.m_entry).toString();
    }

    public void load(JarIndex index, boolean recurse) {
        for (EntryReference<BehaviorEntry, BehaviorEntry> reference : index.getBehaviorReferences(this.m_entry)) {
            this.add(new BehaviorReferenceTreeNode(this.m_deobfuscatingTranslator, reference, index.getAccess(this.m_entry)));
        }
        if (recurse && this.children != null) {
            for (EntryReference<BehaviorEntry, BehaviorEntry> child : this.children) {
                if (!(child instanceof BehaviorReferenceTreeNode)) continue;
                BehaviorReferenceTreeNode node = (BehaviorReferenceTreeNode)((Object)child);
                HashSet ancestors = Sets.newHashSet();
                TreeNode n = node;
                while (n.getParent() != null) {
                    if (!((n = n.getParent()) instanceof BehaviorReferenceTreeNode)) continue;
                    ancestors.add(((BehaviorReferenceTreeNode)n).getEntry());
                }
                if (ancestors.contains(node.getEntry())) continue;
                node.load(index, true);
            }
        }
    }
}

