/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.collect.Maps;
import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.ClasspathTypeLoader;
import com.strobel.assembler.metadata.ITypeLoader;
import cuchaz.enigma.analysis.BridgeMarker;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.bytecode.ClassRenamer;
import cuchaz.enigma.bytecode.ClassTranslator;
import cuchaz.enigma.bytecode.InnerClassWriter;
import cuchaz.enigma.bytecode.MethodParameterWriter;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Translator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ByteArrayClassPath;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;

public class TranslatingTypeLoader
implements ITypeLoader {
    private JarFile m_jar;
    private JarIndex m_jarIndex;
    private Translator m_obfuscatingTranslator;
    private Translator m_deobfuscatingTranslator;
    private Map<String, byte[]> m_cache;
    private ClasspathTypeLoader m_defaultTypeLoader;

    public TranslatingTypeLoader(JarFile jar, JarIndex jarIndex) {
        this(jar, jarIndex, new Translator(), new Translator());
    }

    public TranslatingTypeLoader(JarFile jar, JarIndex jarIndex, Translator obfuscatingTranslator, Translator deobfuscatingTranslator) {
        this.m_jar = jar;
        this.m_jarIndex = jarIndex;
        this.m_obfuscatingTranslator = obfuscatingTranslator;
        this.m_deobfuscatingTranslator = deobfuscatingTranslator;
        this.m_cache = Maps.newHashMap();
        this.m_defaultTypeLoader = new ClasspathTypeLoader();
    }

    public void clearCache() {
        this.m_cache.clear();
    }

    public boolean tryLoadType(String deobfClassName, Buffer out) {
        byte[] data;
        if (this.m_cache.containsKey(deobfClassName)) {
            data = this.m_cache.get(deobfClassName);
        } else {
            data = this.loadType(deobfClassName);
            this.m_cache.put(deobfClassName, data);
        }
        if (data == null) {
            return this.m_defaultTypeLoader.tryLoadType(deobfClassName, out);
        }
        out.reset(data.length);
        System.arraycopy(data, 0, out.array(), out.position(), data.length);
        out.position(0);
        return true;
    }

    public CtClass loadClass(String deobfClassName) {
        byte[] data = this.loadType(deobfClassName);
        if (data == null) {
            return null;
        }
        String javaClassFileName = Descriptor.toJavaName((String)deobfClassName);
        ClassPool classPool = new ClassPool();
        classPool.insertClassPath((ClassPath)new ByteArrayClassPath(javaClassFileName, data));
        try {
            return classPool.get(javaClassFileName);
        }
        catch (NotFoundException ex) {
            throw new Error(ex);
        }
    }

    private byte[] loadType(String deobfClassName) {
        ClassEntry deobfClassEntry = new ClassEntry(deobfClassName);
        ClassEntry obfClassEntry = this.m_obfuscatingTranslator.translateEntry(deobfClassEntry);
        String obfOuterClassName = this.m_jarIndex.getOuterClass(obfClassEntry.getSimpleName());
        if (obfOuterClassName != null) {
            System.err.println(String.format("WARNING: class %s referenced by bare inner name instead of via outer class %s", deobfClassName, obfOuterClassName));
            return null;
        }
        String classFileName = obfClassEntry.isInnerClass() ? obfClassEntry.getInnerClassName() : (obfClassEntry.getPackageName().equals("none") ? obfClassEntry.getSimpleName() : obfClassEntry.getName());
        JarEntry entry = this.m_jar.getJarEntry(String.valueOf(classFileName) + ".class");
        if (entry == null) {
            return null;
        }
        try {
            int bytesRead;
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            byte[] buf = new byte[0x100000];
            InputStream in = this.m_jar.getInputStream(entry);
            while ((bytesRead = in.read(buf)) > 0) {
                data.write(buf, 0, bytesRead);
            }
            data.close();
            in.close();
            buf = data.toByteArray();
            String javaClassFileName = Descriptor.toJavaName((String)classFileName);
            ClassPool classPool = new ClassPool();
            classPool.insertClassPath((ClassPath)new ByteArrayClassPath(javaClassFileName, buf));
            CtClass c = classPool.get(javaClassFileName);
            c = this.transformClass(c);
            this.assertClassName(c, deobfClassEntry);
            return c.toBytecode();
        }
        catch (IOException | CannotCompileException | NotFoundException ex) {
            throw new Error(ex);
        }
    }

    public CtClass transformClass(CtClass c) throws IOException, NotFoundException, CannotCompileException {
        ClassRenamer.moveAllClassesOutOfDefaultPackage(c, "none");
        new InnerClassWriter(this.m_jarIndex).write(c);
        ClassEntry obfClassEntry = new ClassEntry(Descriptor.toJvmName((String)c.getName()));
        String javaClassReconstructedName = Descriptor.toJavaName((String)obfClassEntry.getName());
        ClassPool classPool = new ClassPool();
        classPool.insertClassPath((ClassPath)new ByteArrayClassPath(javaClassReconstructedName, c.toBytecode()));
        c = classPool.get(javaClassReconstructedName);
        this.assertClassName(c, obfClassEntry);
        new BridgeMarker(this.m_jarIndex).markBridges(c);
        new MethodParameterWriter(this.m_deobfuscatingTranslator).writeMethodArguments(c);
        new ClassTranslator(this.m_deobfuscatingTranslator).translate(c);
        return c;
    }

    private void assertClassName(CtClass c, ClassEntry obfClassEntry) {
        String name1 = Descriptor.toJvmName((String)c.getName());
        assert (name1.equals(obfClassEntry.getName())) : String.format("Looking for %s, instead found %s", obfClassEntry.getName(), name1);
        String name2 = Descriptor.toJvmName((String)c.getClassFile().getName());
        assert (name2.equals(obfClassEntry.getName())) : String.format("Looking for %s, instead found %s", obfClassEntry.getName(), name2);
    }
}

