/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.TestEntryFactory;
import cuchaz.enigma.mapping.Type;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class TestType {
    @Test
    public void isVoid() {
        MatcherAssert.assertThat((Object)new Type("V").isVoid(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new Type("Z").isVoid(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("B").isVoid(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("C").isVoid(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("I").isVoid(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("J").isVoid(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("F").isVoid(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("D").isVoid(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("LFoo;").isVoid(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("[I").isVoid(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void isPrimitive() {
        MatcherAssert.assertThat((Object)new Type("V").isPrimitive(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("Z").isPrimitive(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new Type("B").isPrimitive(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new Type("C").isPrimitive(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new Type("I").isPrimitive(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new Type("J").isPrimitive(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new Type("F").isPrimitive(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new Type("D").isPrimitive(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new Type("LFoo;").isPrimitive(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("[I").isPrimitive(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void getPrimitive() {
        MatcherAssert.assertThat((Object)((Object)new Type("Z").getPrimitive()), (Matcher)Matchers.is((Object)((Object)Type.Primitive.Boolean)));
        MatcherAssert.assertThat((Object)((Object)new Type("B").getPrimitive()), (Matcher)Matchers.is((Object)((Object)Type.Primitive.Byte)));
        MatcherAssert.assertThat((Object)((Object)new Type("C").getPrimitive()), (Matcher)Matchers.is((Object)((Object)Type.Primitive.Character)));
        MatcherAssert.assertThat((Object)((Object)new Type("I").getPrimitive()), (Matcher)Matchers.is((Object)((Object)Type.Primitive.Integer)));
        MatcherAssert.assertThat((Object)((Object)new Type("J").getPrimitive()), (Matcher)Matchers.is((Object)((Object)Type.Primitive.Long)));
        MatcherAssert.assertThat((Object)((Object)new Type("F").getPrimitive()), (Matcher)Matchers.is((Object)((Object)Type.Primitive.Float)));
        MatcherAssert.assertThat((Object)((Object)new Type("D").getPrimitive()), (Matcher)Matchers.is((Object)((Object)Type.Primitive.Double)));
    }

    @Test
    public void isClass() {
        MatcherAssert.assertThat((Object)new Type("V").isClass(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("Z").isClass(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("B").isClass(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("C").isClass(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("I").isClass(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("J").isClass(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("F").isClass(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("D").isClass(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("LFoo;").isClass(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new Type("[I").isClass(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void getClassEntry() {
        MatcherAssert.assertThat((Object)new Type("LFoo;").getClassEntry(), (Matcher)Matchers.is((Object)TestEntryFactory.newClass("Foo")));
        MatcherAssert.assertThat((Object)new Type("LFoo<Ljava/lang/String;>;").getClassEntry(), (Matcher)Matchers.is((Object)TestEntryFactory.newClass("Foo")));
    }

    @Test
    public void getArrayClassEntry() {
        MatcherAssert.assertThat((Object)new Type("[LFoo;").getClassEntry(), (Matcher)Matchers.is((Object)TestEntryFactory.newClass("Foo")));
        MatcherAssert.assertThat((Object)new Type("[[[LFoo<Ljava/lang/String;>;").getClassEntry(), (Matcher)Matchers.is((Object)TestEntryFactory.newClass("Foo")));
    }

    @Test
    public void isArray() {
        MatcherAssert.assertThat((Object)new Type("V").isArray(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("Z").isArray(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("B").isArray(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("C").isArray(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("I").isArray(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("J").isArray(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("F").isArray(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("D").isArray(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("LFoo;").isArray(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("[I").isArray(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void getArrayDimension() {
        MatcherAssert.assertThat((Object)new Type("[I").getArrayDimension(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)new Type("[[I").getArrayDimension(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)new Type("[[[I").getArrayDimension(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void getArrayType() {
        MatcherAssert.assertThat((Object)new Type("[I").getArrayType(), (Matcher)Matchers.is((Object)new Type("I")));
        MatcherAssert.assertThat((Object)new Type("[[I").getArrayType(), (Matcher)Matchers.is((Object)new Type("I")));
        MatcherAssert.assertThat((Object)new Type("[[[I").getArrayType(), (Matcher)Matchers.is((Object)new Type("I")));
        MatcherAssert.assertThat((Object)new Type("[Ljava/lang/String;").getArrayType(), (Matcher)Matchers.is((Object)new Type("Ljava/lang/String;")));
    }

    @Test
    public void hasClass() {
        MatcherAssert.assertThat((Object)new Type("LFoo;").hasClass(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new Type("LCow<LCheese;>;").hasClass(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new Type("[LBar;").hasClass(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new Type("[[[LCat;").hasClass(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new Type("V").hasClass(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("[I").hasClass(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("[[[I").hasClass(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new Type("Z").hasClass(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void parseVoid() {
        String answer = "V";
        MatcherAssert.assertThat((Object)Type.parseFirst("V"), (Matcher)Matchers.is((Object)"V"));
        MatcherAssert.assertThat((Object)Type.parseFirst("VVV"), (Matcher)Matchers.is((Object)"V"));
        MatcherAssert.assertThat((Object)Type.parseFirst("VIJ"), (Matcher)Matchers.is((Object)"V"));
        MatcherAssert.assertThat((Object)Type.parseFirst("V[I"), (Matcher)Matchers.is((Object)"V"));
        MatcherAssert.assertThat((Object)Type.parseFirst("VLFoo;"), (Matcher)Matchers.is((Object)"V"));
        MatcherAssert.assertThat((Object)Type.parseFirst("V[LFoo;"), (Matcher)Matchers.is((Object)"V"));
    }

    @Test
    public void parsePrimitive() {
        String answer = "I";
        MatcherAssert.assertThat((Object)Type.parseFirst("I"), (Matcher)Matchers.is((Object)"I"));
        MatcherAssert.assertThat((Object)Type.parseFirst("III"), (Matcher)Matchers.is((Object)"I"));
        MatcherAssert.assertThat((Object)Type.parseFirst("IJZ"), (Matcher)Matchers.is((Object)"I"));
        MatcherAssert.assertThat((Object)Type.parseFirst("I[I"), (Matcher)Matchers.is((Object)"I"));
        MatcherAssert.assertThat((Object)Type.parseFirst("ILFoo;"), (Matcher)Matchers.is((Object)"I"));
        MatcherAssert.assertThat((Object)Type.parseFirst("I[LFoo;"), (Matcher)Matchers.is((Object)"I"));
    }

    @Test
    public void parseClass() {
        String answer = "LFoo;";
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo;"), (Matcher)Matchers.is((Object)"LFoo;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo;I"), (Matcher)Matchers.is((Object)"LFoo;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo;JZ"), (Matcher)Matchers.is((Object)"LFoo;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo;[I"), (Matcher)Matchers.is((Object)"LFoo;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo;LFoo;"), (Matcher)Matchers.is((Object)"LFoo;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo;[LFoo;"), (Matcher)Matchers.is((Object)"LFoo;"));
        answer = "LFoo<LFoo;>;";
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo<LFoo;>;"), (Matcher)Matchers.is((Object)"LFoo<LFoo;>;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo<LFoo;>;I"), (Matcher)Matchers.is((Object)"LFoo<LFoo;>;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo<LFoo;>;JZ"), (Matcher)Matchers.is((Object)"LFoo<LFoo;>;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo<LFoo;>;[I"), (Matcher)Matchers.is((Object)"LFoo<LFoo;>;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo<LFoo;>;LFoo;"), (Matcher)Matchers.is((Object)"LFoo<LFoo;>;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo<LFoo;>;[LFoo;"), (Matcher)Matchers.is((Object)"LFoo<LFoo;>;"));
        answer = "LFoo<LFoo;,LBar;>;";
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo<LFoo;,LBar;>;"), (Matcher)Matchers.is((Object)"LFoo<LFoo;,LBar;>;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo<LFoo;,LBar;>;I"), (Matcher)Matchers.is((Object)"LFoo<LFoo;,LBar;>;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo<LFoo;,LBar;>;JZ"), (Matcher)Matchers.is((Object)"LFoo<LFoo;,LBar;>;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo<LFoo;,LBar;>;[I"), (Matcher)Matchers.is((Object)"LFoo<LFoo;,LBar;>;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo<LFoo;,LBar;>;LFoo;"), (Matcher)Matchers.is((Object)"LFoo<LFoo;,LBar;>;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("LFoo<LFoo;,LBar;>;[LFoo;"), (Matcher)Matchers.is((Object)"LFoo<LFoo;,LBar;>;"));
    }

    @Test
    public void parseArray() {
        String answer = "[I";
        MatcherAssert.assertThat((Object)Type.parseFirst("[I"), (Matcher)Matchers.is((Object)"[I"));
        MatcherAssert.assertThat((Object)Type.parseFirst("[III"), (Matcher)Matchers.is((Object)"[I"));
        MatcherAssert.assertThat((Object)Type.parseFirst("[IJZ"), (Matcher)Matchers.is((Object)"[I"));
        MatcherAssert.assertThat((Object)Type.parseFirst("[I[I"), (Matcher)Matchers.is((Object)"[I"));
        MatcherAssert.assertThat((Object)Type.parseFirst("[ILFoo;"), (Matcher)Matchers.is((Object)"[I"));
        answer = "[[I";
        MatcherAssert.assertThat((Object)Type.parseFirst("[[I"), (Matcher)Matchers.is((Object)"[[I"));
        MatcherAssert.assertThat((Object)Type.parseFirst("[[III"), (Matcher)Matchers.is((Object)"[[I"));
        MatcherAssert.assertThat((Object)Type.parseFirst("[[IJZ"), (Matcher)Matchers.is((Object)"[[I"));
        MatcherAssert.assertThat((Object)Type.parseFirst("[[I[I"), (Matcher)Matchers.is((Object)"[[I"));
        MatcherAssert.assertThat((Object)Type.parseFirst("[[ILFoo;"), (Matcher)Matchers.is((Object)"[[I"));
        answer = "[LFoo;";
        MatcherAssert.assertThat((Object)Type.parseFirst("[LFoo;"), (Matcher)Matchers.is((Object)"[LFoo;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("[LFoo;II"), (Matcher)Matchers.is((Object)"[LFoo;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("[LFoo;JZ"), (Matcher)Matchers.is((Object)"[LFoo;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("[LFoo;[I"), (Matcher)Matchers.is((Object)"[LFoo;"));
        MatcherAssert.assertThat((Object)Type.parseFirst("[LFoo;LFoo;"), (Matcher)Matchers.is((Object)"[LFoo;"));
    }

    @Test
    public void equals() {
        MatcherAssert.assertThat((Object)new Type("V"), (Matcher)Matchers.is((Object)new Type("V")));
        MatcherAssert.assertThat((Object)new Type("Z"), (Matcher)Matchers.is((Object)new Type("Z")));
        MatcherAssert.assertThat((Object)new Type("B"), (Matcher)Matchers.is((Object)new Type("B")));
        MatcherAssert.assertThat((Object)new Type("C"), (Matcher)Matchers.is((Object)new Type("C")));
        MatcherAssert.assertThat((Object)new Type("I"), (Matcher)Matchers.is((Object)new Type("I")));
        MatcherAssert.assertThat((Object)new Type("J"), (Matcher)Matchers.is((Object)new Type("J")));
        MatcherAssert.assertThat((Object)new Type("F"), (Matcher)Matchers.is((Object)new Type("F")));
        MatcherAssert.assertThat((Object)new Type("D"), (Matcher)Matchers.is((Object)new Type("D")));
        MatcherAssert.assertThat((Object)new Type("LFoo;"), (Matcher)Matchers.is((Object)new Type("LFoo;")));
        MatcherAssert.assertThat((Object)new Type("[I"), (Matcher)Matchers.is((Object)new Type("[I")));
        MatcherAssert.assertThat((Object)new Type("[[[I"), (Matcher)Matchers.is((Object)new Type("[[[I")));
        MatcherAssert.assertThat((Object)new Type("[LFoo;"), (Matcher)Matchers.is((Object)new Type("[LFoo;")));
        MatcherAssert.assertThat((Object)new Type("LFoo<LBar;>;"), (Matcher)Matchers.is((Object)new Type("LFoo<LBar;>;")));
        MatcherAssert.assertThat((Object)new Type("V"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Type("I"))));
        MatcherAssert.assertThat((Object)new Type("I"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Type("J"))));
        MatcherAssert.assertThat((Object)new Type("I"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Type("LBar;"))));
        MatcherAssert.assertThat((Object)new Type("I"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Type("[I"))));
        MatcherAssert.assertThat((Object)new Type("LFoo;"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Type("LBar;"))));
        MatcherAssert.assertThat((Object)new Type("LFoo<LBar;>;"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Type("LFoo<LCow;>;"))));
        MatcherAssert.assertThat((Object)new Type("[I"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Type("[Z"))));
        MatcherAssert.assertThat((Object)new Type("[[[I"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Type("[I"))));
        MatcherAssert.assertThat((Object)new Type("[LFoo;"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Type("[LBar;"))));
    }
}

