/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.TestEntryFactory;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MappingsReader;
import cuchaz.enigma.mapping.TranslationDirection;
import cuchaz.enigma.mapping.Translator;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.jar.JarFile;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTranslator {
    private static Deobfuscator m_deobfuscator;
    private static Mappings m_mappings;
    private static Translator m_deobfTranslator;
    private static Translator m_obfTranslator;

    @BeforeClass
    public static void beforeClass() throws Exception {
        m_deobfuscator = new Deobfuscator(new JarFile("build/testTranslation.obf.jar"));
        Throwable throwable = null;
        Object var1_2 = null;
        try (InputStream in = TestTranslator.class.getResourceAsStream("/cuchaz/enigma/resources/translation.mappings");){
            m_mappings = new MappingsReader().read(new InputStreamReader(in));
            m_deobfuscator.setMappings(m_mappings);
            m_deobfTranslator = m_deobfuscator.getTranslator(TranslationDirection.Deobfuscating);
            m_obfTranslator = m_deobfuscator.getTranslator(TranslationDirection.Obfuscating);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void basicClasses() {
        this.assertMapping(TestEntryFactory.newClass("none/a"), TestEntryFactory.newClass("deobf/A_Basic"));
        this.assertMapping(TestEntryFactory.newClass("none/b"), TestEntryFactory.newClass("deobf/B_BaseClass"));
        this.assertMapping(TestEntryFactory.newClass("none/c"), TestEntryFactory.newClass("deobf/C_SubClass"));
    }

    @Test
    public void basicFields() {
        this.assertMapping(TestEntryFactory.newField("none/a", "a", "I"), TestEntryFactory.newField("deobf/A_Basic", "f1", "I"));
        this.assertMapping(TestEntryFactory.newField("none/a", "a", "F"), TestEntryFactory.newField("deobf/A_Basic", "f2", "F"));
        this.assertMapping(TestEntryFactory.newField("none/a", "a", "Ljava/lang/String;"), TestEntryFactory.newField("deobf/A_Basic", "f3", "Ljava/lang/String;"));
    }

    @Test
    public void basicMethods() {
        this.assertMapping(TestEntryFactory.newMethod("none/a", "a", "()V"), TestEntryFactory.newMethod("deobf/A_Basic", "m1", "()V"));
        this.assertMapping(TestEntryFactory.newMethod("none/a", "a", "()I"), TestEntryFactory.newMethod("deobf/A_Basic", "m2", "()I"));
        this.assertMapping(TestEntryFactory.newMethod("none/a", "a", "(I)V"), TestEntryFactory.newMethod("deobf/A_Basic", "m3", "(I)V"));
        this.assertMapping(TestEntryFactory.newMethod("none/a", "a", "(I)I"), TestEntryFactory.newMethod("deobf/A_Basic", "m4", "(I)I"));
    }

    @Test
    public void inheritanceFields() {
        this.assertMapping(TestEntryFactory.newField("none/b", "a", "I"), TestEntryFactory.newField("deobf/B_BaseClass", "f1", "I"));
        this.assertMapping(TestEntryFactory.newField("none/b", "a", "C"), TestEntryFactory.newField("deobf/B_BaseClass", "f2", "C"));
        this.assertMapping(TestEntryFactory.newField("none/c", "b", "I"), TestEntryFactory.newField("deobf/C_SubClass", "f3", "I"));
        this.assertMapping(TestEntryFactory.newField("none/c", "c", "I"), TestEntryFactory.newField("deobf/C_SubClass", "f4", "I"));
    }

    @Test
    public void inheritanceFieldsShadowing() {
        this.assertMapping(TestEntryFactory.newField("none/c", "b", "C"), TestEntryFactory.newField("deobf/C_SubClass", "f2", "C"));
    }

    @Test
    public void inheritanceFieldsBySubClass() {
        this.assertMapping(TestEntryFactory.newField("none/c", "a", "I"), TestEntryFactory.newField("deobf/C_SubClass", "f1", "I"));
    }

    @Test
    public void inheritanceMethods() {
        this.assertMapping(TestEntryFactory.newMethod("none/b", "a", "()I"), TestEntryFactory.newMethod("deobf/B_BaseClass", "m1", "()I"));
        this.assertMapping(TestEntryFactory.newMethod("none/b", "b", "()I"), TestEntryFactory.newMethod("deobf/B_BaseClass", "m2", "()I"));
        this.assertMapping(TestEntryFactory.newMethod("none/c", "c", "()I"), TestEntryFactory.newMethod("deobf/C_SubClass", "m3", "()I"));
    }

    @Test
    public void inheritanceMethodsOverrides() {
        this.assertMapping(TestEntryFactory.newMethod("none/c", "a", "()I"), TestEntryFactory.newMethod("deobf/C_SubClass", "m1", "()I"));
    }

    @Test
    public void inheritanceMethodsBySubClass() {
        this.assertMapping(TestEntryFactory.newMethod("none/c", "b", "()I"), TestEntryFactory.newMethod("deobf/C_SubClass", "m2", "()I"));
    }

    private void assertMapping(Entry obf, Entry deobf) {
        MatcherAssert.assertThat((Object)m_deobfTranslator.translateEntry(obf), (Matcher)Matchers.is((Object)deobf));
        MatcherAssert.assertThat((Object)m_obfTranslator.translateEntry(deobf), (Matcher)Matchers.is((Object)obf));
    }
}

