/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.TestEntryFactory;
import cuchaz.enigma.analysis.Access;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.MethodEntry;
import java.util.Collection;
import java.util.Set;
import java.util.jar.JarFile;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class TestJarIndexInheritanceTree {
    private JarIndex m_index;
    private ClassEntry m_baseClass = TestEntryFactory.newClass("none/a");
    private ClassEntry m_subClassA = TestEntryFactory.newClass("none/b");
    private ClassEntry m_subClassAA = TestEntryFactory.newClass("none/d");
    private ClassEntry m_subClassB = TestEntryFactory.newClass("none/c");
    private FieldEntry m_nameField = TestEntryFactory.newField(this.m_baseClass, "a", "Ljava/lang/String;");
    private FieldEntry m_numThingsField = TestEntryFactory.newField(this.m_subClassB, "a", "I");

    public TestJarIndexInheritanceTree() throws Exception {
        this.m_index = new JarIndex();
        this.m_index.indexJar(new JarFile("build/testInheritanceTree.obf.jar"), false);
    }

    @Test
    public void obfEntries() {
        MatcherAssert.assertThat(this.m_index.getObfClassEntries(), (Matcher)Matchers.containsInAnyOrder((Object[])new ClassEntry[]{TestEntryFactory.newClass("cuchaz/enigma/inputs/Keep"), this.m_baseClass, this.m_subClassA, this.m_subClassAA, this.m_subClassB}));
    }

    @Test
    public void translationIndex() {
        TranslationIndex index = this.m_index.getTranslationIndex();
        MatcherAssert.assertThat((Object)index.getSuperclass(this.m_baseClass), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat(index.getAncestry(this.m_baseClass), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(index.getSubclass(this.m_baseClass), (Matcher)Matchers.containsInAnyOrder((Object[])new ClassEntry[]{this.m_subClassA, this.m_subClassB}));
        MatcherAssert.assertThat((Object)index.getSuperclass(this.m_subClassA), (Matcher)Matchers.is((Object)this.m_baseClass));
        MatcherAssert.assertThat(index.getAncestry(this.m_subClassA), (Matcher)Matchers.contains((Object[])new ClassEntry[]{this.m_baseClass}));
        MatcherAssert.assertThat(index.getSubclass(this.m_subClassA), (Matcher)Matchers.contains((Object[])new ClassEntry[]{this.m_subClassAA}));
        MatcherAssert.assertThat((Object)index.getSuperclass(this.m_subClassAA), (Matcher)Matchers.is((Object)this.m_subClassA));
        MatcherAssert.assertThat(index.getAncestry(this.m_subClassAA), (Matcher)Matchers.contains((Object[])new ClassEntry[]{this.m_subClassA, this.m_baseClass}));
        MatcherAssert.assertThat(index.getSubclass(this.m_subClassAA), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)index.getSuperclass(this.m_subClassB), (Matcher)Matchers.is((Object)this.m_baseClass));
        MatcherAssert.assertThat(index.getAncestry(this.m_subClassB), (Matcher)Matchers.contains((Object[])new ClassEntry[]{this.m_baseClass}));
        MatcherAssert.assertThat(index.getSubclass(this.m_subClassB), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void access() {
        MatcherAssert.assertThat((Object)((Object)this.m_index.getAccess(this.m_nameField)), (Matcher)Matchers.is((Object)((Object)Access.Private)));
        MatcherAssert.assertThat((Object)((Object)this.m_index.getAccess(this.m_numThingsField)), (Matcher)Matchers.is((Object)((Object)Access.Private)));
    }

    @Test
    public void relatedMethodImplementations() {
        Set<MethodEntry> entries = this.m_index.getRelatedMethodImplementations(TestEntryFactory.newMethod(this.m_baseClass, "a", "()Ljava/lang/String;"));
        MatcherAssert.assertThat(entries, (Matcher)Matchers.containsInAnyOrder((Object[])new MethodEntry[]{TestEntryFactory.newMethod(this.m_baseClass, "a", "()Ljava/lang/String;"), TestEntryFactory.newMethod(this.m_subClassAA, "a", "()Ljava/lang/String;")}));
        entries = this.m_index.getRelatedMethodImplementations(TestEntryFactory.newMethod(this.m_subClassAA, "a", "()Ljava/lang/String;"));
        MatcherAssert.assertThat(entries, (Matcher)Matchers.containsInAnyOrder((Object[])new MethodEntry[]{TestEntryFactory.newMethod(this.m_baseClass, "a", "()Ljava/lang/String;"), TestEntryFactory.newMethod(this.m_subClassAA, "a", "()Ljava/lang/String;")}));
        entries = this.m_index.getRelatedMethodImplementations(TestEntryFactory.newMethod(this.m_baseClass, "a", "()V"));
        MatcherAssert.assertThat(entries, (Matcher)Matchers.containsInAnyOrder((Object[])new MethodEntry[]{TestEntryFactory.newMethod(this.m_baseClass, "a", "()V"), TestEntryFactory.newMethod(this.m_subClassAA, "a", "()V"), TestEntryFactory.newMethod(this.m_subClassB, "a", "()V")}));
        entries = this.m_index.getRelatedMethodImplementations(TestEntryFactory.newMethod(this.m_subClassAA, "a", "()V"));
        MatcherAssert.assertThat(entries, (Matcher)Matchers.containsInAnyOrder((Object[])new MethodEntry[]{TestEntryFactory.newMethod(this.m_baseClass, "a", "()V"), TestEntryFactory.newMethod(this.m_subClassAA, "a", "()V"), TestEntryFactory.newMethod(this.m_subClassB, "a", "()V")}));
        entries = this.m_index.getRelatedMethodImplementations(TestEntryFactory.newMethod(this.m_subClassB, "a", "()V"));
        MatcherAssert.assertThat(entries, (Matcher)Matchers.containsInAnyOrder((Object[])new MethodEntry[]{TestEntryFactory.newMethod(this.m_baseClass, "a", "()V"), TestEntryFactory.newMethod(this.m_subClassAA, "a", "()V"), TestEntryFactory.newMethod(this.m_subClassB, "a", "()V")}));
        entries = this.m_index.getRelatedMethodImplementations(TestEntryFactory.newMethod(this.m_subClassB, "b", "()V"));
        MatcherAssert.assertThat(entries, (Matcher)Matchers.containsInAnyOrder((Object[])new MethodEntry[]{TestEntryFactory.newMethod(this.m_subClassB, "b", "()V")}));
    }

    @Test
    public void fieldReferences() {
        Collection<EntryReference<FieldEntry, BehaviorEntry>> references = this.m_index.getFieldReferences(this.m_nameField);
        MatcherAssert.assertThat(references, (Matcher)Matchers.containsInAnyOrder((Object[])new EntryReference[]{TestEntryFactory.newFieldReferenceByConstructor(this.m_nameField, this.m_baseClass.getName(), "(Ljava/lang/String;)V"), TestEntryFactory.newFieldReferenceByMethod(this.m_nameField, this.m_baseClass.getName(), "a", "()Ljava/lang/String;")}));
        references = this.m_index.getFieldReferences(this.m_numThingsField);
        MatcherAssert.assertThat(references, (Matcher)Matchers.containsInAnyOrder((Object[])new EntryReference[]{TestEntryFactory.newFieldReferenceByConstructor(this.m_numThingsField, this.m_subClassB.getName(), "()V"), TestEntryFactory.newFieldReferenceByMethod(this.m_numThingsField, this.m_subClassB.getName(), "b", "()V")}));
    }

    @Test
    public void behaviorReferences() {
        BehaviorEntry source = TestEntryFactory.newConstructor(this.m_baseClass, "(Ljava/lang/String;)V");
        Collection<EntryReference<BehaviorEntry, BehaviorEntry>> references = this.m_index.getBehaviorReferences(source);
        MatcherAssert.assertThat(references, (Matcher)Matchers.containsInAnyOrder((Object[])new EntryReference[]{TestEntryFactory.newBehaviorReferenceByConstructor(source, this.m_subClassA.getName(), "(Ljava/lang/String;)V"), TestEntryFactory.newBehaviorReferenceByConstructor(source, this.m_subClassB.getName(), "()V")}));
        source = TestEntryFactory.newConstructor(this.m_subClassA, "(Ljava/lang/String;)V");
        references = this.m_index.getBehaviorReferences(source);
        MatcherAssert.assertThat(references, (Matcher)Matchers.containsInAnyOrder((Object[])new EntryReference[]{TestEntryFactory.newBehaviorReferenceByConstructor(source, this.m_subClassAA.getName(), "()V")}));
        source = TestEntryFactory.newMethod(this.m_baseClass, "a", "()Ljava/lang/String;");
        references = this.m_index.getBehaviorReferences(source);
        MatcherAssert.assertThat(references, (Matcher)Matchers.containsInAnyOrder((Object[])new EntryReference[]{TestEntryFactory.newBehaviorReferenceByMethod(source, this.m_subClassAA.getName(), "a", "()Ljava/lang/String;"), TestEntryFactory.newBehaviorReferenceByMethod(source, this.m_subClassB.getName(), "a", "()V")}));
        source = TestEntryFactory.newMethod(this.m_subClassAA, "a", "()Ljava/lang/String;");
        references = this.m_index.getBehaviorReferences(source);
        MatcherAssert.assertThat(references, (Matcher)Matchers.containsInAnyOrder((Object[])new EntryReference[]{TestEntryFactory.newBehaviorReferenceByMethod(source, this.m_subClassAA.getName(), "a", "()V")}));
    }

    @Test
    public void containsEntries() {
        MatcherAssert.assertThat((Object)this.m_index.containsObfClass(this.m_baseClass), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.containsObfClass(this.m_subClassA), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.containsObfClass(this.m_subClassAA), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.containsObfClass(this.m_subClassB), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.containsObfField(this.m_nameField), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.containsObfField(this.m_numThingsField), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.containsObfBehavior(TestEntryFactory.newMethod(this.m_baseClass, "a", "()Ljava/lang/String;")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.containsObfBehavior(TestEntryFactory.newMethod(this.m_subClassA, "a", "()Ljava/lang/String;")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.m_index.containsObfBehavior(TestEntryFactory.newMethod(this.m_subClassAA, "a", "()Ljava/lang/String;")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.containsObfBehavior(TestEntryFactory.newMethod(this.m_subClassB, "a", "()Ljava/lang/String;")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.m_index.containsObfBehavior(TestEntryFactory.newMethod(this.m_baseClass, "a", "()V")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.containsObfBehavior(TestEntryFactory.newMethod(this.m_subClassA, "a", "()V")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.m_index.containsObfBehavior(TestEntryFactory.newMethod(this.m_subClassAA, "a", "()V")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.containsObfBehavior(TestEntryFactory.newMethod(this.m_subClassB, "a", "()V")), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.m_index.containsObfBehavior(TestEntryFactory.newMethod(this.m_baseClass, "b", "()V")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.m_index.containsObfBehavior(TestEntryFactory.newMethod(this.m_subClassA, "b", "()V")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.m_index.containsObfBehavior(TestEntryFactory.newMethod(this.m_subClassAA, "b", "()V")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.m_index.containsObfBehavior(TestEntryFactory.newMethod(this.m_subClassB, "b", "()V")), (Matcher)Matchers.is((Object)true));
    }
}

