/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.analysis.JarIndex;
import java.util.jar.JarFile;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class TestInnerClasses {
    private JarIndex m_index = new JarIndex();
    private Deobfuscator m_deobfuscator;
    private static final String AnonymousOuter = "none/a";
    private static final String AnonymousInner = "b";
    private static final String SimpleOuter = "none/g";
    private static final String SimpleInner = "h";
    private static final String ConstructorArgsOuter = "none/e";
    private static final String ConstructorArgsInner = "f";
    private static final String AnonymousWithScopeArgsOuter = "none/c";
    private static final String AnonymousWithScopeArgsInner = "d";
    private static final String AnonymousWithOuterAccessOuter = "none/i";
    private static final String AnonymousWithOuterAccessInner = "j";

    public TestInnerClasses() throws Exception {
        JarFile jar = new JarFile("build/testInnerClasses.obf.jar");
        this.m_index.indexJar(jar, true);
        this.m_deobfuscator = new Deobfuscator(jar);
    }

    @Test
    public void simple() {
        MatcherAssert.assertThat((Object)this.m_index.getOuterClass(SimpleInner), (Matcher)Matchers.is((Object)SimpleOuter));
        MatcherAssert.assertThat(this.m_index.getInnerClasses(SimpleOuter), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{SimpleInner}));
        MatcherAssert.assertThat((Object)this.m_index.isAnonymousClass(SimpleInner), (Matcher)Matchers.is((Object)false));
        this.decompile(SimpleOuter);
    }

    @Test
    public void anonymous() {
        MatcherAssert.assertThat((Object)this.m_index.getOuterClass(AnonymousInner), (Matcher)Matchers.is((Object)AnonymousOuter));
        MatcherAssert.assertThat(this.m_index.getInnerClasses(AnonymousOuter), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{AnonymousInner}));
        MatcherAssert.assertThat((Object)this.m_index.isAnonymousClass(AnonymousInner), (Matcher)Matchers.is((Object)true));
        this.decompile(AnonymousOuter);
    }

    @Test
    public void constructorArgs() {
        MatcherAssert.assertThat((Object)this.m_index.getOuterClass(ConstructorArgsInner), (Matcher)Matchers.is((Object)ConstructorArgsOuter));
        MatcherAssert.assertThat(this.m_index.getInnerClasses(ConstructorArgsOuter), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{ConstructorArgsInner}));
        MatcherAssert.assertThat((Object)this.m_index.isAnonymousClass(ConstructorArgsInner), (Matcher)Matchers.is((Object)false));
        this.decompile(ConstructorArgsOuter);
    }

    @Test
    public void anonymousWithScopeArgs() {
        MatcherAssert.assertThat((Object)this.m_index.getOuterClass(AnonymousWithScopeArgsInner), (Matcher)Matchers.is((Object)AnonymousWithScopeArgsOuter));
        MatcherAssert.assertThat(this.m_index.getInnerClasses(AnonymousWithScopeArgsOuter), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{AnonymousWithScopeArgsInner}));
        MatcherAssert.assertThat((Object)this.m_index.isAnonymousClass(AnonymousWithScopeArgsInner), (Matcher)Matchers.is((Object)true));
        this.decompile(AnonymousWithScopeArgsOuter);
    }

    @Test
    public void anonymousWithOuterAccess() {
        MatcherAssert.assertThat((Object)this.m_index.getOuterClass(AnonymousWithOuterAccessInner), (Matcher)Matchers.is((Object)AnonymousWithOuterAccessOuter));
        MatcherAssert.assertThat(this.m_index.getInnerClasses(AnonymousWithOuterAccessOuter), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{AnonymousWithOuterAccessInner}));
        MatcherAssert.assertThat((Object)this.m_index.isAnonymousClass(AnonymousWithOuterAccessInner), (Matcher)Matchers.is((Object)true));
        this.decompile(AnonymousWithOuterAccessOuter);
    }

    private void decompile(String name) {
        this.m_deobfuscator.getSourceTree(name);
    }
}

