/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Maps;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassNameReplacer;
import java.io.Serializable;
import java.util.Map;

public class Type
implements Serializable {
    private static final long serialVersionUID = 7862257669347104063L;
    protected String m_name;

    public static String parseFirst(String in) {
        if (in == null || in.length() <= 0) {
            throw new IllegalArgumentException("No type to parse, input is empty!");
        }
        char c = in.charAt(0);
        if (c == 'V') {
            return "V";
        }
        Primitive primitive = Primitive.get(c);
        if (primitive != null) {
            return in.substring(0, 1);
        }
        if (c == 'L') {
            return Type.readClass(in);
        }
        if (c == 'T') {
            return Type.readClass(in);
        }
        int dim = Type.countArrayDimension(in);
        if (dim > 0) {
            String arrayType = Type.parseFirst(in.substring(dim));
            return in.substring(0, dim + arrayType.length());
        }
        throw new IllegalArgumentException("don't know how to parse: " + in);
    }

    public Type(String name) {
        if (name.charAt(0) == 'T' || name.indexOf(60) >= 0 || name.indexOf(62) >= 0) {
            throw new IllegalArgumentException("don't use with generic types or templates: " + name);
        }
        this.m_name = name;
    }

    public Type(Type other) {
        this.m_name = other.m_name;
    }

    public Type(ClassEntry classEntry) {
        this.m_name = "L" + classEntry.getClassName() + ";";
    }

    public Type(Type other, ClassNameReplacer replacer) {
        String replacedName;
        this.m_name = other.m_name;
        if (other.isClass()) {
            String replacedName2 = replacer.replace(other.getClassEntry().getClassName());
            if (replacedName2 != null) {
                this.m_name = "L" + replacedName2 + ";";
            }
        } else if (other.isArray() && other.hasClass() && (replacedName = replacer.replace(other.getClassEntry().getClassName())) != null) {
            this.m_name = String.valueOf(Type.getArrayPrefix(other.getArrayDimension())) + "L" + replacedName + ";";
        }
    }

    public String toString() {
        return this.m_name;
    }

    public boolean isVoid() {
        return this.m_name.length() == 1 && this.m_name.charAt(0) == 'V';
    }

    public boolean isPrimitive() {
        return this.m_name.length() == 1 && Primitive.get(this.m_name.charAt(0)) != null;
    }

    public Primitive getPrimitive() {
        if (!this.isPrimitive()) {
            throw new IllegalStateException("not a primitive");
        }
        return Primitive.get(this.m_name.charAt(0));
    }

    public boolean isClass() {
        return this.m_name.charAt(0) == 'L' && this.m_name.charAt(this.m_name.length() - 1) == ';';
    }

    public ClassEntry getClassEntry() {
        if (this.isClass()) {
            String name = this.m_name.substring(1, this.m_name.length() - 1);
            int pos = name.indexOf(60);
            if (pos >= 0) {
                name = name.substring(0, pos);
            }
            return new ClassEntry(name);
        }
        if (this.isArray() && this.getArrayType().isClass()) {
            return this.getArrayType().getClassEntry();
        }
        throw new IllegalStateException("type doesn't have a class");
    }

    public boolean isArray() {
        return this.m_name.charAt(0) == '[';
    }

    public int getArrayDimension() {
        if (!this.isArray()) {
            throw new IllegalStateException("not an array");
        }
        return Type.countArrayDimension(this.m_name);
    }

    public Type getArrayType() {
        if (!this.isArray()) {
            throw new IllegalStateException("not an array");
        }
        return new Type(this.m_name.substring(this.getArrayDimension(), this.m_name.length()));
    }

    private static String getArrayPrefix(int dimension) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < dimension) {
            buf.append("[");
            ++i;
        }
        return buf.toString();
    }

    public boolean hasClass() {
        return this.isClass() || this.isArray() && this.getArrayType().hasClass();
    }

    public boolean equals(Object other) {
        if (other instanceof Type) {
            return this.equals((Type)other);
        }
        return false;
    }

    public boolean equals(Type other) {
        return this.m_name.equals(other.m_name);
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    private static int countArrayDimension(String in) {
        int i = 0;
        while (i < in.length() && in.charAt(i) == '[') {
            ++i;
        }
        return i;
    }

    private static String readClass(String in) {
        StringBuilder buf = new StringBuilder();
        int depth = 0;
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            buf.append(c);
            if (c == '<') {
                ++depth;
            } else if (c == '>') {
                --depth;
            } else if (depth == 0 && c == ';') {
                return buf.toString();
            }
            ++i;
        }
        return null;
    }

    public static enum Primitive {
        Byte('B'),
        Character('C'),
        Short('S'),
        Integer('I'),
        Long('J'),
        Float('F'),
        Double('D'),
        Boolean('Z');

        private static final Map<Character, Primitive> m_lookup;
        private char m_code;

        static {
            m_lookup = Maps.newTreeMap();
            Primitive[] primitiveArray = Primitive.values();
            int n = primitiveArray.length;
            int n2 = 0;
            while (n2 < n) {
                Primitive val = primitiveArray[n2];
                m_lookup.put(java.lang.Character.valueOf(val.getCode()), val);
                ++n2;
            }
        }

        public static Primitive get(char code) {
            return m_lookup.get(java.lang.Character.valueOf(code));
        }

        private Primitive(char code) {
            this.m_code = code;
        }

        public char getCode() {
            return this.m_code;
        }
    }
}

