/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import cuchaz.enigma.mapping.ArgumentMapping;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodMapping;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MappingsWriter {
    public void write(Writer out, Mappings mappings) throws IOException {
        this.write(new PrintWriter(out), mappings);
    }

    public void write(PrintWriter out, Mappings mappings) throws IOException {
        for (ClassMapping classMapping : this.sorted(mappings.classes())) {
            this.write(out, classMapping, 0);
        }
    }

    private void write(PrintWriter out, ClassMapping classMapping, int depth) throws IOException {
        if (classMapping.getDeobfName() == null) {
            out.format("%sCLASS %s\n", this.getIndent(depth), classMapping.getObfFullName());
        } else {
            out.format("%sCLASS %s %s\n", this.getIndent(depth), classMapping.getObfFullName(), classMapping.getDeobfName());
        }
        for (ClassMapping innerClassMapping : this.sorted(classMapping.innerClasses())) {
            this.write(out, innerClassMapping, depth + 1);
        }
        for (FieldMapping fieldMapping : this.sorted(classMapping.fields())) {
            this.write(out, fieldMapping, depth + 1);
        }
        for (MethodMapping methodMapping : this.sorted(classMapping.methods())) {
            this.write(out, methodMapping, depth + 1);
        }
    }

    private void write(PrintWriter out, FieldMapping fieldMapping, int depth) throws IOException {
        out.format("%sFIELD %s %s %s\n", this.getIndent(depth), fieldMapping.getObfName(), fieldMapping.getDeobfName(), fieldMapping.getObfType().toString());
    }

    private void write(PrintWriter out, MethodMapping methodMapping, int depth) throws IOException {
        if (methodMapping.getDeobfName() == null) {
            out.format("%sMETHOD %s %s\n", this.getIndent(depth), methodMapping.getObfName(), methodMapping.getObfSignature());
        } else {
            out.format("%sMETHOD %s %s %s\n", this.getIndent(depth), methodMapping.getObfName(), methodMapping.getDeobfName(), methodMapping.getObfSignature());
        }
        for (ArgumentMapping argumentMapping : this.sorted(methodMapping.arguments())) {
            this.write(out, argumentMapping, depth + 1);
        }
    }

    private void write(PrintWriter out, ArgumentMapping argumentMapping, int depth) throws IOException {
        out.format("%sARG %d %s\n", this.getIndent(depth), argumentMapping.getIndex(), argumentMapping.getName());
    }

    private <T extends Comparable<T>> List<T> sorted(Iterable<T> classes) {
        ArrayList<Comparable> out = new ArrayList<Comparable>();
        for (Comparable t : classes) {
            out.add(t);
        }
        Collections.sort(out);
        return out;
    }

    private String getIndent(int depth) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < depth) {
            buf.append("\t");
            ++i;
        }
        return buf.toString();
    }
}

