/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.beust.jcommander.internal.Maps;
import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.analysis.RelatedMethodChecker;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodMapping;
import java.util.Map;

public class MappingsChecker {
    private JarIndex m_index;
    private RelatedMethodChecker m_relatedMethodChecker;
    private Map<ClassEntry, ClassMapping> m_droppedClassMappings;
    private Map<ClassEntry, ClassMapping> m_droppedInnerClassMappings;
    private Map<FieldEntry, FieldMapping> m_droppedFieldMappings;
    private Map<BehaviorEntry, MethodMapping> m_droppedMethodMappings;

    public MappingsChecker(JarIndex index) {
        this.m_index = index;
        this.m_relatedMethodChecker = new RelatedMethodChecker(this.m_index);
        this.m_droppedClassMappings = Maps.newHashMap();
        this.m_droppedInnerClassMappings = Maps.newHashMap();
        this.m_droppedFieldMappings = Maps.newHashMap();
        this.m_droppedMethodMappings = Maps.newHashMap();
    }

    public RelatedMethodChecker getRelatedMethodChecker() {
        return this.m_relatedMethodChecker;
    }

    public Map<ClassEntry, ClassMapping> getDroppedClassMappings() {
        return this.m_droppedClassMappings;
    }

    public Map<ClassEntry, ClassMapping> getDroppedInnerClassMappings() {
        return this.m_droppedInnerClassMappings;
    }

    public Map<FieldEntry, FieldMapping> getDroppedFieldMappings() {
        return this.m_droppedFieldMappings;
    }

    public Map<BehaviorEntry, MethodMapping> getDroppedMethodMappings() {
        return this.m_droppedMethodMappings;
    }

    public void dropBrokenMappings(Mappings mappings) {
        for (ClassMapping classMapping : Lists.newArrayList(mappings.classes())) {
            if (this.checkClassMapping(classMapping)) continue;
            mappings.removeClassMapping(classMapping);
            this.m_droppedClassMappings.put(EntryFactory.getObfClassEntry(this.m_index, classMapping), classMapping);
        }
    }

    private boolean checkClassMapping(ClassMapping classMapping) {
        ClassEntry classEntry = EntryFactory.getObfClassEntry(this.m_index, classMapping);
        if (!this.m_index.getObfClassEntries().contains(classEntry)) {
            return false;
        }
        for (FieldMapping fieldMapping : Lists.newArrayList(classMapping.fields())) {
            FieldEntry obfFieldEntry = EntryFactory.getObfFieldEntry(classMapping, fieldMapping);
            if (this.m_index.containsObfField(obfFieldEntry)) continue;
            classMapping.removeFieldMapping(fieldMapping);
            this.m_droppedFieldMappings.put(obfFieldEntry, fieldMapping);
        }
        for (MethodMapping methodMapping : Lists.newArrayList(classMapping.methods())) {
            BehaviorEntry obfBehaviorEntry = EntryFactory.getObfBehaviorEntry(classEntry, methodMapping);
            if (!this.m_index.containsObfBehavior(obfBehaviorEntry)) {
                classMapping.removeMethodMapping(methodMapping);
                this.m_droppedMethodMappings.put(obfBehaviorEntry, methodMapping);
            }
            this.m_relatedMethodChecker.checkMethod(classEntry, methodMapping);
        }
        for (ClassMapping innerClassMapping : Lists.newArrayList(classMapping.innerClasses())) {
            if (this.checkClassMapping(innerClassMapping)) continue;
            classMapping.removeInnerClassMapping(innerClassMapping);
            this.m_droppedInnerClassMappings.put(EntryFactory.getObfClassEntry(this.m_index, innerClassMapping), innerClassMapping);
        }
        return true;
    }
}

