/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.beust.jcommander.internal.Lists;
import cuchaz.enigma.mapping.Entry;
import java.io.Serializable;
import java.util.List;

public class ClassEntry
implements Entry,
Serializable {
    private static final long serialVersionUID = 4235460580973955811L;
    private String m_name;

    public ClassEntry(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Class name cannot be null!");
        }
        if (className.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Class name must be in JVM format. ie, path/to/package/class$inner : " + className);
        }
        this.m_name = className;
        if (this.isInnerClass() && this.getInnermostClassName().indexOf(47) >= 0) {
            throw new IllegalArgumentException("Inner class must not have a package: " + className);
        }
    }

    public ClassEntry(ClassEntry other) {
        this.m_name = other.m_name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getClassName() {
        return this.m_name;
    }

    @Override
    public ClassEntry getClassEntry() {
        return this;
    }

    @Override
    public ClassEntry cloneToNewClass(ClassEntry classEntry) {
        return classEntry;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof ClassEntry) {
            return this.equals((ClassEntry)other);
        }
        return false;
    }

    public boolean equals(ClassEntry other) {
        return this.m_name.equals(other.m_name);
    }

    public String toString() {
        return this.m_name;
    }

    public boolean isInnerClass() {
        return this.m_name.lastIndexOf(36) >= 0;
    }

    public List<String> getClassChainNames() {
        return Lists.newArrayList((Object[])this.m_name.split("\\$"));
    }

    public List<ClassEntry> getClassChain() {
        List entries = Lists.newArrayList();
        StringBuilder buf = new StringBuilder();
        for (String name : this.getClassChainNames()) {
            if (buf.length() > 0) {
                buf.append("$");
            }
            buf.append(name);
            entries.add(new ClassEntry(buf.toString()));
        }
        return entries;
    }

    public String getOutermostClassName() {
        if (this.isInnerClass()) {
            return this.m_name.substring(0, this.m_name.indexOf(36));
        }
        return this.m_name;
    }

    public ClassEntry getOutermostClassEntry() {
        return new ClassEntry(this.getOutermostClassName());
    }

    public String getOuterClassName() {
        if (!this.isInnerClass()) {
            throw new Error("This is not an inner class!");
        }
        return this.m_name.substring(0, this.m_name.lastIndexOf(36));
    }

    public ClassEntry getOuterClassEntry() {
        return new ClassEntry(this.getOuterClassName());
    }

    public String getInnermostClassName() {
        if (!this.isInnerClass()) {
            throw new Error("This is not an inner class!");
        }
        return this.m_name.substring(this.m_name.lastIndexOf(36) + 1);
    }

    public boolean isInDefaultPackage() {
        return this.m_name.indexOf(47) < 0;
    }

    public String getPackageName() {
        int pos = this.m_name.lastIndexOf(47);
        if (pos > 0) {
            return this.m_name.substring(0, pos);
        }
        return null;
    }

    public String getSimpleName() {
        int pos = this.m_name.lastIndexOf(47);
        if (pos > 0) {
            return this.m_name.substring(pos + 1);
        }
        return this.m_name;
    }

    public ClassEntry buildClassEntry(List<ClassEntry> classChain) {
        assert (classChain.contains(this));
        StringBuilder buf = new StringBuilder();
        for (ClassEntry chainEntry : classChain) {
            if (buf.length() == 0) {
                buf.append(chainEntry.getName());
            } else {
                buf.append("$");
                buf.append(chainEntry.isInnerClass() ? chainEntry.getInnermostClassName() : chainEntry.getSimpleName());
            }
            if (chainEntry == this) break;
        }
        return new ClassEntry(buf.toString());
    }
}

