/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.analysis.BehaviorReferenceTreeNode;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.FieldReferenceTreeNode;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.ProgressDialog;
import cuchaz.enigma.gui.ReadableToken;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.MappingParseException;
import cuchaz.enigma.mapping.MappingsReader;
import cuchaz.enigma.mapping.MappingsWriter;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.TranslationDirection;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.jar.JarFile;

public class GuiController {
    private Deobfuscator m_deobfuscator;
    private Gui m_gui;
    private SourceIndex m_index;
    private ClassEntry m_currentObfClass;
    private boolean m_isDirty;
    private Deque<EntryReference<Entry, Entry>> m_referenceStack;

    public GuiController(Gui gui) {
        this.m_gui = gui;
        this.m_deobfuscator = null;
        this.m_index = null;
        this.m_currentObfClass = null;
        this.m_isDirty = false;
        this.m_referenceStack = Queues.newArrayDeque();
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    public void openJar(JarFile jar) throws IOException {
        this.m_gui.onStartOpenJar();
        this.m_deobfuscator = new Deobfuscator(jar);
        this.m_gui.onFinishOpenJar(this.m_deobfuscator.getJarName());
        this.refreshClasses();
    }

    public void closeJar() {
        this.m_deobfuscator = null;
        this.m_gui.onCloseJar();
    }

    public void openMappings(File file) throws IOException, MappingParseException {
        FileReader in = new FileReader(file);
        this.m_deobfuscator.setMappings(new MappingsReader().read(in));
        in.close();
        this.m_isDirty = false;
        this.m_gui.setMappingsFile(file);
        this.refreshClasses();
        this.refreshCurrentClass();
    }

    public void saveMappings(File file) throws IOException {
        FileWriter out = new FileWriter(file);
        new MappingsWriter().write(out, this.m_deobfuscator.getMappings());
        out.close();
        this.m_isDirty = false;
    }

    public void closeMappings() {
        this.m_deobfuscator.setMappings(null);
        this.m_gui.setMappingsFile(null);
        this.refreshClasses();
        this.refreshCurrentClass();
    }

    public void exportSource(final File dirOut) {
        ProgressDialog.runInThread(this.m_gui.getFrame(), new ProgressDialog.ProgressRunnable(){

            @Override
            public void run(Deobfuscator.ProgressListener progress) throws Exception {
                GuiController.this.m_deobfuscator.writeSources(dirOut, progress);
            }
        });
    }

    public void exportJar(final File fileOut) {
        ProgressDialog.runInThread(this.m_gui.getFrame(), new ProgressDialog.ProgressRunnable(){

            @Override
            public void run(Deobfuscator.ProgressListener progress) {
                GuiController.this.m_deobfuscator.writeJar(fileOut, progress);
            }
        });
    }

    public Token getToken(int pos) {
        if (this.m_index == null) {
            return null;
        }
        return this.m_index.getReferenceToken(pos);
    }

    public EntryReference<Entry, Entry> getDeobfReference(Token token) {
        if (this.m_index == null) {
            return null;
        }
        return this.m_index.getDeobfReference(token);
    }

    public ReadableToken getReadableToken(Token token) {
        if (this.m_index == null) {
            return null;
        }
        return new ReadableToken(this.m_index.getLineNumber(token.start), this.m_index.getColumnNumber(token.start), this.m_index.getColumnNumber(token.end));
    }

    public boolean entryHasDeobfuscatedName(Entry deobfEntry) {
        return this.m_deobfuscator.hasDeobfuscatedName(this.m_deobfuscator.obfuscateEntry(deobfEntry));
    }

    public boolean entryIsInJar(Entry deobfEntry) {
        return this.m_deobfuscator.isObfuscatedIdentifier(this.m_deobfuscator.obfuscateEntry(deobfEntry));
    }

    public boolean referenceIsRenameable(EntryReference<Entry, Entry> deobfReference) {
        return this.m_deobfuscator.isRenameable(this.m_deobfuscator.obfuscateReference(deobfReference));
    }

    public ClassInheritanceTreeNode getClassInheritance(ClassEntry deobfClassEntry) {
        ClassEntry obfClassEntry = this.m_deobfuscator.obfuscateEntry(deobfClassEntry);
        ClassInheritanceTreeNode rootNode = this.m_deobfuscator.getJarIndex().getClassInheritance(this.m_deobfuscator.getTranslator(TranslationDirection.Deobfuscating), obfClassEntry);
        return ClassInheritanceTreeNode.findNode(rootNode, obfClassEntry);
    }

    public ClassImplementationsTreeNode getClassImplementations(ClassEntry deobfClassEntry) {
        ClassEntry obfClassEntry = this.m_deobfuscator.obfuscateEntry(deobfClassEntry);
        return this.m_deobfuscator.getJarIndex().getClassImplementations(this.m_deobfuscator.getTranslator(TranslationDirection.Deobfuscating), obfClassEntry);
    }

    public MethodInheritanceTreeNode getMethodInheritance(MethodEntry deobfMethodEntry) {
        MethodEntry obfMethodEntry = this.m_deobfuscator.obfuscateEntry(deobfMethodEntry);
        MethodInheritanceTreeNode rootNode = this.m_deobfuscator.getJarIndex().getMethodInheritance(this.m_deobfuscator.getTranslator(TranslationDirection.Deobfuscating), obfMethodEntry);
        return MethodInheritanceTreeNode.findNode(rootNode, obfMethodEntry);
    }

    public MethodImplementationsTreeNode getMethodImplementations(MethodEntry deobfMethodEntry) {
        MethodEntry obfMethodEntry = this.m_deobfuscator.obfuscateEntry(deobfMethodEntry);
        List<MethodImplementationsTreeNode> rootNodes = this.m_deobfuscator.getJarIndex().getMethodImplementations(this.m_deobfuscator.getTranslator(TranslationDirection.Deobfuscating), obfMethodEntry);
        if (rootNodes.isEmpty()) {
            return null;
        }
        if (rootNodes.size() > 1) {
            System.err.println("WARNING: Method " + deobfMethodEntry + " implements multiple interfaces. Only showing first one.");
        }
        return MethodImplementationsTreeNode.findNode(rootNodes.get(0), obfMethodEntry);
    }

    public FieldReferenceTreeNode getFieldReferences(FieldEntry deobfFieldEntry) {
        FieldEntry obfFieldEntry = this.m_deobfuscator.obfuscateEntry(deobfFieldEntry);
        FieldReferenceTreeNode rootNode = new FieldReferenceTreeNode(this.m_deobfuscator.getTranslator(TranslationDirection.Deobfuscating), obfFieldEntry);
        rootNode.load(this.m_deobfuscator.getJarIndex(), true);
        return rootNode;
    }

    public BehaviorReferenceTreeNode getMethodReferences(BehaviorEntry deobfBehaviorEntry) {
        BehaviorEntry obfBehaviorEntry = this.m_deobfuscator.obfuscateEntry(deobfBehaviorEntry);
        BehaviorReferenceTreeNode rootNode = new BehaviorReferenceTreeNode(this.m_deobfuscator.getTranslator(TranslationDirection.Deobfuscating), obfBehaviorEntry);
        rootNode.load(this.m_deobfuscator.getJarIndex(), true);
        return rootNode;
    }

    public void rename(EntryReference<Entry, Entry> deobfReference, String newName) {
        EntryReference<Entry, Entry> obfReference = this.m_deobfuscator.obfuscateReference(deobfReference);
        this.m_deobfuscator.rename(obfReference.getNameableEntry(), newName);
        this.m_isDirty = true;
        this.refreshClasses();
        this.refreshCurrentClass(obfReference);
    }

    public void removeMapping(EntryReference<Entry, Entry> deobfReference) {
        EntryReference<Entry, Entry> obfReference = this.m_deobfuscator.obfuscateReference(deobfReference);
        this.m_deobfuscator.removeMapping(obfReference.getNameableEntry());
        this.m_isDirty = true;
        this.refreshClasses();
        this.refreshCurrentClass(obfReference);
    }

    public void markAsDeobfuscated(EntryReference<Entry, Entry> deobfReference) {
        EntryReference<Entry, Entry> obfReference = this.m_deobfuscator.obfuscateReference(deobfReference);
        this.m_deobfuscator.markAsDeobfuscated(obfReference.getNameableEntry());
        this.m_isDirty = true;
        this.refreshClasses();
        this.refreshCurrentClass(obfReference);
    }

    public void openDeclaration(Entry deobfEntry) {
        if (deobfEntry == null) {
            throw new IllegalArgumentException("Entry cannot be null!");
        }
        this.openReference(new EntryReference<Entry, Entry>(deobfEntry, deobfEntry.getName()));
    }

    public void openReference(EntryReference<Entry, Entry> deobfReference) {
        if (deobfReference == null) {
            throw new IllegalArgumentException("Reference cannot be null!");
        }
        EntryReference<Entry, Entry> obfReference = this.m_deobfuscator.obfuscateReference(deobfReference);
        ClassEntry obfClassEntry = obfReference.getLocationClassEntry().getOutermostClassEntry();
        if (!this.m_deobfuscator.isObfuscatedIdentifier(obfClassEntry)) {
            throw new IllegalArgumentException("Obfuscated class " + obfClassEntry + " was not found in the jar!");
        }
        if (this.m_currentObfClass == null || !this.m_currentObfClass.equals(obfClassEntry)) {
            this.m_currentObfClass = obfClassEntry;
            this.deobfuscate(this.m_currentObfClass, obfReference);
        } else {
            this.showReference(obfReference);
        }
    }

    private void showReference(EntryReference<Entry, Entry> obfReference) {
        EntryReference<Entry, Entry> deobfReference = this.m_deobfuscator.deobfuscateReference(obfReference);
        Collection<Token> tokens = this.m_index.getReferenceTokens(deobfReference);
        if (tokens.isEmpty()) {
            System.err.println(String.format("WARNING: no tokens found for %s in %s", deobfReference, this.m_currentObfClass));
        } else {
            this.m_gui.showTokens(tokens);
        }
    }

    public void savePreviousReference(EntryReference<Entry, Entry> deobfReference) {
        this.m_referenceStack.push(this.m_deobfuscator.obfuscateReference(deobfReference));
    }

    public void openPreviousReference() {
        if (this.hasPreviousLocation()) {
            this.openReference(this.m_deobfuscator.deobfuscateReference(this.m_referenceStack.pop()));
        }
    }

    public boolean hasPreviousLocation() {
        return !this.m_referenceStack.isEmpty();
    }

    private void refreshClasses() {
        ArrayList obfClasses = Lists.newArrayList();
        ArrayList deobfClasses = Lists.newArrayList();
        this.m_deobfuscator.getSeparatedClasses(obfClasses, deobfClasses);
        this.m_gui.setObfClasses(obfClasses);
        this.m_gui.setDeobfClasses(deobfClasses);
    }

    private void refreshCurrentClass() {
        this.refreshCurrentClass(null);
    }

    private void refreshCurrentClass(EntryReference<Entry, Entry> obfReference) {
        if (this.m_currentObfClass != null) {
            this.deobfuscate(this.m_currentObfClass, obfReference);
        }
    }

    private void deobfuscate(final ClassEntry classEntry, final EntryReference<Entry, Entry> obfReference) {
        this.m_gui.setSource("(deobfuscating...)");
        new Thread(){

            @Override
            public void run() {
                CompilationUnit sourceTree = GuiController.this.m_deobfuscator.getSourceTree(classEntry.getClassName());
                if (sourceTree == null) {
                    GuiController.this.m_gui.setSource("Unable to find class: " + classEntry);
                    return;
                }
                String source = GuiController.this.m_deobfuscator.getSource(sourceTree);
                GuiController.this.m_index = GuiController.this.m_deobfuscator.getSourceIndex(sourceTree, source);
                GuiController.this.m_gui.setSource(GuiController.this.m_index.getSource());
                if (obfReference != null) {
                    GuiController.this.showReference(obfReference);
                }
                ArrayList obfuscatedTokens = Lists.newArrayList();
                ArrayList deobfuscatedTokens = Lists.newArrayList();
                ArrayList otherTokens = Lists.newArrayList();
                for (Token token : GuiController.this.m_index.referenceTokens()) {
                    EntryReference<Entry, Entry> reference = GuiController.this.m_index.getDeobfReference(token);
                    if (GuiController.this.referenceIsRenameable(reference)) {
                        if (GuiController.this.entryHasDeobfuscatedName(reference.getNameableEntry())) {
                            deobfuscatedTokens.add(token);
                            continue;
                        }
                        obfuscatedTokens.add(token);
                        continue;
                    }
                    otherTokens.add(token);
                }
                GuiController.this.m_gui.setHighlightedTokens(obfuscatedTokens, deobfuscatedTokens, otherTokens);
            }
        }.start();
    }
}

