/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.Lists;
import cuchaz.enigma.ExceptionIgnorer;
import cuchaz.enigma.analysis.BehaviorReferenceTreeNode;
import cuchaz.enigma.analysis.ClassImplementationsTreeNode;
import cuchaz.enigma.analysis.ClassInheritanceTreeNode;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.FieldReferenceTreeNode;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.ReferenceTreeNode;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.gui.AboutDialog;
import cuchaz.enigma.gui.BrowserCaret;
import cuchaz.enigma.gui.ClassSelector;
import cuchaz.enigma.gui.CodeReader;
import cuchaz.enigma.gui.CrashDialog;
import cuchaz.enigma.gui.DeobfuscatedHighlightPainter;
import cuchaz.enigma.gui.GuiController;
import cuchaz.enigma.gui.GuiTricks;
import cuchaz.enigma.gui.ObfuscatedHighlightPainter;
import cuchaz.enigma.gui.OtherHighlightPainter;
import cuchaz.enigma.gui.SelectionHighlightPainter;
import cuchaz.enigma.gui.TokenListCellRenderer;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.IllegalNameException;
import cuchaz.enigma.mapping.MappingParseException;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Signature;
import de.sciss.syntaxpane.DefaultSyntaxKit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import java.util.jar.JarFile;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Gui {
    private GuiController m_controller;
    private JFrame m_frame = new JFrame("Enigma");
    private ClassSelector m_obfClasses;
    private ClassSelector m_deobfClasses;
    private JEditorPane m_editor;
    private JPanel m_classesPanel;
    private JSplitPane m_splitClasses;
    private JPanel m_infoPanel;
    private ObfuscatedHighlightPainter m_obfuscatedHighlightPainter;
    private DeobfuscatedHighlightPainter m_deobfuscatedHighlightPainter;
    private OtherHighlightPainter m_otherHighlightPainter;
    private SelectionHighlightPainter m_selectionHighlightPainter;
    private JTree m_inheritanceTree;
    private JTree m_implementationsTree;
    private JTree m_callsTree;
    private JList<Token> m_tokens;
    private JTabbedPane m_tabs;
    private JMenuItem m_closeJarMenu;
    private JMenuItem m_openMappingsMenu;
    private JMenuItem m_saveMappingsMenu;
    private JMenuItem m_saveMappingsAsMenu;
    private JMenuItem m_closeMappingsMenu;
    private JMenuItem m_renameMenu;
    private JMenuItem m_showInheritanceMenu;
    private JMenuItem m_openEntryMenu;
    private JMenuItem m_openPreviousMenu;
    private JMenuItem m_showCallsMenu;
    private JMenuItem m_showImplementationsMenu;
    private JMenuItem m_toggleMappingMenu;
    private JMenuItem m_exportSourceMenu;
    private JMenuItem m_exportJarMenu;
    private EntryReference<Entry, Entry> m_reference;
    private JFileChooser m_jarFileChooser;
    private JFileChooser m_mappingsFileChooser;
    private JFileChooser m_exportSourceFileChooser;
    private JFileChooser m_exportJarFileChooser;

    public Gui() {
        Container pane = this.m_frame.getContentPane();
        pane.setLayout(new BorderLayout());
        if (Boolean.parseBoolean(System.getProperty("enigma.catchExceptions", "true"))) {
            CrashDialog.init(this.m_frame);
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable t) {
                    t.printStackTrace(System.err);
                    if (!ExceptionIgnorer.shouldIgnore(t)) {
                        CrashDialog.show(t);
                    }
                }
            });
        }
        this.m_controller = new GuiController(this);
        this.m_jarFileChooser = new JFileChooser();
        this.m_mappingsFileChooser = new JFileChooser();
        this.m_exportSourceFileChooser = new JFileChooser();
        this.m_exportSourceFileChooser.setFileSelectionMode(1);
        this.m_exportJarFileChooser = new JFileChooser();
        this.m_obfClasses = new ClassSelector(ClassSelector.ObfuscatedClassEntryComparator);
        this.m_obfClasses.setListener(new ClassSelector.ClassSelectionListener(){

            @Override
            public void onSelectClass(ClassEntry classEntry) {
                Gui.this.navigateTo(classEntry);
            }
        });
        JScrollPane obfScroller = new JScrollPane(this.m_obfClasses);
        JPanel obfPanel = new JPanel();
        obfPanel.setLayout(new BorderLayout());
        obfPanel.add((Component)new JLabel("Obfuscated Classes"), "North");
        obfPanel.add((Component)obfScroller, "Center");
        this.m_deobfClasses = new ClassSelector(ClassSelector.DeobfuscatedClassEntryComparator);
        this.m_deobfClasses.setListener(new ClassSelector.ClassSelectionListener(){

            @Override
            public void onSelectClass(ClassEntry classEntry) {
                Gui.this.navigateTo(classEntry);
            }
        });
        JScrollPane deobfScroller = new JScrollPane(this.m_deobfClasses);
        JPanel deobfPanel = new JPanel();
        deobfPanel.setLayout(new BorderLayout());
        deobfPanel.add((Component)new JLabel("De-obfuscated Classes"), "North");
        deobfPanel.add((Component)deobfScroller, "Center");
        this.m_splitClasses = new JSplitPane(0, true, obfPanel, deobfPanel);
        this.m_splitClasses.setResizeWeight(0.3);
        this.m_classesPanel = new JPanel();
        this.m_classesPanel.setLayout(new BorderLayout());
        this.m_classesPanel.setPreferredSize(new Dimension(250, 0));
        this.m_infoPanel = new JPanel();
        this.m_infoPanel.setLayout(new GridLayout(4, 1, 0, 0));
        this.m_infoPanel.setPreferredSize(new Dimension(0, 100));
        this.m_infoPanel.setBorder(BorderFactory.createTitledBorder("Identifier Info"));
        this.clearReference();
        DefaultSyntaxKit.initKit();
        this.m_obfuscatedHighlightPainter = new ObfuscatedHighlightPainter();
        this.m_deobfuscatedHighlightPainter = new DeobfuscatedHighlightPainter();
        this.m_otherHighlightPainter = new OtherHighlightPainter();
        this.m_selectionHighlightPainter = new SelectionHighlightPainter();
        this.m_editor = new JEditorPane();
        this.m_editor.setEditable(false);
        this.m_editor.setCaret(new BrowserCaret());
        JScrollPane sourceScroller = new JScrollPane(this.m_editor);
        this.m_editor.setContentType("text/java");
        this.m_editor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent event) {
                Gui.this.onCaretMove(event.getDot());
            }
        });
        this.m_editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                switch (event.getKeyCode()) {
                    case 82: {
                        Gui.this.m_renameMenu.doClick();
                        break;
                    }
                    case 73: {
                        Gui.this.m_showInheritanceMenu.doClick();
                        break;
                    }
                    case 77: {
                        Gui.this.m_showImplementationsMenu.doClick();
                        break;
                    }
                    case 78: {
                        Gui.this.m_openEntryMenu.doClick();
                        break;
                    }
                    case 80: {
                        Gui.this.m_openPreviousMenu.doClick();
                        break;
                    }
                    case 67: {
                        Gui.this.m_showCallsMenu.doClick();
                        break;
                    }
                    case 84: {
                        Gui.this.m_toggleMappingMenu.doClick();
                    }
                }
            }
        });
        DefaultSyntaxKit kit = (DefaultSyntaxKit)this.m_editor.getEditorKit();
        kit.toggleComponent(this.m_editor, "de.sciss.syntaxpane.components.TokenMarker");
        JPopupMenu popupMenu = new JPopupMenu();
        this.m_editor.setComponentPopupMenu(popupMenu);
        JMenuItem menu = new JMenuItem("Rename");
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Gui.this.startRename();
            }
        });
        menu.setAccelerator(KeyStroke.getKeyStroke(82, 0));
        menu.setEnabled(false);
        popupMenu.add(menu);
        this.m_renameMenu = menu;
        menu = new JMenuItem("Show Inheritance");
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Gui.this.showInheritance();
            }
        });
        menu.setAccelerator(KeyStroke.getKeyStroke(73, 0));
        menu.setEnabled(false);
        popupMenu.add(menu);
        this.m_showInheritanceMenu = menu;
        menu = new JMenuItem("Show Implementations");
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Gui.this.showImplementations();
            }
        });
        menu.setAccelerator(KeyStroke.getKeyStroke(77, 0));
        menu.setEnabled(false);
        popupMenu.add(menu);
        this.m_showImplementationsMenu = menu;
        menu = new JMenuItem("Show Calls");
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Gui.this.showCalls();
            }
        });
        menu.setAccelerator(KeyStroke.getKeyStroke(67, 0));
        menu.setEnabled(false);
        popupMenu.add(menu);
        this.m_showCallsMenu = menu;
        menu = new JMenuItem("Go to Declaration");
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Gui.this.navigateTo(((Gui)Gui.this).m_reference.entry);
            }
        });
        menu.setAccelerator(KeyStroke.getKeyStroke(78, 0));
        menu.setEnabled(false);
        popupMenu.add(menu);
        this.m_openEntryMenu = menu;
        menu = new JMenuItem("Go to previous");
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Gui.this.m_controller.openPreviousReference();
            }
        });
        menu.setAccelerator(KeyStroke.getKeyStroke(80, 0));
        menu.setEnabled(false);
        popupMenu.add(menu);
        this.m_openPreviousMenu = menu;
        menu = new JMenuItem("Mark as deobfuscated");
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Gui.this.toggleMapping();
            }
        });
        menu.setAccelerator(KeyStroke.getKeyStroke(84, 0));
        menu.setEnabled(false);
        popupMenu.add(menu);
        this.m_toggleMappingMenu = menu;
        this.m_inheritanceTree = new JTree();
        this.m_inheritanceTree.setModel(null);
        this.m_inheritanceTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    MethodInheritanceTreeNode methodNode;
                    TreePath path = Gui.this.m_inheritanceTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    Object node = path.getLastPathComponent();
                    if (node instanceof ClassInheritanceTreeNode) {
                        ClassInheritanceTreeNode classNode = (ClassInheritanceTreeNode)node;
                        Gui.this.navigateTo(new ClassEntry(classNode.getObfClassName()));
                    } else if (node instanceof MethodInheritanceTreeNode && (methodNode = (MethodInheritanceTreeNode)node).isImplemented()) {
                        Gui.this.navigateTo(methodNode.getMethodEntry());
                    }
                }
            }
        });
        JPanel inheritancePanel = new JPanel();
        inheritancePanel.setLayout(new BorderLayout());
        inheritancePanel.add(new JScrollPane(this.m_inheritanceTree));
        this.m_implementationsTree = new JTree();
        this.m_implementationsTree.setModel(null);
        this.m_implementationsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    TreePath path = Gui.this.m_implementationsTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    Object node = path.getLastPathComponent();
                    if (node instanceof ClassImplementationsTreeNode) {
                        ClassImplementationsTreeNode classNode = (ClassImplementationsTreeNode)node;
                        Gui.this.navigateTo(classNode.getClassEntry());
                    } else if (node instanceof MethodImplementationsTreeNode) {
                        MethodImplementationsTreeNode methodNode = (MethodImplementationsTreeNode)node;
                        Gui.this.navigateTo(methodNode.getMethodEntry());
                    }
                }
            }
        });
        JPanel implementationsPanel = new JPanel();
        implementationsPanel.setLayout(new BorderLayout());
        implementationsPanel.add(new JScrollPane(this.m_implementationsTree));
        this.m_callsTree = new JTree();
        this.m_callsTree.setModel(null);
        this.m_callsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    TreePath path = Gui.this.m_callsTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    Object node = path.getLastPathComponent();
                    if (node instanceof ReferenceTreeNode) {
                        ReferenceTreeNode referenceNode = (ReferenceTreeNode)node;
                        if (referenceNode.getReference() != null) {
                            Gui.this.navigateTo(referenceNode.getReference());
                        } else {
                            Gui.this.navigateTo(referenceNode.getEntry());
                        }
                    }
                }
            }
        });
        this.m_tokens = new JList();
        this.m_tokens.setCellRenderer(new TokenListCellRenderer(this.m_controller));
        this.m_tokens.setSelectionMode(0);
        this.m_tokens.setLayoutOrientation(0);
        this.m_tokens.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Token selected;
                if (event.getClickCount() == 2 && (selected = (Token)Gui.this.m_tokens.getSelectedValue()) != null) {
                    Gui.this.showToken(selected);
                }
            }
        });
        this.m_tokens.setPreferredSize(new Dimension(0, 200));
        this.m_tokens.setMinimumSize(new Dimension(0, 200));
        JSplitPane callPanel = new JSplitPane(0, true, new JScrollPane(this.m_callsTree), new JScrollPane(this.m_tokens));
        callPanel.setResizeWeight(1.0);
        callPanel.resetToPreferredSizes();
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)this.m_infoPanel, "North");
        centerPanel.add((Component)sourceScroller, "Center");
        this.m_tabs = new JTabbedPane();
        this.m_tabs.setPreferredSize(new Dimension(250, 0));
        this.m_tabs.addTab("Inheritance", inheritancePanel);
        this.m_tabs.addTab("Implementations", implementationsPanel);
        this.m_tabs.addTab("Call Graph", callPanel);
        JSplitPane splitRight = new JSplitPane(1, true, centerPanel, this.m_tabs);
        splitRight.setResizeWeight(1.0);
        splitRight.resetToPreferredSizes();
        JSplitPane splitCenter = new JSplitPane(1, true, this.m_classesPanel, splitRight);
        splitCenter.setResizeWeight(0.0);
        pane.add((Component)splitCenter, "Center");
        JMenuBar menuBar = new JMenuBar();
        this.m_frame.setJMenuBar(menuBar);
        JMenu menu2 = new JMenu("File");
        menuBar.add(menu2);
        JMenuItem item = new JMenuItem("Open Jar...");
        menu2.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Gui.this.m_jarFileChooser.showOpenDialog(Gui.this.m_frame) == 0) {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                Gui.this.m_controller.openJar(new JarFile(Gui.this.m_jarFileChooser.getSelectedFile()));
                            }
                            catch (IOException ex) {
                                throw new Error(ex);
                            }
                        }
                    }.start();
                }
            }
        });
        item = new JMenuItem("Close Jar");
        menu2.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Gui.this.m_controller.closeJar();
            }
        });
        this.m_closeJarMenu = item;
        menu2.addSeparator();
        item = new JMenuItem("Open Mappings...");
        menu2.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Gui.this.m_mappingsFileChooser.showOpenDialog(Gui.this.m_frame) == 0) {
                    try {
                        Gui.this.m_controller.openMappings(Gui.this.m_mappingsFileChooser.getSelectedFile());
                    }
                    catch (IOException ex) {
                        throw new Error(ex);
                    }
                    catch (MappingParseException ex) {
                        JOptionPane.showMessageDialog(Gui.this.m_frame, ex.getMessage());
                    }
                }
            }
        });
        this.m_openMappingsMenu = item;
        item = new JMenuItem("Save Mappings");
        menu2.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Gui.this.m_controller.saveMappings(Gui.this.m_mappingsFileChooser.getSelectedFile());
                }
                catch (IOException ex) {
                    throw new Error(ex);
                }
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.m_saveMappingsMenu = item;
        item = new JMenuItem("Save Mappings As...");
        menu2.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Gui.this.m_mappingsFileChooser.showSaveDialog(Gui.this.m_frame) == 0) {
                    try {
                        Gui.this.m_controller.saveMappings(Gui.this.m_mappingsFileChooser.getSelectedFile());
                        Gui.this.m_saveMappingsMenu.setEnabled(true);
                    }
                    catch (IOException ex) {
                        throw new Error(ex);
                    }
                }
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(83, 192));
        this.m_saveMappingsAsMenu = item;
        item = new JMenuItem("Close Mappings");
        menu2.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Gui.this.m_controller.closeMappings();
            }
        });
        this.m_closeMappingsMenu = item;
        menu2.addSeparator();
        item = new JMenuItem("Export Source...");
        menu2.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Gui.this.m_exportSourceFileChooser.showSaveDialog(Gui.this.m_frame) == 0) {
                    Gui.this.m_controller.exportSource(Gui.this.m_exportSourceFileChooser.getSelectedFile());
                }
            }
        });
        this.m_exportSourceMenu = item;
        item = new JMenuItem("Export Jar...");
        menu2.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (Gui.this.m_exportJarFileChooser.showSaveDialog(Gui.this.m_frame) == 0) {
                    Gui.this.m_controller.exportJar(Gui.this.m_exportJarFileChooser.getSelectedFile());
                }
            }
        });
        this.m_exportJarMenu = item;
        menu2.addSeparator();
        item = new JMenuItem("Exit");
        menu2.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Gui.this.close();
            }
        });
        menu2 = new JMenu("Help");
        menuBar.add(menu2);
        item = new JMenuItem("About");
        menu2.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AboutDialog.show(Gui.this.m_frame);
            }
        });
        this.onCloseJar();
        this.m_frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Gui.this.close();
            }
        });
        pane.doLayout();
        this.m_frame.setSize(1024, 576);
        this.m_frame.setMinimumSize(new Dimension(640, 480));
        this.m_frame.setVisible(true);
        this.m_frame.setDefaultCloseOperation(0);
    }

    public JFrame getFrame() {
        return this.m_frame;
    }

    public GuiController getController() {
        return this.m_controller;
    }

    public void onStartOpenJar() {
        this.m_classesPanel.removeAll();
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(new JLabel("Loading..."));
        this.m_classesPanel.add(panel);
        this.redraw();
    }

    public void onFinishOpenJar(String jarName) {
        this.m_frame.setTitle("Enigma - " + jarName);
        this.m_classesPanel.removeAll();
        this.m_classesPanel.add(this.m_splitClasses);
        this.setSource(null);
        this.m_closeJarMenu.setEnabled(true);
        this.m_openMappingsMenu.setEnabled(true);
        this.m_saveMappingsMenu.setEnabled(false);
        this.m_saveMappingsAsMenu.setEnabled(true);
        this.m_closeMappingsMenu.setEnabled(true);
        this.m_exportSourceMenu.setEnabled(true);
        this.m_exportJarMenu.setEnabled(true);
        this.redraw();
    }

    public void onCloseJar() {
        this.m_frame.setTitle("Enigma");
        this.setObfClasses(null);
        this.setDeobfClasses(null);
        this.setSource(null);
        this.m_classesPanel.removeAll();
        this.m_closeJarMenu.setEnabled(false);
        this.m_openMappingsMenu.setEnabled(false);
        this.m_saveMappingsMenu.setEnabled(false);
        this.m_saveMappingsAsMenu.setEnabled(false);
        this.m_closeMappingsMenu.setEnabled(false);
        this.m_exportSourceMenu.setEnabled(false);
        this.m_exportJarMenu.setEnabled(false);
        this.redraw();
    }

    public void setObfClasses(Collection<ClassEntry> obfClasses) {
        this.m_obfClasses.setClasses(obfClasses);
    }

    public void setDeobfClasses(Collection<ClassEntry> deobfClasses) {
        this.m_deobfClasses.setClasses(deobfClasses);
    }

    public void setMappingsFile(File file) {
        this.m_mappingsFileChooser.setSelectedFile(file);
        this.m_saveMappingsMenu.setEnabled(file != null);
    }

    public void setSource(String source) {
        this.m_editor.getHighlighter().removeAllHighlights();
        this.m_editor.setText(source);
    }

    public void showToken(Token token) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null!");
        }
        CodeReader.navigateToToken(this.m_editor, token, this.m_selectionHighlightPainter);
        this.redraw();
    }

    public void showTokens(Collection<Token> tokens) {
        Vector<Token> sortedTokens = new Vector<Token>(tokens);
        Collections.sort(sortedTokens);
        if (sortedTokens.size() > 1) {
            this.m_tokens.setListData(sortedTokens);
            this.m_tokens.setSelectedIndex(0);
        } else {
            this.m_tokens.setListData(new Vector());
        }
        this.showToken(sortedTokens.get(0));
    }

    public void setHighlightedTokens(Iterable<Token> obfuscatedTokens, Iterable<Token> deobfuscatedTokens, Iterable<Token> otherTokens) {
        this.m_editor.getHighlighter().removeAllHighlights();
        if (obfuscatedTokens != null) {
            this.setHighlightedTokens(obfuscatedTokens, this.m_obfuscatedHighlightPainter);
        }
        if (deobfuscatedTokens != null) {
            this.setHighlightedTokens(deobfuscatedTokens, this.m_deobfuscatedHighlightPainter);
        }
        if (otherTokens != null) {
            this.setHighlightedTokens(otherTokens, this.m_otherHighlightPainter);
        }
        this.redraw();
    }

    private void setHighlightedTokens(Iterable<Token> tokens, Highlighter.HighlightPainter painter) {
        for (Token token : tokens) {
            try {
                this.m_editor.getHighlighter().addHighlight(token.start, token.end, painter);
            }
            catch (BadLocationException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    private void clearReference() {
        this.m_infoPanel.removeAll();
        JLabel label = new JLabel("No identifier selected");
        GuiTricks.unboldLabel(label);
        label.setHorizontalAlignment(0);
        this.m_infoPanel.add(label);
        this.redraw();
    }

    private void showReference(EntryReference<Entry, Entry> reference) {
        if (reference == null) {
            this.clearReference();
            return;
        }
        this.m_reference = reference;
        this.m_infoPanel.removeAll();
        if (reference.entry instanceof ClassEntry) {
            this.showClassEntry((ClassEntry)this.m_reference.entry);
        } else if (this.m_reference.entry instanceof FieldEntry) {
            this.showFieldEntry((FieldEntry)this.m_reference.entry);
        } else if (this.m_reference.entry instanceof MethodEntry) {
            this.showMethodEntry((MethodEntry)this.m_reference.entry);
        } else if (this.m_reference.entry instanceof ConstructorEntry) {
            this.showConstructorEntry((ConstructorEntry)this.m_reference.entry);
        } else if (this.m_reference.entry instanceof ArgumentEntry) {
            this.showArgumentEntry((ArgumentEntry)this.m_reference.entry);
        } else {
            throw new Error("Unknown entry type: " + this.m_reference.entry.getClass().getName());
        }
        this.redraw();
    }

    private void showClassEntry(ClassEntry entry) {
        this.addNameValue(this.m_infoPanel, "Class", entry.getName());
    }

    private void showFieldEntry(FieldEntry entry) {
        this.addNameValue(this.m_infoPanel, "Field", entry.getName());
        this.addNameValue(this.m_infoPanel, "Class", entry.getClassEntry().getName());
        this.addNameValue(this.m_infoPanel, "Type", entry.getType().toString());
    }

    private void showMethodEntry(MethodEntry entry) {
        this.addNameValue(this.m_infoPanel, "Method", entry.getName());
        this.addNameValue(this.m_infoPanel, "Class", entry.getClassEntry().getName());
        this.addNameValue(this.m_infoPanel, "Signature", entry.getSignature().toString());
    }

    private void showConstructorEntry(ConstructorEntry entry) {
        this.addNameValue(this.m_infoPanel, "Constructor", entry.getClassEntry().getName());
        this.addNameValue(this.m_infoPanel, "Signature", entry.getSignature().toString());
    }

    private void showArgumentEntry(ArgumentEntry entry) {
        this.addNameValue(this.m_infoPanel, "Argument", entry.getName());
        this.addNameValue(this.m_infoPanel, "Class", entry.getClassEntry().getName());
        this.addNameValue(this.m_infoPanel, "Method", entry.getBehaviorEntry().getName());
        this.addNameValue(this.m_infoPanel, "Index", Integer.toString(entry.getIndex()));
    }

    private void addNameValue(JPanel container, String name, String value) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 6, 0));
        container.add(panel);
        JLabel label = new JLabel(String.valueOf(name) + ":", 4);
        label.setPreferredSize(new Dimension(100, label.getPreferredSize().height));
        panel.add(label);
        panel.add(GuiTricks.unboldLabel(new JLabel(value, 2)));
    }

    private void onCaretMove(int pos) {
        boolean isRenameable;
        Token token = this.m_controller.getToken(pos);
        boolean isToken = token != null;
        this.m_reference = this.m_controller.getDeobfReference(token);
        boolean isClassEntry = isToken && this.m_reference.entry instanceof ClassEntry;
        boolean isFieldEntry = isToken && this.m_reference.entry instanceof FieldEntry;
        boolean isMethodEntry = isToken && this.m_reference.entry instanceof MethodEntry;
        boolean isConstructorEntry = isToken && this.m_reference.entry instanceof ConstructorEntry;
        boolean isInJar = isToken && this.m_controller.entryIsInJar((Entry)this.m_reference.entry);
        boolean bl = isRenameable = isToken && this.m_controller.referenceIsRenameable(this.m_reference);
        if (isToken) {
            this.showReference(this.m_reference);
        } else {
            this.clearReference();
        }
        this.m_renameMenu.setEnabled(isRenameable && isToken);
        this.m_showInheritanceMenu.setEnabled(isClassEntry || isMethodEntry || isConstructorEntry);
        this.m_showImplementationsMenu.setEnabled(isClassEntry || isMethodEntry);
        this.m_showCallsMenu.setEnabled(isClassEntry || isFieldEntry || isMethodEntry || isConstructorEntry);
        this.m_openEntryMenu.setEnabled(isInJar && (isClassEntry || isFieldEntry || isMethodEntry || isConstructorEntry));
        this.m_openPreviousMenu.setEnabled(this.m_controller.hasPreviousLocation());
        this.m_toggleMappingMenu.setEnabled(isRenameable && isToken);
        if (isToken && this.m_controller.entryHasDeobfuscatedName((Entry)this.m_reference.entry)) {
            this.m_toggleMappingMenu.setText("Reset to obfuscated");
        } else {
            this.m_toggleMappingMenu.setText("Mark as deobfuscated");
        }
    }

    private void navigateTo(Entry entry) {
        if (!this.m_controller.entryIsInJar(entry)) {
            return;
        }
        if (this.m_reference != null) {
            this.m_controller.savePreviousReference(this.m_reference);
        }
        this.m_controller.openDeclaration(entry);
    }

    private void navigateTo(EntryReference<Entry, Entry> reference) {
        if (!this.m_controller.entryIsInJar(reference.getLocationClassEntry())) {
            return;
        }
        if (this.m_reference != null) {
            this.m_controller.savePreviousReference(this.m_reference);
        }
        this.m_controller.openReference(reference);
    }

    private void startRename() {
        final JTextField text = new JTextField();
        text.setText(this.m_reference.getNamableName());
        text.setPreferredSize(new Dimension(360, text.getPreferredSize().height));
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                switch (event.getKeyCode()) {
                    case 10: {
                        Gui.this.finishRename(text, true);
                        break;
                    }
                    case 27: {
                        Gui.this.finishRename(text, false);
                    }
                }
            }
        });
        JPanel panel = (JPanel)this.m_infoPanel.getComponent(0);
        panel.remove(panel.getComponentCount() - 1);
        panel.add(text);
        text.grabFocus();
        text.selectAll();
        this.redraw();
    }

    private void finishRename(JTextField text, boolean saveName) {
        String newName = text.getText();
        if (saveName && newName != null && newName.length() > 0) {
            try {
                this.m_controller.rename(this.m_reference, newName);
            }
            catch (IllegalNameException ex) {
                text.setBorder(BorderFactory.createLineBorder(Color.red, 1));
                text.setToolTipText(ex.getReason());
                GuiTricks.showToolTipNow(text);
            }
            return;
        }
        JPanel panel = (JPanel)this.m_infoPanel.getComponent(0);
        panel.remove(panel.getComponentCount() - 1);
        panel.add(GuiTricks.unboldLabel(new JLabel(this.m_reference.getNamableName(), 2)));
        this.m_editor.grabFocus();
        this.redraw();
    }

    private void showInheritance() {
        if (this.m_reference == null) {
            return;
        }
        this.m_inheritanceTree.setModel(null);
        if (this.m_reference.entry instanceof ClassEntry) {
            ClassInheritanceTreeNode classNode = this.m_controller.getClassInheritance((ClassEntry)this.m_reference.entry);
            TreePath path = this.getPathToRoot(classNode);
            this.m_inheritanceTree.setModel(new DefaultTreeModel((TreeNode)path.getPathComponent(0)));
            this.m_inheritanceTree.expandPath(path);
            this.m_inheritanceTree.setSelectionRow(this.m_inheritanceTree.getRowForPath(path));
        } else if (this.m_reference.entry instanceof MethodEntry) {
            MethodInheritanceTreeNode classNode = this.m_controller.getMethodInheritance((MethodEntry)this.m_reference.entry);
            TreePath path = this.getPathToRoot(classNode);
            this.m_inheritanceTree.setModel(new DefaultTreeModel((TreeNode)path.getPathComponent(0)));
            this.m_inheritanceTree.expandPath(path);
            this.m_inheritanceTree.setSelectionRow(this.m_inheritanceTree.getRowForPath(path));
        }
        this.m_tabs.setSelectedIndex(0);
        this.redraw();
    }

    private void showImplementations() {
        MethodImplementationsTreeNode node;
        if (this.m_reference == null) {
            return;
        }
        this.m_implementationsTree.setModel(null);
        if (this.m_reference.entry instanceof ClassEntry) {
            ClassImplementationsTreeNode node2 = this.m_controller.getClassImplementations((ClassEntry)this.m_reference.entry);
            if (node2 != null) {
                TreePath path = this.getPathToRoot(node2);
                this.m_implementationsTree.setModel(new DefaultTreeModel((TreeNode)path.getPathComponent(0)));
                this.m_implementationsTree.expandPath(path);
                this.m_implementationsTree.setSelectionRow(this.m_implementationsTree.getRowForPath(path));
            }
        } else if (this.m_reference.entry instanceof MethodEntry && (node = this.m_controller.getMethodImplementations((MethodEntry)this.m_reference.entry)) != null) {
            TreePath path = this.getPathToRoot(node);
            this.m_implementationsTree.setModel(new DefaultTreeModel((TreeNode)path.getPathComponent(0)));
            this.m_implementationsTree.expandPath(path);
            this.m_implementationsTree.setSelectionRow(this.m_implementationsTree.getRowForPath(path));
        }
        this.m_tabs.setSelectedIndex(1);
        this.redraw();
    }

    private void showCalls() {
        if (this.m_reference == null) {
            return;
        }
        if (this.m_reference.entry instanceof ClassEntry) {
            BehaviorReferenceTreeNode node = this.m_controller.getMethodReferences(new ConstructorEntry((ClassEntry)this.m_reference.entry, new Signature("()V")));
            this.m_callsTree.setModel(new DefaultTreeModel(node));
        } else if (this.m_reference.entry instanceof FieldEntry) {
            FieldReferenceTreeNode node = this.m_controller.getFieldReferences((FieldEntry)this.m_reference.entry);
            this.m_callsTree.setModel(new DefaultTreeModel(node));
        } else if (this.m_reference.entry instanceof MethodEntry) {
            BehaviorReferenceTreeNode node = this.m_controller.getMethodReferences((MethodEntry)this.m_reference.entry);
            this.m_callsTree.setModel(new DefaultTreeModel(node));
        } else if (this.m_reference.entry instanceof ConstructorEntry) {
            BehaviorReferenceTreeNode node = this.m_controller.getMethodReferences((ConstructorEntry)this.m_reference.entry);
            this.m_callsTree.setModel(new DefaultTreeModel(node));
        }
        this.m_tabs.setSelectedIndex(2);
        this.redraw();
    }

    private void toggleMapping() {
        if (this.m_controller.entryHasDeobfuscatedName((Entry)this.m_reference.entry)) {
            this.m_controller.removeMapping(this.m_reference);
        } else {
            this.m_controller.markAsDeobfuscated(this.m_reference);
        }
    }

    private TreePath getPathToRoot(TreeNode node) {
        ArrayList nodes = Lists.newArrayList();
        TreeNode n = node;
        do {
            nodes.add(n);
        } while ((n = n.getParent()) != null);
        Collections.reverse(nodes);
        return new TreePath(nodes.toArray());
    }

    private void close() {
        if (!this.m_controller.isDirty()) {
            this.m_frame.dispose();
        } else {
            Object[] options = new String[]{"Save and exit", "Discard changes", "Cancel"};
            int response = JOptionPane.showOptionDialog(this.m_frame, "Your mappings have not been saved yet. Do you want to save?", "Save your changes?", 1, 3, null, options, options[2]);
            switch (response) {
                case 0: {
                    if (this.m_mappingsFileChooser.getSelectedFile() == null && this.m_mappingsFileChooser.showSaveDialog(this.m_frame) != 0) break;
                    try {
                        this.m_controller.saveMappings(this.m_mappingsFileChooser.getSelectedFile());
                        this.m_frame.dispose();
                        break;
                    }
                    catch (IOException ex) {
                        throw new Error(ex);
                    }
                }
                case 1: {
                    this.m_frame.dispose();
                }
            }
        }
    }

    private void redraw() {
        this.m_frame.validate();
        this.m_frame.repaint();
    }
}

