/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.gui.SelectionHighlightPainter;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import de.sciss.syntaxpane.DefaultSyntaxKit;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;

public class CodeReader
extends JEditorPane {
    private static final long serialVersionUID = 3673180950485748810L;
    private static final Object m_lock = new Object();
    private SelectionHighlightPainter m_selectionHighlightPainter;
    private SourceIndex m_sourceIndex;
    private SelectionListener m_selectionListener;

    public CodeReader() {
        this.setEditable(false);
        this.setContentType("text/java");
        DefaultSyntaxKit kit = (DefaultSyntaxKit)this.getEditorKit();
        kit.toggleComponent((JEditorPane)this, "de.sciss.syntaxpane.components.TokenMarker");
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent event) {
                if (CodeReader.this.m_selectionListener != null && CodeReader.this.m_sourceIndex != null) {
                    Token token = CodeReader.this.m_sourceIndex.getReferenceToken(event.getDot());
                    if (token != null) {
                        CodeReader.this.m_selectionListener.onSelect(CodeReader.this.m_sourceIndex.getDeobfReference(token));
                    } else {
                        CodeReader.this.m_selectionListener.onSelect(null);
                    }
                }
            }
        });
        this.m_selectionHighlightPainter = new SelectionHighlightPainter();
        this.m_sourceIndex = null;
        this.m_selectionListener = null;
    }

    public void setSelectionListener(SelectionListener val) {
        this.m_selectionListener = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCode(String code) {
        Object object = m_lock;
        synchronized (object) {
            this.setText(code);
        }
    }

    public SourceIndex getSourceIndex() {
        return this.m_sourceIndex;
    }

    public void decompileClass(ClassEntry classEntry, Deobfuscator deobfuscator) {
        this.decompileClass(classEntry, deobfuscator, null);
    }

    public void decompileClass(ClassEntry classEntry, Deobfuscator deobfuscator, Runnable callback) {
        this.decompileClass(classEntry, deobfuscator, null, callback);
    }

    public void decompileClass(final ClassEntry classEntry, final Deobfuscator deobfuscator, final Boolean ignoreBadTokens, final Runnable callback) {
        if (classEntry == null) {
            this.setCode(null);
            return;
        }
        this.setCode("(decompiling...)");
        new Thread(){

            @Override
            public void run() {
                CompilationUnit sourceTree = deobfuscator.getSourceTree(classEntry.getOutermostClassName());
                String source = deobfuscator.getSource(sourceTree);
                CodeReader.this.setCode(source);
                CodeReader.this.m_sourceIndex = deobfuscator.getSourceIndex(sourceTree, source, ignoreBadTokens);
                if (callback != null) {
                    callback.run();
                }
            }
        }.start();
    }

    public void navigateToClassDeclaration(ClassEntry classEntry) {
        Token token = this.m_sourceIndex.getDeclarationToken(classEntry);
        if (token == null) {
            for (Entry entry : this.m_sourceIndex.declarations()) {
                if (!entry.getClassEntry().equals(classEntry)) continue;
                token = this.m_sourceIndex.getDeclarationToken(entry);
                break;
            }
        }
        if (token != null) {
            this.navigateToToken(token);
        } else {
            System.out.println("Unable to find declaration in source for " + classEntry);
        }
    }

    public void navigateToToken(Token token) {
        CodeReader.navigateToToken(this, token, this.m_selectionHighlightPainter);
    }

    public static void navigateToToken(final JEditorPane editor, final Token token, final Highlighter.HighlightPainter highlightPainter) {
        editor.setCaretPosition(token.start);
        editor.grabFocus();
        try {
            Rectangle start = editor.modelToView(token.start);
            Rectangle end = editor.modelToView(token.end);
            final Rectangle show = start.union(end);
            show.grow(start.width * 10, start.height * 6);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    editor.scrollRectToVisible(show);
                }
            });
        }
        catch (BadLocationException ex) {
            throw new Error(ex);
        }
        Timer timer = new Timer(200, new ActionListener(){
            private int m_counter = 0;
            private Object m_highlight = null;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (this.m_counter % 2 == 0) {
                    try {
                        this.m_highlight = editor.getHighlighter().addHighlight(token.start, token.end, highlightPainter);
                    }
                    catch (BadLocationException badLocationException) {}
                } else if (this.m_highlight != null) {
                    editor.getHighlighter().removeHighlight(this.m_highlight);
                }
                if (this.m_counter++ > 6) {
                    Timer timer = (Timer)event.getSource();
                    timer.stop();
                }
            }
        });
        timer.start();
    }

    public void setHighlightedTokens(Iterable<Token> tokens, Highlighter.HighlightPainter painter) {
        for (Token token : tokens) {
            this.setHighlightedToken(token, painter);
        }
    }

    public void setHighlightedToken(Token token, Highlighter.HighlightPainter painter) {
        try {
            this.getHighlighter().addHighlight(token.start, token.end, painter);
        }
        catch (BadLocationException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void clearHighlights() {
        this.getHighlighter().removeAllHighlights();
    }

    public static interface SelectionListener {
        public void onSelect(EntryReference<Entry, Entry> var1);
    }
}

