/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cuchaz.enigma.gui.ClassSelectorClassNode;
import cuchaz.enigma.gui.ClassSelectorPackageNode;
import cuchaz.enigma.gui.ScoredClassEntry;
import cuchaz.enigma.mapping.ClassEntry;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClassSelector
extends JTree {
    private static final long serialVersionUID = -7632046902384775977L;
    public static Comparator<ClassEntry> ObfuscatedClassEntryComparator = new Comparator<ClassEntry>(){

        @Override
        public int compare(ClassEntry a, ClassEntry b) {
            String aname = a.getName();
            String bname = a.getName();
            if (aname.length() != bname.length()) {
                return aname.length() - bname.length();
            }
            return aname.compareTo(bname);
        }
    };
    public static Comparator<ClassEntry> DeobfuscatedClassEntryComparator = new Comparator<ClassEntry>(){

        @Override
        public int compare(ClassEntry a, ClassEntry b) {
            if (a instanceof ScoredClassEntry && b instanceof ScoredClassEntry) {
                return Float.compare(((ScoredClassEntry)b).getScore(), ((ScoredClassEntry)a).getScore());
            }
            return a.getName().compareTo(b.getName());
        }
    };
    private ClassSelectionListener m_listener;
    private Comparator<ClassEntry> m_comparator;

    public ClassSelector(Comparator<ClassEntry> comparator) {
        this.m_comparator = comparator;
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        this.setModel(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                TreePath path;
                if (ClassSelector.this.m_listener != null && event.getClickCount() == 2 && (path = ClassSelector.this.getSelectionPath()) != null && path.getLastPathComponent() instanceof ClassSelectorClassNode) {
                    ClassSelectorClassNode node = (ClassSelectorClassNode)path.getLastPathComponent();
                    ClassSelector.this.m_listener.onSelectClass(node.getClassEntry());
                }
            }
        });
        this.m_listener = null;
    }

    public void setListener(ClassSelectionListener val) {
        this.m_listener = val;
    }

    public void setClasses(Collection<ClassEntry> classEntries) {
        if (classEntries == null) {
            this.setModel(null);
            return;
        }
        HashMap packages = Maps.newHashMap();
        for (ClassEntry classEntry : classEntries) {
            packages.put(classEntry.getPackageName(), null);
        }
        ArrayList sortedPackageNames = Lists.newArrayList(packages.keySet());
        Collections.sort(sortedPackageNames, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                String[] aparts = a.split("/");
                String[] bparts = b.split("/");
                int i = 0;
                while (i < aparts.length) {
                    if (i >= bparts.length) {
                        return 1;
                    }
                    int result = aparts[i].compareTo(bparts[i]);
                    if (result != 0) {
                        return result;
                    }
                    ++i;
                }
                return -1;
            }
        });
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (String packageName : sortedPackageNames) {
            ClassSelectorPackageNode node = new ClassSelectorPackageNode(packageName);
            packages.put(packageName, node);
            root.add(node);
        }
        ArrayListMultimap packagedClassEntries = ArrayListMultimap.create();
        for (ClassEntry classEntry : classEntries) {
            packagedClassEntries.put((Object)classEntry.getPackageName(), (Object)classEntry);
        }
        for (String packageName : packagedClassEntries.keySet()) {
            ArrayList classEntriesInPackage = Lists.newArrayList((Iterable)packagedClassEntries.get((Object)packageName));
            Collections.sort(classEntriesInPackage, this.m_comparator);
            for (ClassEntry classEntry : classEntriesInPackage) {
                ClassSelectorPackageNode node = (ClassSelectorPackageNode)packages.get(packageName);
                node.add(new ClassSelectorClassNode(classEntry));
            }
        }
        this.setModel(new DefaultTreeModel(root));
    }

    public ClassEntry getSelectedClass() {
        Object selectedNode;
        if (!this.isSelectionEmpty() && (selectedNode = this.getSelectionPath().getLastPathComponent()) instanceof ClassSelectorClassNode) {
            ClassSelectorClassNode classNode = (ClassSelectorClassNode)selectedNode;
            return classNode.getClassEntry();
        }
        return null;
    }

    public String getSelectedPackage() {
        if (!this.isSelectionEmpty()) {
            Object selectedNode = this.getSelectionPath().getLastPathComponent();
            if (selectedNode instanceof ClassSelectorPackageNode) {
                ClassSelectorPackageNode packageNode = (ClassSelectorPackageNode)selectedNode;
                return packageNode.getPackageName();
            }
            if (selectedNode instanceof ClassSelectorClassNode) {
                ClassSelectorClassNode classNode = (ClassSelectorClassNode)selectedNode;
                return classNode.getClassEntry().getPackageName();
            }
        }
        return null;
    }

    public Iterable<ClassSelectorPackageNode> packageNodes() {
        ArrayList nodes = Lists.newArrayList();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        Enumeration<TreeNode> children = root.children();
        while (children.hasMoreElements()) {
            ClassSelectorPackageNode packageNode = (ClassSelectorPackageNode)children.nextElement();
            nodes.add(packageNode);
        }
        return nodes;
    }

    public Iterable<ClassSelectorClassNode> classNodes(ClassSelectorPackageNode packageNode) {
        ArrayList nodes = Lists.newArrayList();
        Enumeration<TreeNode> children = packageNode.children();
        while (children.hasMoreElements()) {
            ClassSelectorClassNode classNode = (ClassSelectorClassNode)children.nextElement();
            nodes.add(classNode);
        }
        return nodes;
    }

    public void expandPackage(String packageName) {
        if (packageName == null) {
            return;
        }
        for (ClassSelectorPackageNode packageNode : this.packageNodes()) {
            if (!packageNode.getPackageName().equals(packageName)) continue;
            this.expandPath(new TreePath(new Object[]{this.getModel().getRoot(), packageNode}));
            return;
        }
    }

    public void expandAll() {
        for (ClassSelectorPackageNode packageNode : this.packageNodes()) {
            this.expandPath(new TreePath(new Object[]{this.getModel().getRoot(), packageNode}));
        }
    }

    public ClassEntry getFirstClass() {
        for (ClassSelectorPackageNode packageNode : this.packageNodes()) {
            Iterator<ClassSelectorClassNode> iterator = this.classNodes(packageNode).iterator();
            if (!iterator.hasNext()) continue;
            ClassSelectorClassNode classNode = iterator.next();
            return classNode.getClassEntry();
        }
        return null;
    }

    public ClassSelectorPackageNode getPackageNode(ClassEntry entry) {
        for (ClassSelectorPackageNode packageNode : this.packageNodes()) {
            if (!packageNode.getPackageName().equals(entry.getPackageName())) continue;
            return packageNode;
        }
        return null;
    }

    public ClassEntry getNextClass(ClassEntry entry) {
        boolean foundIt = false;
        for (ClassSelectorPackageNode packageNode : this.packageNodes()) {
            ClassSelectorClassNode classNode2;
            if (!foundIt) {
                if (!packageNode.getPackageName().equals(entry.getPackageName())) continue;
                for (ClassSelectorClassNode classNode2 : this.classNodes(packageNode)) {
                    if (!foundIt) {
                        if (!classNode2.getClassEntry().equals(entry)) continue;
                        foundIt = true;
                        continue;
                    }
                    return classNode2.getClassEntry();
                }
                continue;
            }
            Iterator<ClassSelectorClassNode> iterator = this.classNodes(packageNode).iterator();
            if (!iterator.hasNext()) continue;
            classNode2 = iterator.next();
            return classNode2.getClassEntry();
        }
        return null;
    }

    public void setSelectionClass(ClassEntry classEntry) {
        this.expandPackage(classEntry.getPackageName());
        for (ClassSelectorPackageNode packageNode : this.packageNodes()) {
            for (ClassSelectorClassNode classNode : this.classNodes(packageNode)) {
                if (!classNode.getClassEntry().equals(classEntry)) continue;
                this.setSelectionPath(new TreePath(new Object[]{this.getModel().getRoot(), packageNode, classNode}));
            }
        }
    }

    public static interface ClassSelectionListener {
        public void onSelectClass(ClassEntry var1);
    }
}

