/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class MemberMatches<T extends Entry> {
    private BiMap<T, T> m_matches = HashBiMap.create();
    private Multimap<ClassEntry, T> m_matchedSourceEntries = HashMultimap.create();
    private Multimap<ClassEntry, T> m_unmatchedSourceEntries = HashMultimap.create();
    private Multimap<ClassEntry, T> m_unmatchedDestEntries = HashMultimap.create();
    private Multimap<ClassEntry, T> m_unmatchableSourceEntries = HashMultimap.create();

    public void addMatch(T srcEntry, T destEntry) {
        boolean wasAdded;
        boolean bl = wasAdded = this.m_matches.put(srcEntry, destEntry) == null;
        assert (wasAdded);
        wasAdded = this.m_matchedSourceEntries.put((Object)srcEntry.getClassEntry(), srcEntry);
        assert (wasAdded);
    }

    public void addUnmatchedSourceEntry(T sourceEntry) {
        boolean wasAdded = this.m_unmatchedSourceEntries.put((Object)sourceEntry.getClassEntry(), sourceEntry);
        assert (wasAdded);
    }

    public void addUnmatchedSourceEntries(Iterable<T> sourceEntries) {
        for (Entry sourceEntry : sourceEntries) {
            this.addUnmatchedSourceEntry(sourceEntry);
        }
    }

    public void addUnmatchedDestEntry(T destEntry) {
        boolean wasAdded = this.m_unmatchedDestEntries.put((Object)destEntry.getClassEntry(), destEntry);
        assert (wasAdded);
    }

    public void addUnmatchedDestEntries(Iterable<T> destEntriesntries) {
        for (Entry entry : destEntriesntries) {
            this.addUnmatchedDestEntry(entry);
        }
    }

    public void addUnmatchableSourceEntry(T sourceEntry) {
        boolean wasAdded = this.m_unmatchableSourceEntries.put((Object)sourceEntry.getClassEntry(), sourceEntry);
        assert (wasAdded);
    }

    public Set<ClassEntry> getSourceClassesWithUnmatchedEntries() {
        return this.m_unmatchedSourceEntries.keySet();
    }

    public Collection<ClassEntry> getSourceClassesWithoutUnmatchedEntries() {
        HashSet out = Sets.newHashSet();
        out.addAll(this.m_matchedSourceEntries.keySet());
        out.removeAll(this.m_unmatchedSourceEntries.keySet());
        return out;
    }

    public Collection<T> getUnmatchedSourceEntries() {
        return this.m_unmatchedSourceEntries.values();
    }

    public Collection<T> getUnmatchedSourceEntries(ClassEntry sourceClass) {
        return this.m_unmatchedSourceEntries.get((Object)sourceClass);
    }

    public Collection<T> getUnmatchedDestEntries() {
        return this.m_unmatchedDestEntries.values();
    }

    public Collection<T> getUnmatchedDestEntries(ClassEntry destClass) {
        return this.m_unmatchedDestEntries.get((Object)destClass);
    }

    public Collection<T> getUnmatchableSourceEntries() {
        return this.m_unmatchableSourceEntries.values();
    }

    public boolean hasSource(T sourceEntry) {
        return this.m_matches.containsKey(sourceEntry) || this.m_unmatchedSourceEntries.containsValue(sourceEntry);
    }

    public boolean hasDest(T destEntry) {
        return this.m_matches.containsValue(destEntry) || this.m_unmatchedDestEntries.containsValue(destEntry);
    }

    public BiMap<T, T> matches() {
        return this.m_matches;
    }

    public boolean isMatchedSourceEntry(T sourceEntry) {
        return this.m_matches.containsKey(sourceEntry);
    }

    public boolean isMatchedDestEntry(T destEntry) {
        return this.m_matches.containsValue(destEntry);
    }

    public boolean isUnmatchableSourceEntry(T sourceEntry) {
        return this.m_unmatchableSourceEntries.containsEntry((Object)sourceEntry.getClassEntry(), sourceEntry);
    }

    public void makeMatch(T sourceEntry, T destEntry) {
        boolean wasRemoved = this.m_unmatchedSourceEntries.remove((Object)sourceEntry.getClassEntry(), sourceEntry);
        assert (wasRemoved);
        wasRemoved = this.m_unmatchedDestEntries.remove((Object)destEntry.getClassEntry(), destEntry);
        assert (wasRemoved);
        this.addMatch(sourceEntry, destEntry);
    }

    public boolean isMatched(T sourceEntry, T destEntry) {
        Entry match = (Entry)this.m_matches.get(sourceEntry);
        return match != null && match.equals(destEntry);
    }

    public void unmakeMatch(T sourceEntry, T destEntry) {
        boolean wasRemoved;
        boolean bl = wasRemoved = this.m_matches.remove(sourceEntry) != null;
        assert (wasRemoved);
        wasRemoved = this.m_matchedSourceEntries.remove((Object)sourceEntry.getClassEntry(), sourceEntry);
        assert (wasRemoved);
        this.addUnmatchedSourceEntry(sourceEntry);
        this.addUnmatchedDestEntry(destEntry);
    }

    public void makeSourceUnmatchable(T sourceEntry) {
        assert (!this.isMatchedSourceEntry(sourceEntry));
        boolean wasRemoved = this.m_unmatchedSourceEntries.remove((Object)sourceEntry.getClassEntry(), sourceEntry);
        assert (wasRemoved);
        this.addUnmatchableSourceEntry(sourceEntry);
    }
}

