/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.FieldEntry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FieldMatches {
    private BiMap<FieldEntry, FieldEntry> m_matches = HashBiMap.create();
    private Multimap<ClassEntry, FieldEntry> m_matchedSourceFields = HashMultimap.create();
    private Multimap<ClassEntry, FieldEntry> m_unmatchedSourceFields = HashMultimap.create();
    private Multimap<ClassEntry, FieldEntry> m_unmatchedDestFields = HashMultimap.create();
    private Multimap<ClassEntry, FieldEntry> m_unmatchableSourceFields = HashMultimap.create();

    public void addMatch(FieldEntry srcField, FieldEntry destField) {
        boolean wasAdded;
        boolean bl = wasAdded = this.m_matches.put((Object)srcField, (Object)destField) == null;
        assert (wasAdded);
        wasAdded = this.m_matchedSourceFields.put((Object)srcField.getClassEntry(), (Object)srcField);
        assert (wasAdded);
    }

    public void addUnmatchedSourceField(FieldEntry fieldEntry) {
        boolean wasAdded = this.m_unmatchedSourceFields.put((Object)fieldEntry.getClassEntry(), (Object)fieldEntry);
        assert (wasAdded);
    }

    public void addUnmatchedSourceFields(Iterable<FieldEntry> fieldEntries) {
        for (FieldEntry fieldEntry : fieldEntries) {
            this.addUnmatchedSourceField(fieldEntry);
        }
    }

    public void addUnmatchedDestField(FieldEntry fieldEntry) {
        boolean wasAdded = this.m_unmatchedDestFields.put((Object)fieldEntry.getClassEntry(), (Object)fieldEntry);
        assert (wasAdded);
    }

    public void addUnmatchedDestFields(Iterable<FieldEntry> fieldEntries) {
        for (FieldEntry fieldEntry : fieldEntries) {
            this.addUnmatchedDestField(fieldEntry);
        }
    }

    public void addUnmatchableSourceField(FieldEntry sourceField) {
        boolean wasAdded = this.m_unmatchableSourceFields.put((Object)sourceField.getClassEntry(), (Object)sourceField);
        assert (wasAdded);
    }

    public Set<ClassEntry> getSourceClassesWithUnmatchedFields() {
        return this.m_unmatchedSourceFields.keySet();
    }

    public Collection<ClassEntry> getSourceClassesWithoutUnmatchedFields() {
        HashSet out = Sets.newHashSet();
        out.addAll(this.m_matchedSourceFields.keySet());
        out.removeAll(this.m_unmatchedSourceFields.keySet());
        return out;
    }

    public Collection<FieldEntry> getUnmatchedSourceFields() {
        return this.m_unmatchedSourceFields.values();
    }

    public Collection<FieldEntry> getUnmatchedSourceFields(ClassEntry sourceClass) {
        return this.m_unmatchedSourceFields.get((Object)sourceClass);
    }

    public Collection<FieldEntry> getUnmatchedDestFields() {
        return this.m_unmatchedDestFields.values();
    }

    public Collection<FieldEntry> getUnmatchedDestFields(ClassEntry destClass) {
        return this.m_unmatchedDestFields.get((Object)destClass);
    }

    public Collection<FieldEntry> getUnmatchableSourceFields() {
        return this.m_unmatchableSourceFields.values();
    }

    public boolean hasSource(FieldEntry fieldEntry) {
        return this.m_matches.containsKey((Object)fieldEntry) || this.m_unmatchedSourceFields.containsValue((Object)fieldEntry);
    }

    public boolean hasDest(FieldEntry fieldEntry) {
        return this.m_matches.containsValue((Object)fieldEntry) || this.m_unmatchedDestFields.containsValue((Object)fieldEntry);
    }

    public BiMap<FieldEntry, FieldEntry> matches() {
        return this.m_matches;
    }

    public boolean isMatchedSourceField(FieldEntry sourceField) {
        return this.m_matches.containsKey((Object)sourceField);
    }

    public boolean isMatchedDestField(FieldEntry destField) {
        return this.m_matches.containsValue((Object)destField);
    }

    public void makeMatch(FieldEntry sourceField, FieldEntry destField) {
        boolean wasRemoved = this.m_unmatchedSourceFields.remove((Object)sourceField.getClassEntry(), (Object)sourceField);
        assert (wasRemoved);
        wasRemoved = this.m_unmatchedDestFields.remove((Object)destField.getClassEntry(), (Object)destField);
        assert (wasRemoved);
        this.addMatch(sourceField, destField);
    }

    public boolean isMatched(FieldEntry sourceField, FieldEntry destField) {
        FieldEntry match = (FieldEntry)this.m_matches.get((Object)sourceField);
        return match != null && match.equals(destField);
    }

    public void unmakeMatch(FieldEntry sourceField, FieldEntry destField) {
        boolean wasRemoved;
        boolean bl = wasRemoved = this.m_matches.remove((Object)sourceField) != null;
        assert (wasRemoved);
        wasRemoved = this.m_matchedSourceFields.remove((Object)sourceField.getClassEntry(), (Object)sourceField);
        assert (wasRemoved);
        this.addUnmatchedSourceField(sourceField);
        this.addUnmatchedDestField(destField);
    }

    public void makeSourceUnmatchable(FieldEntry sourceField) {
        assert (!this.isMatchedSourceField(sourceField));
        boolean wasRemoved = this.m_unmatchedSourceFields.remove((Object)sourceField.getClassEntry(), (Object)sourceField);
        assert (wasRemoved);
        this.addUnmatchableSourceField(sourceField);
    }
}

