/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import cuchaz.enigma.mapping.ClassEntry;
import java.util.Map;

public class ClassNamer {
    private Map<String, String> m_sourceNames = Maps.newHashMap();
    private Map<String, String> m_destNames = Maps.newHashMap();

    public ClassNamer(BiMap<ClassEntry, ClassEntry> mappings) {
        int i = 0;
        for (Map.Entry entry : mappings.entrySet()) {
            String name = String.format("M%04d", i++);
            this.m_sourceNames.put(((ClassEntry)entry.getKey()).getName(), name);
            this.m_destNames.put(((ClassEntry)entry.getValue()).getName(), name);
        }
    }

    public String getSourceName(String name) {
        return this.m_sourceNames.get(name);
    }

    public String getDestName(String name) {
        return this.m_destNames.get(name);
    }

    public SidedClassNamer getSourceNamer() {
        return new SidedClassNamer(){

            @Override
            public String getName(String name) {
                return ClassNamer.this.getSourceName(name);
            }
        };
    }

    public SidedClassNamer getDestNamer() {
        return new SidedClassNamer(){

            @Override
            public String getName(String name) {
                return ClassNamer.this.getDestName(name);
            }
        };
    }

    public static interface SidedClassNamer {
        public String getName(String var1);
    }
}

