/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cuchaz.enigma.convert.ClassForest;
import cuchaz.enigma.convert.ClassIdentifier;
import cuchaz.enigma.convert.ClassIdentity;
import cuchaz.enigma.convert.ClassMatch;
import cuchaz.enigma.mapping.ClassEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class ClassMatching {
    private ClassForest m_sourceClasses;
    private ClassForest m_destClasses;
    private BiMap<ClassEntry, ClassEntry> m_knownMatches;

    public ClassMatching(ClassIdentifier sourceIdentifier, ClassIdentifier destIdentifier) {
        this.m_sourceClasses = new ClassForest(sourceIdentifier);
        this.m_destClasses = new ClassForest(destIdentifier);
        this.m_knownMatches = HashBiMap.create();
    }

    public void addKnownMatches(BiMap<ClassEntry, ClassEntry> knownMatches) {
        this.m_knownMatches.putAll(knownMatches);
    }

    public void match(Iterable<ClassEntry> sourceClasses, Iterable<ClassEntry> destClasses) {
        for (ClassEntry sourceClass : sourceClasses) {
            if (this.m_knownMatches.containsKey((Object)sourceClass)) continue;
            this.m_sourceClasses.add(sourceClass);
        }
        for (ClassEntry destClass : destClasses) {
            if (this.m_knownMatches.containsValue((Object)destClass)) continue;
            this.m_destClasses.add(destClass);
        }
    }

    public Collection<ClassMatch> matches() {
        ArrayList matches = Lists.newArrayList();
        for (Map.Entry entry : this.m_knownMatches.entrySet()) {
            matches.add(new ClassMatch((ClassEntry)entry.getKey(), (ClassEntry)entry.getValue()));
        }
        for (ClassIdentity identity : this.m_sourceClasses.identities()) {
            matches.add(new ClassMatch(this.m_sourceClasses.getClasses(identity), this.m_destClasses.getClasses(identity)));
        }
        for (ClassIdentity identity : this.m_destClasses.identities()) {
            if (this.m_sourceClasses.containsIdentity(identity)) continue;
            matches.add(new ClassMatch(new ArrayList<ClassEntry>(), this.m_destClasses.getClasses(identity)));
        }
        return matches;
    }

    public Collection<ClassEntry> sourceClasses() {
        HashSet classes = Sets.newHashSet();
        for (ClassMatch match : this.matches()) {
            classes.addAll(match.sourceClasses);
        }
        return classes;
    }

    public Collection<ClassEntry> destClasses() {
        HashSet classes = Sets.newHashSet();
        for (ClassMatch match : this.matches()) {
            classes.addAll(match.destClasses);
        }
        return classes;
    }

    public BiMap<ClassEntry, ClassEntry> uniqueMatches() {
        HashBiMap uniqueMatches = HashBiMap.create();
        for (ClassMatch match : this.matches()) {
            if (!match.isMatched() || match.isAmbiguous()) continue;
            uniqueMatches.put((Object)match.getUniqueSource(), (Object)match.getUniqueDest());
        }
        return uniqueMatches;
    }

    public Collection<ClassMatch> ambiguousMatches() {
        ArrayList ambiguousMatches = Lists.newArrayList();
        for (ClassMatch match : this.matches()) {
            if (!match.isMatched() || !match.isAmbiguous()) continue;
            ambiguousMatches.add(match);
        }
        return ambiguousMatches;
    }

    public Collection<ClassEntry> unmatchedSourceClasses() {
        ArrayList classes = Lists.newArrayList();
        for (ClassMatch match : this.matches()) {
            if (match.isMatched() || match.sourceClasses.isEmpty()) continue;
            classes.addAll(match.sourceClasses);
        }
        return classes;
    }

    public Collection<ClassEntry> unmatchedDestClasses() {
        ArrayList classes = Lists.newArrayList();
        for (ClassMatch match : this.matches()) {
            if (match.isMatched() || match.destClasses.isEmpty()) continue;
            classes.addAll(match.destClasses);
        }
        return classes;
    }

    public String toString() {
        int numAmbiguousSource = 0;
        int numAmbiguousDest = 0;
        for (ClassMatch match : this.ambiguousMatches()) {
            numAmbiguousSource += match.sourceClasses.size();
            numAmbiguousDest += match.destClasses.size();
        }
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("%20s%8s%8s\n", "", "Source", "Dest"));
        buf.append(String.format("%20s%8d%8d\n", "Classes", this.sourceClasses().size(), this.destClasses().size()));
        buf.append(String.format("%20s%8d%8d\n", "Uniquely matched", this.uniqueMatches().size(), this.uniqueMatches().size()));
        buf.append(String.format("%20s%8d%8d\n", "Ambiguously matched", numAmbiguousSource, numAmbiguousDest));
        buf.append(String.format("%20s%8d%8d\n", "Unmatched", this.unmatchedSourceClasses().size(), this.unmatchedDestClasses().size()));
        return buf.toString();
    }
}

