/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cuchaz.enigma.convert.ClassMatch;
import cuchaz.enigma.mapping.ClassEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ClassMatches
implements Iterable<ClassMatch> {
    Collection<ClassMatch> m_matches;
    Map<ClassEntry, ClassMatch> m_matchesBySource;
    Map<ClassEntry, ClassMatch> m_matchesByDest;
    BiMap<ClassEntry, ClassEntry> m_uniqueMatches;
    Map<ClassEntry, ClassMatch> m_ambiguousMatchesBySource;
    Map<ClassEntry, ClassMatch> m_ambiguousMatchesByDest;
    Set<ClassEntry> m_unmatchedSourceClasses;
    Set<ClassEntry> m_unmatchedDestClasses;

    public ClassMatches() {
        this(new ArrayList<ClassMatch>());
    }

    public ClassMatches(Collection<ClassMatch> matches) {
        this.m_matches = matches;
        this.m_matchesBySource = Maps.newHashMap();
        this.m_matchesByDest = Maps.newHashMap();
        this.m_uniqueMatches = HashBiMap.create();
        this.m_ambiguousMatchesBySource = Maps.newHashMap();
        this.m_ambiguousMatchesByDest = Maps.newHashMap();
        this.m_unmatchedSourceClasses = Sets.newHashSet();
        this.m_unmatchedDestClasses = Sets.newHashSet();
        for (ClassMatch match : matches) {
            this.indexMatch(match);
        }
    }

    public void add(ClassMatch match) {
        this.m_matches.add(match);
        this.indexMatch(match);
    }

    public void remove(ClassMatch match) {
        for (ClassEntry sourceClass : match.sourceClasses) {
            this.m_matchesBySource.remove(sourceClass);
            this.m_uniqueMatches.remove((Object)sourceClass);
            this.m_ambiguousMatchesBySource.remove(sourceClass);
            this.m_unmatchedSourceClasses.remove(sourceClass);
        }
        for (ClassEntry destClass : match.destClasses) {
            this.m_matchesByDest.remove(destClass);
            this.m_uniqueMatches.inverse().remove((Object)destClass);
            this.m_ambiguousMatchesByDest.remove(destClass);
            this.m_unmatchedDestClasses.remove(destClass);
        }
        this.m_matches.remove(match);
    }

    public int size() {
        return this.m_matches.size();
    }

    @Override
    public Iterator<ClassMatch> iterator() {
        return this.m_matches.iterator();
    }

    private void indexMatch(ClassMatch match) {
        if (!match.isMatched()) {
            this.m_unmatchedSourceClasses.addAll(match.sourceClasses);
            this.m_unmatchedDestClasses.addAll(match.destClasses);
        } else if (match.isAmbiguous()) {
            for (ClassEntry entry : match.sourceClasses) {
                this.m_ambiguousMatchesBySource.put(entry, match);
            }
            for (ClassEntry entry : match.destClasses) {
                this.m_ambiguousMatchesByDest.put(entry, match);
            }
        } else {
            this.m_uniqueMatches.put((Object)match.getUniqueSource(), (Object)match.getUniqueDest());
        }
        for (ClassEntry entry : match.sourceClasses) {
            this.m_matchesBySource.put(entry, match);
        }
        for (ClassEntry entry : match.destClasses) {
            this.m_matchesByDest.put(entry, match);
        }
    }

    public BiMap<ClassEntry, ClassEntry> getUniqueMatches() {
        return this.m_uniqueMatches;
    }

    public Set<ClassEntry> getUnmatchedSourceClasses() {
        return this.m_unmatchedSourceClasses;
    }

    public Set<ClassEntry> getUnmatchedDestClasses() {
        return this.m_unmatchedDestClasses;
    }

    public Set<ClassEntry> getAmbiguouslyMatchedSourceClasses() {
        return this.m_ambiguousMatchesBySource.keySet();
    }

    public ClassMatch getAmbiguousMatchBySource(ClassEntry sourceClass) {
        return this.m_ambiguousMatchesBySource.get(sourceClass);
    }

    public ClassMatch getMatchBySource(ClassEntry sourceClass) {
        return this.m_matchesBySource.get(sourceClass);
    }

    public ClassMatch getMatchByDest(ClassEntry destClass) {
        return this.m_matchesByDest.get(destClass);
    }

    public void removeSource(ClassEntry sourceClass) {
        ClassMatch match = this.m_matchesBySource.get(sourceClass);
        if (match != null) {
            this.remove(match);
            match.sourceClasses.remove(sourceClass);
            if (!match.sourceClasses.isEmpty() || !match.destClasses.isEmpty()) {
                this.add(match);
            }
        }
    }

    public void removeDest(ClassEntry destClass) {
        ClassMatch match = this.m_matchesByDest.get(destClass);
        if (match != null) {
            this.remove(match);
            match.destClasses.remove(destClass);
            if (!match.sourceClasses.isEmpty() || !match.destClasses.isEmpty()) {
                this.add(match);
            }
        }
    }
}

