/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.Sets;
import cuchaz.enigma.Util;
import cuchaz.enigma.mapping.ClassEntry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ClassMatch {
    public Set<ClassEntry> sourceClasses;
    public Set<ClassEntry> destClasses;

    public ClassMatch(Collection<ClassEntry> sourceClasses, Collection<ClassEntry> destClasses) {
        this.sourceClasses = Sets.newHashSet(sourceClasses);
        this.destClasses = Sets.newHashSet(destClasses);
    }

    public ClassMatch(ClassEntry sourceClass, ClassEntry destClass) {
        this.sourceClasses = Sets.newHashSet();
        if (sourceClass != null) {
            this.sourceClasses.add(sourceClass);
        }
        this.destClasses = Sets.newHashSet();
        if (destClass != null) {
            this.destClasses.add(destClass);
        }
    }

    public boolean isMatched() {
        return this.sourceClasses.size() > 0 && this.destClasses.size() > 0;
    }

    public boolean isAmbiguous() {
        return this.sourceClasses.size() > 1 || this.destClasses.size() > 1;
    }

    public ClassEntry getUniqueSource() {
        if (this.sourceClasses.size() != 1) {
            throw new IllegalStateException("Match has ambiguous source!");
        }
        return this.sourceClasses.iterator().next();
    }

    public ClassEntry getUniqueDest() {
        if (this.destClasses.size() != 1) {
            throw new IllegalStateException("Match has ambiguous source!");
        }
        return this.destClasses.iterator().next();
    }

    public Set<ClassEntry> intersectSourceClasses(Set<ClassEntry> classes) {
        HashSet intersection = Sets.newHashSet(this.sourceClasses);
        intersection.retainAll(classes);
        return intersection;
    }

    public int hashCode() {
        return Util.combineHashesOrdered(this.sourceClasses, this.destClasses);
    }

    public boolean equals(Object other) {
        if (other instanceof ClassMatch) {
            return this.equals((ClassMatch)other);
        }
        return false;
    }

    public boolean equals(ClassMatch other) {
        return this.sourceClasses.equals(other.sourceClasses) && this.destClasses.equals(other.destClasses);
    }
}

