/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode;

import javassist.CtBehavior;
import javassist.CtClass;
import javassist.bytecode.ByteArray;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.LocalVariableAttribute;

public class LocalVariableRenamer {
    public void rename(CtClass c) {
        CtBehavior[] ctBehaviorArray = c.getDeclaredBehaviors();
        int n = ctBehaviorArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariableAttribute table;
            CtBehavior behavior = ctBehaviorArray[n2];
            CodeAttribute codeAttribute = behavior.getMethodInfo().getCodeAttribute();
            if (codeAttribute != null && (table = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable")) != null) {
                ConstPool constants = c.getClassFile().getConstPool();
                int i = 0;
                while (i < table.tableLength()) {
                    this.renameVariable(table, i, constants.addUtf8Info("v" + i));
                    ++i;
                }
            }
            ++n2;
        }
    }

    private void renameVariable(LocalVariableAttribute table, int i, int stringId) {
        ByteArray.write16bit((int)stringId, (byte[])table.get(), (int)(i * 10 + 6));
    }
}

