/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ThisReferenceExpression;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.SourceIndexVisitor;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Type;

public class SourceIndexBehaviorVisitor
extends SourceIndexVisitor {
    private BehaviorEntry m_behaviorEntry;

    public SourceIndexBehaviorVisitor(BehaviorEntry behaviorEntry) {
        this.m_behaviorEntry = behaviorEntry;
    }

    @Override
    public Void visitInvocationExpression(InvocationExpression node, SourceIndex index) {
        MemberReference ref = (MemberReference)node.getUserData(Keys.MEMBER_REFERENCE);
        ClassEntry classEntry = new ClassEntry(ref.getDeclaringType().getInternalName());
        BehaviorEntry behaviorEntry = null;
        if (ref instanceof MethodReference) {
            MethodReference methodRef = (MethodReference)ref;
            behaviorEntry = methodRef.isConstructor() ? new ConstructorEntry(classEntry, new Signature(ref.getErasedSignature())) : (methodRef.isTypeInitializer() ? new ConstructorEntry(classEntry) : new MethodEntry(classEntry, ref.getName(), new Signature(ref.getErasedSignature())));
        }
        if (behaviorEntry != null) {
            Identifier tokenNode = null;
            if (node.getTarget() instanceof MemberReferenceExpression) {
                tokenNode = ((MemberReferenceExpression)node.getTarget()).getMemberNameToken();
            } else if (node.getTarget() instanceof SuperReferenceExpression) {
                tokenNode = node.getTarget();
            } else if (node.getTarget() instanceof ThisReferenceExpression) {
                tokenNode = node.getTarget();
            }
            if (tokenNode != null) {
                index.addReference((AstNode)tokenNode, behaviorEntry, this.m_behaviorEntry);
            }
        }
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitMemberReferenceExpression(MemberReferenceExpression node, SourceIndex index) {
        MemberReference ref = (MemberReference)node.getUserData(Keys.MEMBER_REFERENCE);
        if (ref != null) {
            if (ref.getErasedSignature().indexOf(40) >= 0) {
                throw new Error("Expected a field here! got " + ref);
            }
            ClassEntry classEntry = new ClassEntry(ref.getDeclaringType().getInternalName());
            FieldEntry fieldEntry = new FieldEntry(classEntry, ref.getName(), new Type(ref.getErasedSignature()));
            index.addReference((AstNode)node.getMemberNameToken(), fieldEntry, this.m_behaviorEntry);
        }
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitSimpleType(SimpleType node, SourceIndex index) {
        TypeReference ref = (TypeReference)node.getUserData(Keys.TYPE_REFERENCE);
        if (node.getIdentifierToken().getStartLocation() != TextLocation.EMPTY) {
            ClassEntry classEntry = new ClassEntry(ref.getInternalName());
            index.addReference((AstNode)node.getIdentifierToken(), classEntry, this.m_behaviorEntry);
        }
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitParameterDeclaration(ParameterDeclaration node, SourceIndex index) {
        ParameterDefinition def = (ParameterDefinition)node.getUserData(Keys.PARAMETER_DEFINITION);
        if (def.getMethod() instanceof MethodDefinition) {
            MethodDefinition methodDef = (MethodDefinition)def.getMethod();
            BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry(methodDef);
            ArgumentEntry argumentEntry = new ArgumentEntry(behaviorEntry, def.getPosition(), node.getName());
            index.addDeclaration((AstNode)node.getNameToken(), argumentEntry);
        }
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitIdentifierExpression(IdentifierExpression node, SourceIndex index) {
        MemberReference ref = (MemberReference)node.getUserData(Keys.MEMBER_REFERENCE);
        if (ref != null) {
            ClassEntry classEntry = new ClassEntry(ref.getDeclaringType().getInternalName());
            FieldEntry fieldEntry = new FieldEntry(classEntry, ref.getName(), new Type(ref.getErasedSignature()));
            index.addReference((AstNode)node.getIdentifierToken(), fieldEntry, this.m_behaviorEntry);
        }
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitObjectCreationExpression(ObjectCreationExpression node, SourceIndex index) {
        MemberReference ref = (MemberReference)node.getUserData(Keys.MEMBER_REFERENCE);
        if (ref != null) {
            ClassEntry classEntry = new ClassEntry(ref.getDeclaringType().getInternalName());
            ConstructorEntry constructorEntry = new ConstructorEntry(classEntry, new Signature(ref.getErasedSignature()));
            if (node.getType() instanceof SimpleType) {
                SimpleType simpleTypeNode = (SimpleType)node.getType();
                index.addReference((AstNode)simpleTypeNode.getIdentifierToken(), constructorEntry, this.m_behaviorEntry);
            }
        }
        return this.recurse((AstNode)node, index);
    }
}

