/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.TranslationIndex;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Translator;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class ClassInheritanceTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 4432367405826178490L;
    private Translator m_deobfuscatingTranslator;
    private String m_obfClassName;

    public ClassInheritanceTreeNode(Translator deobfuscatingTranslator, String obfClassName) {
        this.m_deobfuscatingTranslator = deobfuscatingTranslator;
        this.m_obfClassName = obfClassName;
    }

    public String getObfClassName() {
        return this.m_obfClassName;
    }

    public String getDeobfClassName() {
        return this.m_deobfuscatingTranslator.translateClass(this.m_obfClassName);
    }

    @Override
    public String toString() {
        String deobfClassName = this.getDeobfClassName();
        if (deobfClassName != null) {
            return deobfClassName;
        }
        return this.m_obfClassName;
    }

    public void load(TranslationIndex ancestries, boolean recurse) {
        ArrayList nodes = Lists.newArrayList();
        for (ClassEntry subclassEntry : ancestries.getSubclass(new ClassEntry(this.m_obfClassName))) {
            nodes.add(new ClassInheritanceTreeNode(this.m_deobfuscatingTranslator, subclassEntry.getName()));
        }
        for (ClassInheritanceTreeNode node : nodes) {
            this.add(node);
        }
        if (recurse) {
            for (ClassInheritanceTreeNode node : nodes) {
                node.load(ancestries, true);
            }
        }
    }

    public static ClassInheritanceTreeNode findNode(ClassInheritanceTreeNode node, ClassEntry entry) {
        if (node.getObfClassName().equals(entry.getName())) {
            return node;
        }
        int i = 0;
        while (i < node.getChildCount()) {
            ClassInheritanceTreeNode foundNode = ClassInheritanceTreeNode.findNode((ClassInheritanceTreeNode)node.getChildAt(i), entry);
            if (foundNode != null) {
                return foundNode;
            }
            ++i;
        }
        return null;
    }
}

