/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.collect.Maps;
import cuchaz.enigma.analysis.JarClassIterator;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.ClassNameReplacer;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MappingsReader;
import cuchaz.enigma.mapping.MappingsWriter;
import cuchaz.enigma.mapping.Type;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarFile;
import javassist.CtClass;
import javassist.CtField;

public class MainFormatConverter {
    public static void main(String[] args) throws Exception {
        System.out.println("Getting field types from jar...");
        JarFile jar = new JarFile(String.valueOf(System.getProperty("user.home")) + "/.minecraft/versions/1.8/1.8.jar");
        HashMap fieldTypes = Maps.newHashMap();
        for (CtClass c : JarClassIterator.classes(jar)) {
            CtField[] ctFieldArray = c.getDeclaredFields();
            int n = ctFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                CtField field = ctFieldArray[n2];
                FieldEntry fieldEntry = EntryFactory.getFieldEntry(field);
                fieldTypes.put(MainFormatConverter.getFieldKey(fieldEntry), MainFormatConverter.moveClasssesOutOfDefaultPackage(fieldEntry.getType()));
                ++n2;
            }
        }
        System.out.println("Reading mappings...");
        File fileMappings = new File("../Enigma Mappings/1.8.mappings");
        MappingsReader mappingsReader = new MappingsReader(){

            @Override
            protected FieldMapping readField(String[] parts) {
                return new FieldMapping(parts[1], new Type("V"), parts[2]);
            }
        };
        Mappings mappings = mappingsReader.read(new FileReader(fileMappings));
        System.out.println("Updating field types...");
        for (ClassMapping classMapping : mappings.classes()) {
            MainFormatConverter.updateFieldsInClass(fieldTypes, classMapping);
        }
        System.out.println("Saving mappings...");
        Throwable throwable = null;
        Iterator<ClassMapping> iterator = null;
        try (FileWriter writer = new FileWriter(fileMappings);){
            new MappingsWriter().write(writer, mappings);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        System.out.println("Done!");
    }

    private static Type moveClasssesOutOfDefaultPackage(Type type) {
        return new Type(type, new ClassNameReplacer(){

            @Override
            public String replace(String className) {
                ClassEntry entry = new ClassEntry(className);
                if (entry.isInDefaultPackage()) {
                    return "none/" + className;
                }
                return null;
            }
        });
    }

    private static void updateFieldsInClass(Map<String, Type> fieldTypes, ClassMapping classMapping) throws Exception {
        for (FieldMapping fieldMapping : classMapping.fields()) {
            MainFormatConverter.setFieldType(fieldTypes, classMapping, fieldMapping);
        }
        for (ClassMapping innerClassMapping : classMapping.innerClasses()) {
            MainFormatConverter.updateFieldsInClass(fieldTypes, innerClassMapping);
        }
    }

    private static void setFieldType(Map<String, Type> fieldTypes, ClassMapping classMapping, FieldMapping fieldMapping) throws Exception {
        Type newType = fieldTypes.get(MainFormatConverter.getFieldKey(classMapping, fieldMapping));
        if (newType == null) {
            throw new Error("Can't find type for field: " + MainFormatConverter.getFieldKey(classMapping, fieldMapping));
        }
        Field field = fieldMapping.getClass().getDeclaredField("m_obfType");
        field.setAccessible(true);
        field.set(fieldMapping, newType);
    }

    private static Object getFieldKey(ClassMapping classMapping, FieldMapping fieldMapping) {
        return String.valueOf(classMapping.getObfSimpleName()) + "." + fieldMapping.getObfName();
    }

    private static String getFieldKey(FieldEntry obfFieldEntry) {
        return String.valueOf(obfFieldEntry.getClassEntry().getSimpleName()) + "." + obfFieldEntry.getName();
    }
}

