/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import com.google.common.collect.Lists;
import cuchaz.enigma.Util;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassNameReplacer;
import cuchaz.enigma.mapping.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Signature
implements Serializable {
    private static final long serialVersionUID = -5843719505729497539L;
    private List<Type> m_argumentTypes;
    private Type m_returnType;

    public Signature(String signature) {
        try {
            this.m_argumentTypes = Lists.newArrayList();
            int i = 0;
            while (i < signature.length()) {
                char c = signature.charAt(i);
                if (c == '(') {
                    assert (this.m_argumentTypes.isEmpty());
                    assert (this.m_returnType == null);
                    ++i;
                    continue;
                }
                if (c == ')') {
                    ++i;
                    break;
                }
                String type = Type.parseFirst(signature.substring(i));
                this.m_argumentTypes.add(new Type(type));
                i += type.length();
            }
            this.m_returnType = new Type(Type.parseFirst(signature.substring(i)));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to parse signature: " + signature, ex);
        }
    }

    public Signature(Signature other) {
        this.m_argumentTypes = Lists.newArrayList(other.m_argumentTypes);
        this.m_returnType = new Type(other.m_returnType);
    }

    public Signature(Signature other, ClassNameReplacer replacer) {
        this.m_argumentTypes = Lists.newArrayList(other.m_argumentTypes);
        int i = 0;
        while (i < this.m_argumentTypes.size()) {
            this.m_argumentTypes.set(i, new Type(this.m_argumentTypes.get(i), replacer));
            ++i;
        }
        this.m_returnType = new Type(other.m_returnType, replacer);
    }

    public List<Type> getArgumentTypes() {
        return this.m_argumentTypes;
    }

    public Type getReturnType() {
        return this.m_returnType;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (Type type : this.m_argumentTypes) {
            buf.append(type.toString());
        }
        buf.append(")");
        buf.append(this.m_returnType.toString());
        return buf.toString();
    }

    public Iterable<Type> types() {
        ArrayList types = Lists.newArrayList();
        types.addAll(this.m_argumentTypes);
        types.add(this.m_returnType);
        return types;
    }

    public boolean equals(Object other) {
        if (other instanceof Signature) {
            return this.equals((Signature)other);
        }
        return false;
    }

    public boolean equals(Signature other) {
        return this.m_argumentTypes.equals(other.m_argumentTypes) && this.m_returnType.equals(other.m_returnType);
    }

    public int hashCode() {
        return Util.combineHashesOrdered(this.m_argumentTypes.hashCode(), this.m_returnType.hashCode());
    }

    public boolean hasClass(ClassEntry classEntry) {
        for (Type type : this.types()) {
            if (!type.hasClass() || !type.getClassEntry().equals(classEntry)) continue;
            return true;
        }
        return false;
    }
}

