/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassNameReplacer;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.MemberMapping;
import cuchaz.enigma.mapping.NameValidator;
import cuchaz.enigma.mapping.Type;
import java.io.Serializable;

public class FieldMapping
implements Serializable,
Comparable<FieldMapping>,
MemberMapping<FieldEntry> {
    private static final long serialVersionUID = 8610742471440861315L;
    private String m_obfName;
    private String m_deobfName;
    private Type m_obfType;

    public FieldMapping(String obfName, Type obfType, String deobfName) {
        this.m_obfName = obfName;
        this.m_deobfName = NameValidator.validateFieldName(deobfName);
        this.m_obfType = obfType;
    }

    public FieldMapping(FieldMapping other, ClassNameReplacer obfClassNameReplacer) {
        this.m_obfName = other.m_obfName;
        this.m_deobfName = other.m_deobfName;
        this.m_obfType = new Type(other.m_obfType, obfClassNameReplacer);
    }

    @Override
    public String getObfName() {
        return this.m_obfName;
    }

    public void setObfName(String val) {
        this.m_obfName = NameValidator.validateFieldName(val);
    }

    public String getDeobfName() {
        return this.m_deobfName;
    }

    public void setDeobfName(String val) {
        this.m_deobfName = NameValidator.validateFieldName(val);
    }

    public Type getObfType() {
        return this.m_obfType;
    }

    public void setObfType(Type val) {
        this.m_obfType = val;
    }

    @Override
    public int compareTo(FieldMapping other) {
        return (String.valueOf(this.m_obfName) + this.m_obfType).compareTo(String.valueOf(other.m_obfName) + other.m_obfType);
    }

    public boolean renameObfClass(final String oldObfClassName, final String newObfClassName) {
        Type newType = new Type(this.m_obfType, new ClassNameReplacer(){

            @Override
            public String replace(String className) {
                if (className.equals(oldObfClassName)) {
                    return newObfClassName;
                }
                return null;
            }
        });
        if (!newType.equals(this.m_obfType)) {
            this.m_obfType = newType;
            return true;
        }
        return false;
    }

    @Override
    public FieldEntry getObfEntry(ClassEntry classEntry) {
        return new FieldEntry(classEntry, this.m_obfName, new Type(this.m_obfType));
    }
}

