/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import cuchaz.enigma.gui.GuiTricks;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CrashDialog {
    private static CrashDialog m_instance = null;
    private JFrame m_frame = new JFrame("Enigma - Crash Report");
    private JTextArea m_text;

    private CrashDialog(JFrame parent) {
        Container pane = this.m_frame.getContentPane();
        pane.setLayout(new BorderLayout());
        JLabel label = new JLabel("Enigma has crashed! =(");
        label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        pane.add((Component)label, "North");
        this.m_text = new JTextArea();
        this.m_text.setTabSize(2);
        pane.add((Component)new JScrollPane(this.m_text), "Center");
        JPanel buttonsPanel = new JPanel();
        FlowLayout buttonsLayout = new FlowLayout();
        buttonsLayout.setAlignment(2);
        buttonsPanel.setLayout(buttonsLayout);
        buttonsPanel.add(GuiTricks.unboldLabel(new JLabel("If you choose exit, you will lose any unsaved work.")));
        JButton ignoreButton = new JButton("Ignore");
        ignoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CrashDialog.this.m_frame.setVisible(false);
            }
        });
        buttonsPanel.add(ignoreButton);
        JButton exitButton = new JButton("Exit");
        exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.exit(1);
            }
        });
        buttonsPanel.add(exitButton);
        pane.add((Component)buttonsPanel, "South");
        this.m_frame.setSize(600, 400);
        this.m_frame.setLocationRelativeTo(parent);
        this.m_frame.setDefaultCloseOperation(0);
    }

    public static void init(JFrame parent) {
        m_instance = new CrashDialog(parent);
    }

    public static void show(Throwable ex) {
        StringWriter buf = new StringWriter();
        ex.printStackTrace(new PrintWriter(buf));
        String report = buf.toString();
        CrashDialog.m_instance.m_text.setText(report);
        CrashDialog.m_instance.m_frame.doLayout();
        CrashDialog.m_instance.m_frame.setVisible(true);
    }
}

