/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode;

import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.Translator;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.bytecode.ByteArray;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.LocalVariableTypeAttribute;

public class LocalVariableRenamer {
    private Translator m_translator;

    public LocalVariableRenamer(Translator translator) {
        this.m_translator = translator;
    }

    public void rename(CtClass c) {
        CtBehavior[] ctBehaviorArray = c.getDeclaredBehaviors();
        int n = ctBehaviorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtBehavior behavior = ctBehaviorArray[n2];
            CodeAttribute codeAttribute = behavior.getMethodInfo().getCodeAttribute();
            if (codeAttribute != null) {
                LocalVariableTypeAttribute typeTable;
                BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry(behavior);
                ConstPool constants = c.getClassFile().getConstPool();
                LocalVariableAttribute table = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
                if (table != null) {
                    this.renameLVT(behaviorEntry, constants, table);
                }
                if ((typeTable = (LocalVariableTypeAttribute)codeAttribute.getAttribute("LocalVariableTypeTable")) != null) {
                    this.renameLVTT(typeTable, table);
                }
            }
            ++n2;
        }
    }

    private void dumpTable(LocalVariableAttribute table) {
        int i = 0;
        while (i < table.tableLength()) {
            System.out.println(String.format("\t%d (%d): %s %s", i, table.index(i), table.variableName(i), table.descriptor(i)));
            ++i;
        }
    }

    private void renameLVT(BehaviorEntry behaviorEntry, ConstPool constants, LocalVariableAttribute table) {
        int i;
        if (table.tableLength() <= 0) {
            return;
        }
        int starti = 0;
        if (table.variableName(0).equals("this")) {
            starti = 1;
        }
        int numArgs = 0;
        if (behaviorEntry.getSignature() != null) {
            numArgs = behaviorEntry.getSignature().getArgumentTypes().size();
            i = starti;
            while (i < starti + numArgs && i < table.tableLength()) {
                int argi = i - starti;
                String argName = this.m_translator.translate(new ArgumentEntry(behaviorEntry, argi, ""));
                if (argName == null) {
                    argName = "a" + (argi + 1);
                }
                this.renameVariable(table, i, constants.addUtf8Info(argName));
                ++i;
            }
        }
        i = starti + numArgs;
        while (i < table.tableLength()) {
            int firstIndex = table.index(starti + numArgs);
            this.renameVariable(table, i, constants.addUtf8Info("v" + (table.index(i) - firstIndex + 1)));
            ++i;
        }
    }

    private void renameLVTT(LocalVariableTypeAttribute typeTable, LocalVariableAttribute table) {
        int i = 0;
        while (i < typeTable.tableLength()) {
            this.renameVariable((LocalVariableAttribute)typeTable, i, this.getNameIndex(table, typeTable.index(i)));
            ++i;
        }
    }

    private void renameVariable(LocalVariableAttribute table, int i, int stringId) {
        ByteArray.write16bit((int)stringId, (byte[])table.get(), (int)(i * 10 + 6));
    }

    private int getNameIndex(LocalVariableAttribute table, int index) {
        int i = 0;
        while (i < table.tableLength()) {
            if (table.index(i) == index) {
                return table.nameIndex(i);
            }
            ++i;
        }
        return 0;
    }
}

