/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.EntryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javassist.CtClass;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.EnclosingMethodAttribute;
import javassist.bytecode.InnerClassesAttribute;

public class InnerClassWriter {
    private JarIndex m_index;

    public InnerClassWriter(JarIndex index) {
        this.m_index = index;
    }

    public void write(CtClass c) {
        boolean isInnerClass;
        InnerClassesAttribute oldAttr = (InnerClassesAttribute)c.getClassFile().getAttribute("InnerClasses");
        if (oldAttr != null) {
            return;
        }
        ClassEntry obfClassEntry = EntryFactory.getClassEntry(c);
        List<ClassEntry> obfClassChain = this.m_index.getObfClassChain(obfClassEntry);
        boolean bl = isInnerClass = obfClassChain.size() > 1;
        if (isInnerClass) {
            c.setName(obfClassEntry.buildClassEntry(obfClassChain).getName());
            BehaviorEntry caller = this.m_index.getAnonymousClassCaller(obfClassEntry);
            if (caller != null) {
                if (caller.getName().equals("<clinit>")) {
                    c.getClassFile().addAttribute((AttributeInfo)new EnclosingMethodAttribute(c.getClassFile().getConstPool(), caller.getClassName()));
                } else {
                    c.getClassFile().addAttribute((AttributeInfo)new EnclosingMethodAttribute(c.getClassFile().getConstPool(), caller.getClassName(), caller.getName(), caller.getSignature().toString()));
                }
            }
        }
        Collection<ClassEntry> obfInnerClassEntries = this.m_index.getInnerClasses(obfClassEntry);
        if (isInnerClass || !obfInnerClassEntries.isEmpty()) {
            InnerClassesAttribute attr = new InnerClassesAttribute(c.getClassFile().getConstPool());
            c.getClassFile().addAttribute((AttributeInfo)attr);
            int i = 1;
            while (i < obfClassChain.size()) {
                ClassEntry obfInnerClassEntry = obfClassChain.get(i);
                this.writeInnerClass(attr, obfClassChain, obfInnerClassEntry);
                c.replaceClassName(obfInnerClassEntry.getName(), obfInnerClassEntry.buildClassEntry(obfClassChain).getName());
                ++i;
            }
            for (ClassEntry obfInnerClassEntry : obfInnerClassEntries) {
                ArrayList extendedObfClassChain = Lists.newArrayList(obfClassChain);
                extendedObfClassChain.add(obfInnerClassEntry);
                this.writeInnerClass(attr, extendedObfClassChain, obfInnerClassEntry);
                c.replaceClassName(obfInnerClassEntry.getName(), obfInnerClassEntry.buildClassEntry(extendedObfClassChain).getName());
            }
        }
    }

    private void writeInnerClass(InnerClassesAttribute attr, List<ClassEntry> obfClassChain, ClassEntry obfClassEntry) {
        ClassEntry obfInnerClassEntry = obfClassEntry.buildClassEntry(obfClassChain);
        ClassEntry obfOuterClassEntry = obfInnerClassEntry.getOuterClassEntry();
        ConstPool constPool = attr.getConstPool();
        int innerClassIndex = constPool.addClassInfo(obfInnerClassEntry.getName());
        int parentClassIndex = constPool.addClassInfo(obfOuterClassEntry.getName());
        int innerClassNameIndex = 0;
        int accessFlags = 1;
        if (!this.m_index.isAnonymousClass(obfClassEntry)) {
            innerClassNameIndex = constPool.addUtf8Info(obfInnerClassEntry.getInnermostClassName());
        }
        attr.append(innerClassIndex, parentClassIndex, innerClassNameIndex, accessFlags);
    }
}

