/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cuchaz.enigma.analysis.EntryRenamer;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.Translator;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.bytecode.Descriptor;

public class TranslationIndex
implements Serializable {
    private static final long serialVersionUID = 738687982126844179L;
    private Map<ClassEntry, ClassEntry> m_superclasses = Maps.newHashMap();
    private Multimap<ClassEntry, FieldEntry> m_fieldEntries;
    private Multimap<ClassEntry, BehaviorEntry> m_behaviorEntries;
    private Multimap<ClassEntry, ClassEntry> m_interfaces;

    public TranslationIndex() {
        this.m_fieldEntries = HashMultimap.create();
        this.m_behaviorEntries = HashMultimap.create();
        this.m_interfaces = HashMultimap.create();
    }

    public TranslationIndex(TranslationIndex other, Translator translator) {
        for (Map.Entry<ClassEntry, ClassEntry> mapEntry : other.m_superclasses.entrySet()) {
            this.m_superclasses.put(translator.translateEntry(mapEntry.getKey()), translator.translateEntry(mapEntry.getValue()));
        }
        this.m_interfaces = HashMultimap.create();
        for (Map.Entry<ClassEntry, ClassEntry> mapEntry : other.m_interfaces.entries()) {
            this.m_interfaces.put((Object)translator.translateEntry(mapEntry.getKey()), (Object)translator.translateEntry(mapEntry.getValue()));
        }
        this.m_fieldEntries = HashMultimap.create();
        for (Map.Entry<ClassEntry, ClassEntry> mapEntry : other.m_fieldEntries.entries()) {
            this.m_fieldEntries.put((Object)translator.translateEntry(mapEntry.getKey()), (Object)translator.translateEntry((FieldEntry)((Object)mapEntry.getValue())));
        }
        this.m_behaviorEntries = HashMultimap.create();
        for (Map.Entry<ClassEntry, ClassEntry> mapEntry : other.m_behaviorEntries.entries()) {
            this.m_behaviorEntries.put((Object)translator.translateEntry(mapEntry.getKey()), (Object)translator.translateEntry((BehaviorEntry)((Object)mapEntry.getValue())));
        }
    }

    public void indexClass(CtClass c) {
        this.indexClass(c, true);
    }

    public void indexClass(CtClass c, boolean indexMembers) {
        ClassEntry classEntry = EntryFactory.getClassEntry(c);
        if (this.isJre(classEntry)) {
            return;
        }
        ClassEntry superclassEntry = EntryFactory.getSuperclassEntry(c);
        if (superclassEntry != null) {
            this.m_superclasses.put(classEntry, superclassEntry);
        }
        String[] stringArray = c.getClassFile().getInterfaces();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceClassName = stringArray[n2];
            ClassEntry interfaceClassEntry = new ClassEntry(Descriptor.toJvmName((String)interfaceClassName));
            if (!this.isJre(interfaceClassEntry)) {
                this.m_interfaces.put((Object)classEntry, (Object)interfaceClassEntry);
            }
            ++n2;
        }
        if (indexMembers) {
            stringArray = c.getDeclaredFields();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                FieldEntry fieldEntry = EntryFactory.getFieldEntry((CtField)field);
                this.m_fieldEntries.put((Object)fieldEntry.getClassEntry(), (Object)fieldEntry);
                ++n2;
            }
            stringArray = c.getDeclaredBehaviors();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String behavior = stringArray[n2];
                BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry((CtBehavior)behavior);
                this.m_behaviorEntries.put((Object)behaviorEntry.getClassEntry(), (Object)behaviorEntry);
                ++n2;
            }
        }
    }

    public void renameClasses(Map<String, String> renames) {
        EntryRenamer.renameClassesInMap(renames, this.m_superclasses);
        EntryRenamer.renameClassesInMultimap(renames, this.m_fieldEntries);
        EntryRenamer.renameClassesInMultimap(renames, this.m_behaviorEntries);
    }

    public ClassEntry getSuperclass(ClassEntry classEntry) {
        return this.m_superclasses.get(classEntry);
    }

    public List<ClassEntry> getAncestry(ClassEntry classEntry) {
        ArrayList ancestors = Lists.newArrayList();
        while (classEntry != null) {
            if ((classEntry = this.getSuperclass(classEntry)) == null) continue;
            ancestors.add(classEntry);
        }
        return ancestors;
    }

    public List<ClassEntry> getSubclass(ClassEntry classEntry) {
        ArrayList subclasses = Lists.newArrayList();
        for (Map.Entry<ClassEntry, ClassEntry> entry : this.m_superclasses.entrySet()) {
            ClassEntry subclass = entry.getKey();
            ClassEntry superclass = entry.getValue();
            if (!classEntry.equals(superclass)) continue;
            subclasses.add(subclass);
        }
        return subclasses;
    }

    public void getSubclassesRecursively(Set<ClassEntry> out, ClassEntry classEntry) {
        for (ClassEntry subclassEntry : this.getSubclass(classEntry)) {
            out.add(subclassEntry);
            this.getSubclassesRecursively(out, subclassEntry);
        }
    }

    public void getSubclassNamesRecursively(Set<String> out, ClassEntry classEntry) {
        for (ClassEntry subclassEntry : this.getSubclass(classEntry)) {
            out.add(subclassEntry.getName());
            this.getSubclassNamesRecursively(out, subclassEntry);
        }
    }

    public Collection<Map.Entry<ClassEntry, ClassEntry>> getClassInterfaces() {
        return this.m_interfaces.entries();
    }

    public Collection<ClassEntry> getInterfaces(ClassEntry classEntry) {
        return this.m_interfaces.get((Object)classEntry);
    }

    public boolean isInterface(ClassEntry classEntry) {
        return this.m_interfaces.containsValue((Object)classEntry);
    }

    public boolean entryExists(Entry entry) {
        if (entry instanceof FieldEntry) {
            return this.fieldExists((FieldEntry)entry);
        }
        if (entry instanceof BehaviorEntry) {
            return this.behaviorExists((BehaviorEntry)entry);
        }
        if (entry instanceof ArgumentEntry) {
            return this.behaviorExists(((ArgumentEntry)entry).getBehaviorEntry());
        }
        throw new IllegalArgumentException("Cannot check existence for " + entry.getClass());
    }

    public boolean fieldExists(FieldEntry fieldEntry) {
        return this.m_fieldEntries.containsEntry((Object)fieldEntry.getClassEntry(), (Object)fieldEntry);
    }

    public boolean behaviorExists(BehaviorEntry behaviorEntry) {
        return this.m_behaviorEntries.containsEntry((Object)behaviorEntry.getClassEntry(), (Object)behaviorEntry);
    }

    public ClassEntry resolveEntryClass(Entry entry) {
        if (entry instanceof ClassEntry) {
            return (ClassEntry)entry;
        }
        ClassEntry superclassEntry = this.resolveSuperclass(entry);
        if (superclassEntry != null) {
            return superclassEntry;
        }
        ClassEntry interfaceEntry = this.resolveInterface(entry);
        if (interfaceEntry != null) {
            return interfaceEntry;
        }
        return null;
    }

    public ClassEntry resolveSuperclass(Entry entry) {
        while (!this.entryExists(entry)) {
            ClassEntry superclassEntry = this.getSuperclass(entry.getClassEntry());
            if (superclassEntry == null) {
                return null;
            }
            entry = entry.cloneToNewClass(superclassEntry);
        }
        return entry.getClassEntry();
    }

    public ClassEntry resolveInterface(Entry entry) {
        for (ClassEntry interfaceEntry : this.m_interfaces.get((Object)entry.getClassEntry())) {
            ClassEntry resolvedClassEntry = this.resolveSuperclass(entry.cloneToNewClass(interfaceEntry));
            if (resolvedClassEntry == null) continue;
            return resolvedClassEntry;
        }
        return null;
    }

    private boolean isJre(ClassEntry classEntry) {
        String packageName = classEntry.getPackageName();
        return packageName != null && (packageName.startsWith("java") || packageName.startsWith("javax"));
    }

    public void write(OutputStream out) throws IOException {
        GZIPOutputStream gzipout = new GZIPOutputStream(out);
        ObjectOutputStream oout = new ObjectOutputStream(gzipout);
        oout.writeObject(this.m_superclasses);
        oout.writeObject(this.m_fieldEntries);
        oout.writeObject(this.m_behaviorEntries);
        gzipout.finish();
    }

    public void read(InputStream in) throws IOException {
        try {
            ObjectInputStream oin = new ObjectInputStream(new GZIPInputStream(in));
            this.m_superclasses = (HashMap)oin.readObject();
            this.m_fieldEntries = (HashMultimap)oin.readObject();
            this.m_behaviorEntries = (HashMultimap)oin.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new Error(ex);
        }
    }
}

