/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.MethodMapping;
import java.util.Map;
import java.util.Set;

public class RelatedMethodChecker {
    private JarIndex m_jarIndex;
    private Map<Set<MethodEntry>, String> m_deobfNamesByGroup;
    private Map<MethodEntry, String> m_deobfNamesByObfMethod;
    private Map<MethodEntry, Set<MethodEntry>> m_groupsByObfMethod;
    private Set<Set<MethodEntry>> m_inconsistentGroups;

    public RelatedMethodChecker(JarIndex jarIndex) {
        this.m_jarIndex = jarIndex;
        this.m_deobfNamesByGroup = Maps.newHashMap();
        this.m_deobfNamesByObfMethod = Maps.newHashMap();
        this.m_groupsByObfMethod = Maps.newHashMap();
        this.m_inconsistentGroups = Sets.newHashSet();
    }

    public void checkMethod(ClassEntry classEntry, MethodMapping methodMapping) {
    }

    private boolean sameName(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }

    public boolean hasProblems() {
        return this.m_inconsistentGroups.size() > 0;
    }

    public String getReport() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.m_inconsistentGroups.size());
        buf.append(" groups of methods related by inheritance and/or interfaces have different deobf names!\n");
        for (Set<MethodEntry> group : this.m_inconsistentGroups) {
            buf.append("\tGroup with ");
            buf.append(group.size());
            buf.append(" methods:\n");
            for (MethodEntry methodEntry : group) {
                buf.append("\t\t");
                buf.append(methodEntry.toString());
                buf.append(" => ");
                buf.append(this.m_deobfNamesByObfMethod.get(methodEntry));
                buf.append("\n");
            }
        }
        return buf.toString();
    }
}

