/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.Translator;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class ClassImplementationsTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 3112703459157851912L;
    private Translator m_deobfuscatingTranslator;
    private ClassEntry m_entry;

    public ClassImplementationsTreeNode(Translator deobfuscatingTranslator, ClassEntry entry) {
        this.m_deobfuscatingTranslator = deobfuscatingTranslator;
        this.m_entry = entry;
    }

    public ClassEntry getClassEntry() {
        return this.m_entry;
    }

    public String getDeobfClassName() {
        return this.m_deobfuscatingTranslator.translateClass(this.m_entry.getClassName());
    }

    @Override
    public String toString() {
        String className = this.getDeobfClassName();
        if (className == null) {
            className = this.m_entry.getClassName();
        }
        return className;
    }

    public void load(JarIndex index) {
        ArrayList nodes = Lists.newArrayList();
        for (String implementingClassName : index.getImplementingClasses(this.m_entry.getClassName())) {
            nodes.add(new ClassImplementationsTreeNode(this.m_deobfuscatingTranslator, new ClassEntry(implementingClassName)));
        }
        for (ClassImplementationsTreeNode node : nodes) {
            this.add(node);
        }
    }

    public static ClassImplementationsTreeNode findNode(ClassImplementationsTreeNode node, MethodEntry entry) {
        if (node.m_entry.equals(entry)) {
            return node;
        }
        int i = 0;
        while (i < node.getChildCount()) {
            ClassImplementationsTreeNode foundNode = ClassImplementationsTreeNode.findNode((ClassImplementationsTreeNode)node.getChildAt(i), entry);
            if (foundNode != null) {
                return foundNode;
            }
            ++i;
        }
        return null;
    }
}

