/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.mapping.ClassNameReplacer;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Type;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class TestSignature {
    @Test
    public void easiest() {
        Signature sig = new Signature("()V");
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("V")));
    }

    @Test
    public void primitives() {
        Signature sig = new Signature("(I)V");
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.contains((Object[])new Type[]{new Type("I")}));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("V")));
        sig = new Signature("(I)I");
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.contains((Object[])new Type[]{new Type("I")}));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("I")));
        sig = new Signature("(IBCJ)Z");
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.contains((Object[])new Type[]{new Type("I"), new Type("B"), new Type("C"), new Type("J")}));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("Z")));
    }

    @Test
    public void classes() {
        Signature sig = new Signature("([LFoo;)V");
        MatcherAssert.assertThat((Object)sig.getArgumentTypes().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)sig.getArgumentTypes().get(0), (Matcher)Matchers.is((Object)new Type("[LFoo;")));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("V")));
        sig = new Signature("(LFoo;)LBar;");
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.contains((Object[])new Type[]{new Type("LFoo;")}));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("LBar;")));
        sig = new Signature("(LFoo;LMoo;LZoo;)LBar;");
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.contains((Object[])new Type[]{new Type("LFoo;"), new Type("LMoo;"), new Type("LZoo;")}));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("LBar;")));
    }

    @Test
    public void arrays() {
        Signature sig = new Signature("([I)V");
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.contains((Object[])new Type[]{new Type("[I")}));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("V")));
        sig = new Signature("([I)[J");
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.contains((Object[])new Type[]{new Type("[I")}));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("[J")));
        sig = new Signature("([I[Z[F)[D");
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.contains((Object[])new Type[]{new Type("[I"), new Type("[Z"), new Type("[F")}));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("[D")));
    }

    @Test
    public void mixed() {
        Signature sig = new Signature("(I[JLFoo;)Z");
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.contains((Object[])new Type[]{new Type("I"), new Type("[J"), new Type("LFoo;")}));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("Z")));
        sig = new Signature("(III)[LFoo;");
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.contains((Object[])new Type[]{new Type("I"), new Type("I"), new Type("I")}));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("[LFoo;")));
    }

    @Test
    public void replaceClasses() {
        Signature oldSig = new Signature("()V");
        Signature sig = new Signature(oldSig, new ClassNameReplacer(){

            @Override
            public String replace(String val) {
                return null;
            }
        });
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("V")));
        oldSig = new Signature("(IJLFoo;)V");
        sig = new Signature(oldSig, new ClassNameReplacer(){

            @Override
            public String replace(String val) {
                return null;
            }
        });
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.contains((Object[])new Type[]{new Type("I"), new Type("J"), new Type("LFoo;")}));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("V")));
        oldSig = new Signature("(LFoo;LBar;)LMoo;");
        sig = new Signature(oldSig, new ClassNameReplacer(){

            @Override
            public String replace(String val) {
                if (val.equals("Foo")) {
                    return "Bar";
                }
                return null;
            }
        });
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.contains((Object[])new Type[]{new Type("LBar;"), new Type("LBar;")}));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("LMoo;")));
        oldSig = new Signature("(LFoo;LBar;)LMoo;");
        sig = new Signature(oldSig, new ClassNameReplacer(){

            @Override
            public String replace(String val) {
                if (val.equals("Moo")) {
                    return "Cow";
                }
                return null;
            }
        });
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.contains((Object[])new Type[]{new Type("LFoo;"), new Type("LBar;")}));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("LCow;")));
    }

    @Test
    public void replaceArrayClasses() {
        Signature oldSig = new Signature("([LFoo;)[[[LBar;");
        Signature sig = new Signature(oldSig, new ClassNameReplacer(){

            @Override
            public String replace(String val) {
                if (val.equals("Foo")) {
                    return "Food";
                }
                if (val.equals("Bar")) {
                    return "Beer";
                }
                return null;
            }
        });
        MatcherAssert.assertThat(sig.getArgumentTypes(), (Matcher)Matchers.contains((Object[])new Type[]{new Type("[LFood;")}));
        MatcherAssert.assertThat((Object)sig.getReturnType(), (Matcher)Matchers.is((Object)new Type("[[[LBeer;")));
    }

    @Test
    public void equals() {
        MatcherAssert.assertThat((Object)new Signature("()V"), (Matcher)Matchers.is((Object)new Signature("()V")));
        MatcherAssert.assertThat((Object)new Signature("(I)V"), (Matcher)Matchers.is((Object)new Signature("(I)V")));
        MatcherAssert.assertThat((Object)new Signature("(ZIZ)V"), (Matcher)Matchers.is((Object)new Signature("(ZIZ)V")));
        MatcherAssert.assertThat((Object)new Signature("(LFoo;)V"), (Matcher)Matchers.is((Object)new Signature("(LFoo;)V")));
        MatcherAssert.assertThat((Object)new Signature("(LFoo;LBar;)V"), (Matcher)Matchers.is((Object)new Signature("(LFoo;LBar;)V")));
        MatcherAssert.assertThat((Object)new Signature("([I)V"), (Matcher)Matchers.is((Object)new Signature("([I)V")));
        MatcherAssert.assertThat((Object)new Signature("([[D[[[J)V"), (Matcher)Matchers.is((Object)new Signature("([[D[[[J)V")));
        MatcherAssert.assertThat((Object)new Signature("()V"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Signature("(I)V"))));
        MatcherAssert.assertThat((Object)new Signature("(I)V"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Signature("()V"))));
        MatcherAssert.assertThat((Object)new Signature("(IJ)V"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Signature("(JI)V"))));
        MatcherAssert.assertThat((Object)new Signature("([[Z)V"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Signature("([[LFoo;)V"))));
        MatcherAssert.assertThat((Object)new Signature("(LFoo;LBar;)V"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Signature("(LFoo;LCow;)V"))));
        MatcherAssert.assertThat((Object)new Signature("([LFoo;LBar;)V"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Signature("(LFoo;LCow;)V"))));
        MatcherAssert.assertThat((Object)new Signature("()I"), (Matcher)Matchers.is((Object)new Signature("()I")));
        MatcherAssert.assertThat((Object)new Signature("()Z"), (Matcher)Matchers.is((Object)new Signature("()Z")));
        MatcherAssert.assertThat((Object)new Signature("()[D"), (Matcher)Matchers.is((Object)new Signature("()[D")));
        MatcherAssert.assertThat((Object)new Signature("()[[[Z"), (Matcher)Matchers.is((Object)new Signature("()[[[Z")));
        MatcherAssert.assertThat((Object)new Signature("()LFoo;"), (Matcher)Matchers.is((Object)new Signature("()LFoo;")));
        MatcherAssert.assertThat((Object)new Signature("()[LFoo;"), (Matcher)Matchers.is((Object)new Signature("()[LFoo;")));
        MatcherAssert.assertThat((Object)new Signature("()I"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Signature("()Z"))));
        MatcherAssert.assertThat((Object)new Signature("()Z"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Signature("()I"))));
        MatcherAssert.assertThat((Object)new Signature("()[D"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Signature("()[J"))));
        MatcherAssert.assertThat((Object)new Signature("()[[[Z"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Signature("()[[Z"))));
        MatcherAssert.assertThat((Object)new Signature("()LFoo;"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Signature("()LBar;"))));
        MatcherAssert.assertThat((Object)new Signature("()[LFoo;"), (Matcher)Matchers.is((Matcher)Matchers.not((Object)new Signature("()[LBar;"))));
    }

    @Test
    public void testToString() {
        MatcherAssert.assertThat((Object)new Signature("()V").toString(), (Matcher)Matchers.is((Object)"()V"));
        MatcherAssert.assertThat((Object)new Signature("(I)V").toString(), (Matcher)Matchers.is((Object)"(I)V"));
        MatcherAssert.assertThat((Object)new Signature("(ZIZ)V").toString(), (Matcher)Matchers.is((Object)"(ZIZ)V"));
        MatcherAssert.assertThat((Object)new Signature("(LFoo;)V").toString(), (Matcher)Matchers.is((Object)"(LFoo;)V"));
        MatcherAssert.assertThat((Object)new Signature("(LFoo;LBar;)V").toString(), (Matcher)Matchers.is((Object)"(LFoo;LBar;)V"));
        MatcherAssert.assertThat((Object)new Signature("([I)V").toString(), (Matcher)Matchers.is((Object)"([I)V"));
        MatcherAssert.assertThat((Object)new Signature("([[D[[[J)V").toString(), (Matcher)Matchers.is((Object)"([[D[[[J)V"));
    }
}

