/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.convert.ClassMatches;
import cuchaz.enigma.convert.MappingsConverter;
import cuchaz.enigma.convert.MatchesReader;
import cuchaz.enigma.convert.MatchesWriter;
import cuchaz.enigma.convert.MemberMatches;
import cuchaz.enigma.gui.ClassMatchingGui;
import cuchaz.enigma.gui.MemberMatchingGui;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.MappingParseException;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MappingsChecker;
import cuchaz.enigma.mapping.MappingsReader;
import cuchaz.enigma.mapping.MappingsWriter;
import cuchaz.enigma.mapping.MethodMapping;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarFile;

public class ConvertMain {
    public static void main(String[] args) throws IOException, MappingParseException {
        File home = new File(System.getProperty("user.home"));
        JarFile sourceJar = new JarFile(new File(home, ".minecraft/versions/1.8/1.8.jar"));
        JarFile destJar = new JarFile(new File(home, ".minecraft/versions/1.8.3/1.8.3.jar"));
        File inMappingsFile = new File("../Enigma Mappings/1.8.mappings");
        File outMappingsFile = new File("../Enigma Mappings/1.8.3.mappings");
        Mappings mappings = new MappingsReader().read(new FileReader(inMappingsFile));
        File classMatchesFile = new File(String.valueOf(inMappingsFile.getName()) + ".class.matches");
        File fieldMatchesFile = new File(String.valueOf(inMappingsFile.getName()) + ".field.matches");
        File methodMatchesFile = new File(String.valueOf(inMappingsFile.getName()) + ".method.matches");
        ConvertMain.convertMappings(outMappingsFile, sourceJar, destJar, mappings, classMatchesFile, fieldMatchesFile, methodMatchesFile);
    }

    private static void computeClassMatches(File classMatchesFile, JarFile sourceJar, JarFile destJar, Mappings mappings) throws IOException {
        ClassMatches classMatches = MappingsConverter.computeClassMatches(sourceJar, destJar, mappings);
        MatchesWriter.writeClasses(classMatches, classMatchesFile);
        System.out.println("Wrote:\n\t" + classMatchesFile.getAbsolutePath());
    }

    private static void editClasssMatches(final File classMatchesFile, JarFile sourceJar, JarFile destJar, Mappings mappings) throws IOException {
        System.out.println("Reading class matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        Deobfuscators deobfuscators = new Deobfuscators(sourceJar, destJar);
        deobfuscators.source.setMappings(mappings);
        System.out.println("Starting GUI...");
        new ClassMatchingGui(classMatches, deobfuscators.source, deobfuscators.dest).setSaveListener(new ClassMatchingGui.SaveListener(){

            @Override
            public void save(ClassMatches matches) {
                try {
                    MatchesWriter.writeClasses(matches, classMatchesFile);
                }
                catch (IOException ex) {
                    throw new Error(ex);
                }
            }
        });
    }

    private static void convertMappings(File outMappingsFile, JarFile sourceJar, JarFile destJar, Mappings mappings, File classMatchesFile) throws IOException {
        System.out.println("Reading class matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        Deobfuscators deobfuscators = new Deobfuscators(sourceJar, destJar);
        deobfuscators.source.setMappings(mappings);
        Mappings newMappings = MappingsConverter.newMappings(classMatches, mappings, deobfuscators.source, deobfuscators.dest);
        Throwable throwable = null;
        Object var9_10 = null;
        try (FileWriter out = new FileWriter(outMappingsFile);){
            new MappingsWriter().write(out, newMappings);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        System.out.println("Write converted mappings to: " + outMappingsFile.getAbsolutePath());
    }

    private static void computeFieldMatches(File memberMatchesFile, JarFile destJar, File destMappingsFile, File classMatchesFile) throws IOException, MappingParseException {
        System.out.println("Reading class matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        System.out.println("Reading mappings...");
        Mappings destMappings = new MappingsReader().read(new FileReader(destMappingsFile));
        System.out.println("Indexing dest jar...");
        Deobfuscator destDeobfuscator = new Deobfuscator(destJar);
        System.out.println("Writing matches...");
        MemberMatches<FieldEntry> fieldMatches = MappingsConverter.computeMemberMatches(destDeobfuscator, destMappings, classMatches, MappingsConverter.getFieldDoer());
        MatchesWriter.writeMembers(fieldMatches, memberMatchesFile);
        System.out.println("Wrote:\n\t" + memberMatchesFile.getAbsolutePath());
    }

    private static void editFieldMatches(JarFile sourceJar, JarFile destJar, File destMappingsFile, Mappings sourceMappings, File classMatchesFile, final File fieldMatchesFile) throws IOException, MappingParseException {
        System.out.println("Reading matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        MemberMatches fieldMatches = MatchesReader.readMembers(fieldMatchesFile);
        Deobfuscators deobfuscators = new Deobfuscators(sourceJar, destJar);
        deobfuscators.source.setMappings(sourceMappings);
        Mappings destMappings = new MappingsReader().read(new FileReader(destMappingsFile));
        MappingsChecker checker = new MappingsChecker(deobfuscators.dest.getJarIndex());
        checker.dropBrokenMappings(destMappings);
        deobfuscators.dest.setMappings(destMappings);
        new MemberMatchingGui<FieldEntry>(classMatches, fieldMatches, deobfuscators.source, deobfuscators.dest).setSaveListener(new MemberMatchingGui.SaveListener<FieldEntry>(){

            @Override
            public void save(MemberMatches<FieldEntry> matches) {
                try {
                    MatchesWriter.writeMembers(matches, fieldMatchesFile);
                }
                catch (IOException ex) {
                    throw new Error(ex);
                }
            }
        });
    }

    private static void convertMappings(File outMappingsFile, JarFile sourceJar, JarFile destJar, Mappings mappings, File classMatchesFile, File fieldMatchesFile) throws IOException {
        System.out.println("Reading matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        MemberMatches fieldMatches = MatchesReader.readMembers(fieldMatchesFile);
        Deobfuscators deobfuscators = new Deobfuscators(sourceJar, destJar);
        deobfuscators.source.setMappings(mappings);
        Mappings newMappings = MappingsConverter.newMappings(classMatches, mappings, deobfuscators.source, deobfuscators.dest);
        MappingsConverter.applyMemberMatches(newMappings, classMatches, fieldMatches, MappingsConverter.getFieldDoer());
        Throwable throwable = null;
        Object var11_12 = null;
        try (FileWriter out = new FileWriter(outMappingsFile);){
            new MappingsWriter().write(out, newMappings);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        System.out.println("Wrote converted mappings to:\n\t" + outMappingsFile.getAbsolutePath());
    }

    private static void computeMethodMatches(File methodMatchesFile, JarFile destJar, File destMappingsFile, File classMatchesFile) throws IOException, MappingParseException {
        System.out.println("Reading class matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        System.out.println("Reading mappings...");
        Mappings destMappings = new MappingsReader().read(new FileReader(destMappingsFile));
        System.out.println("Indexing dest jar...");
        Deobfuscator destDeobfuscator = new Deobfuscator(destJar);
        System.out.println("Writing method matches...");
        MemberMatches<BehaviorEntry> methodMatches = MappingsConverter.computeMemberMatches(destDeobfuscator, destMappings, classMatches, MappingsConverter.getMethodDoer());
        MatchesWriter.writeMembers(methodMatches, methodMatchesFile);
        System.out.println("Wrote:\n\t" + methodMatchesFile.getAbsolutePath());
    }

    private static void editMethodMatches(JarFile sourceJar, JarFile destJar, File destMappingsFile, Mappings sourceMappings, File classMatchesFile, final File methodMatchesFile) throws IOException, MappingParseException {
        System.out.println("Reading matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        MemberMatches methodMatches = MatchesReader.readMembers(methodMatchesFile);
        Deobfuscators deobfuscators = new Deobfuscators(sourceJar, destJar);
        deobfuscators.source.setMappings(sourceMappings);
        Mappings destMappings = new MappingsReader().read(new FileReader(destMappingsFile));
        MappingsChecker checker = new MappingsChecker(deobfuscators.dest.getJarIndex());
        checker.dropBrokenMappings(destMappings);
        deobfuscators.dest.setMappings(destMappings);
        new MemberMatchingGui<BehaviorEntry>(classMatches, methodMatches, deobfuscators.source, deobfuscators.dest).setSaveListener(new MemberMatchingGui.SaveListener<BehaviorEntry>(){

            @Override
            public void save(MemberMatches<BehaviorEntry> matches) {
                try {
                    MatchesWriter.writeMembers(matches, methodMatchesFile);
                }
                catch (IOException ex) {
                    throw new Error(ex);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static void convertMappings(File outMappingsFile, JarFile sourceJar, JarFile destJar, Mappings mappings, File classMatchesFile, File fieldMatchesFile, File methodMatchesFile) throws IOException {
        System.out.println("Reading matches...");
        ClassMatches classMatches = MatchesReader.readClasses(classMatchesFile);
        MemberMatches fieldMatches = MatchesReader.readMembers(fieldMatchesFile);
        MemberMatches methodMatches = MatchesReader.readMembers(methodMatchesFile);
        Deobfuscators deobfuscators = new Deobfuscators(sourceJar, destJar);
        deobfuscators.source.setMappings(mappings);
        Mappings newMappings = MappingsConverter.newMappings(classMatches, mappings, deobfuscators.source, deobfuscators.dest);
        MappingsConverter.applyMemberMatches(newMappings, classMatches, fieldMatches, MappingsConverter.getFieldDoer());
        MappingsConverter.applyMemberMatches(newMappings, classMatches, methodMatches, MappingsConverter.getMethodDoer());
        MappingsChecker checker = new MappingsChecker(deobfuscators.dest.getJarIndex());
        checker.dropBrokenMappings(newMappings);
        for (Map.Entry<ClassEntry, ClassMapping> throwable : checker.getDroppedClassMappings().entrySet()) {
            System.out.println("WARNING: Broken class entry " + throwable.getKey() + " (" + throwable.getValue().getDeobfName() + ")");
        }
        for (Map.Entry<ClassEntry, ClassMapping> entry : checker.getDroppedInnerClassMappings().entrySet()) {
            System.out.println("WARNING: Broken inner class entry " + entry.getKey() + " (" + entry.getValue().getDeobfName() + ")");
        }
        for (Map.Entry<Entry, Comparable<ClassMapping>> entry : checker.getDroppedFieldMappings().entrySet()) {
            System.out.println("WARNING: Broken field entry " + entry.getKey() + " (" + ((FieldMapping)entry.getValue()).getDeobfName() + ")");
        }
        for (Map.Entry<Entry, Comparable<ClassMapping>> entry : checker.getDroppedMethodMappings().entrySet()) {
            System.out.println("WARNING: Broken behavior entry " + entry.getKey() + " (" + ((MethodMapping)entry.getValue()).getDeobfName() + ")");
        }
        Throwable throwable = null;
        Iterator<Map.Entry<Entry, Comparable<ClassMapping>>> iterator = null;
        try (FileWriter out = new FileWriter(outMappingsFile);){
            new MappingsWriter().write(out, newMappings);
        }
        catch (Throwable throwable2) {
            void var13_25;
            if (throwable == null) {
                Throwable throwable3 = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw var13_25;
        }
        System.out.println("Wrote converted mappings to:\n\t" + outMappingsFile.getAbsolutePath());
    }

    private static class Deobfuscators {
        public Deobfuscator source;
        public Deobfuscator dest;

        public Deobfuscators(JarFile sourceJar, JarFile destJar) {
            System.out.println("Indexing source jar...");
            IndexerThread sourceIndexer = new IndexerThread(sourceJar);
            sourceIndexer.start();
            System.out.println("Indexing dest jar...");
            IndexerThread destIndexer = new IndexerThread(destJar);
            destIndexer.start();
            sourceIndexer.joinOrBail();
            destIndexer.joinOrBail();
            this.source = sourceIndexer.deobfuscator;
            this.dest = destIndexer.deobfuscator;
        }
    }

    private static class IndexerThread
    extends Thread {
        private JarFile m_jarFile;
        public Deobfuscator deobfuscator;

        public IndexerThread(JarFile jarFile) {
            this.m_jarFile = jarFile;
            this.deobfuscator = null;
        }

        public void joinOrBail() {
            try {
                this.join();
            }
            catch (InterruptedException ex) {
                throw new Error(ex);
            }
        }

        @Override
        public void run() {
            try {
                this.deobfuscator = new Deobfuscator(this.m_jarFile);
            }
            catch (IOException ex) {
                throw new Error(ex);
            }
        }
    }
}

