/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MappingsReader;
import java.io.File;
import java.io.FileReader;
import java.util.jar.JarFile;

public class CommandMain {
    public static void main(String[] args) throws Exception {
        block6: {
            try {
                String command = CommandMain.getArg(args, 0, "command", true);
                if (command.equalsIgnoreCase("deobfuscate")) {
                    CommandMain.deobfuscate(args);
                    break block6;
                }
                if (command.equalsIgnoreCase("decompile")) {
                    CommandMain.decompile(args);
                    break block6;
                }
                if (command.equalsIgnoreCase("protectify")) {
                    CommandMain.protectify(args);
                    break block6;
                }
                if (command.equalsIgnoreCase("publify")) {
                    CommandMain.publify(args);
                    break block6;
                }
                throw new IllegalArgumentException("Command not recognized: " + command);
            }
            catch (IllegalArgumentException ex) {
                System.out.println(ex.getMessage());
                CommandMain.printHelp();
            }
        }
    }

    private static void printHelp() {
        System.out.println(String.format("%s - %s", "Enigma", "0.10.4 beta"));
        System.out.println("Usage:");
        System.out.println("\tjava -cp enigma.jar cuchaz.enigma.CommandMain <command>");
        System.out.println("\twhere <command> is one of:");
        System.out.println("\t\tdeobfuscate <in jar> <out jar> [<mappings file>]");
        System.out.println("\t\tdecompile <in jar> <out folder> [<mappings file>]");
        System.out.println("\t\tprotectify <in jar> <out jar>");
    }

    private static void decompile(String[] args) throws Exception {
        File fileJarIn = CommandMain.getReadableFile(CommandMain.getArg(args, 1, "in jar", true));
        File fileJarOut = CommandMain.getWritableFolder(CommandMain.getArg(args, 2, "out folder", true));
        File fileMappings = CommandMain.getReadableFile(CommandMain.getArg(args, 3, "mappings file", false));
        Deobfuscator deobfuscator = CommandMain.getDeobfuscator(fileMappings, new JarFile(fileJarIn));
        deobfuscator.writeSources(fileJarOut, new ConsoleProgressListener());
    }

    private static void deobfuscate(String[] args) throws Exception {
        File fileJarIn = CommandMain.getReadableFile(CommandMain.getArg(args, 1, "in jar", true));
        File fileJarOut = CommandMain.getWritableFile(CommandMain.getArg(args, 2, "out jar", true));
        File fileMappings = CommandMain.getReadableFile(CommandMain.getArg(args, 3, "mappings file", false));
        Deobfuscator deobfuscator = CommandMain.getDeobfuscator(fileMappings, new JarFile(fileJarIn));
        deobfuscator.writeJar(fileJarOut, new ConsoleProgressListener());
    }

    private static void protectify(String[] args) throws Exception {
        File fileJarIn = CommandMain.getReadableFile(CommandMain.getArg(args, 1, "in jar", true));
        File fileJarOut = CommandMain.getWritableFile(CommandMain.getArg(args, 2, "out jar", true));
        Deobfuscator deobfuscator = CommandMain.getDeobfuscator(null, new JarFile(fileJarIn));
        deobfuscator.protectifyJar(fileJarOut, new ConsoleProgressListener());
    }

    private static void publify(String[] args) throws Exception {
        File fileJarIn = CommandMain.getReadableFile(CommandMain.getArg(args, 1, "in jar", true));
        File fileJarOut = CommandMain.getWritableFile(CommandMain.getArg(args, 2, "out jar", true));
        Deobfuscator deobfuscator = CommandMain.getDeobfuscator(null, new JarFile(fileJarIn));
        deobfuscator.publifyJar(fileJarOut, new ConsoleProgressListener());
    }

    private static Deobfuscator getDeobfuscator(File fileMappings, JarFile jar) throws Exception {
        System.out.println("Reading jar...");
        Deobfuscator deobfuscator = new Deobfuscator(jar);
        if (fileMappings != null) {
            System.out.println("Reading mappings...");
            Mappings mappings = new MappingsReader().read(new FileReader(fileMappings));
            deobfuscator.setMappings(mappings);
        }
        return deobfuscator;
    }

    private static String getArg(String[] args, int i, String name, boolean required) {
        if (i >= args.length) {
            if (required) {
                throw new IllegalArgumentException(String.valueOf(name) + " is required");
            }
            return null;
        }
        return args[i];
    }

    private static File getWritableFile(String path) {
        if (path == null) {
            return null;
        }
        File file = new File(path).getAbsoluteFile();
        File dir = file.getParentFile();
        if (dir == null || !dir.exists()) {
            throw new IllegalArgumentException("Cannot write to folder: " + file);
        }
        return file;
    }

    private static File getWritableFolder(String path) {
        if (path == null) {
            return null;
        }
        File dir = new File(path).getAbsoluteFile();
        if (!dir.exists()) {
            throw new IllegalArgumentException("Cannot write to folder: " + dir);
        }
        return dir;
    }

    private static File getReadableFile(String path) {
        if (path == null) {
            return null;
        }
        File file = new File(path).getAbsoluteFile();
        if (!file.exists()) {
            throw new IllegalArgumentException("Cannot find file: " + file.getAbsolutePath());
        }
        return file;
    }

    public static class ConsoleProgressListener
    implements Deobfuscator.ProgressListener {
        private static final int ReportTime = 5000;
        private int m_totalWork;
        private long m_startTime;
        private long m_lastReportTime;

        @Override
        public void init(int totalWork, String title) {
            this.m_totalWork = totalWork;
            this.m_lastReportTime = this.m_startTime = System.currentTimeMillis();
            System.out.println(title);
        }

        @Override
        public void onProgress(int numDone, String message) {
            boolean shouldReport;
            long now = System.currentTimeMillis();
            boolean isLastUpdate = numDone == this.m_totalWork;
            boolean bl = shouldReport = isLastUpdate || now - this.m_lastReportTime > 5000L;
            if (shouldReport) {
                int percent = numDone * 100 / this.m_totalWork;
                System.out.println(String.format("\tProgress: %3d%%", percent));
                this.m_lastReportTime = now;
            }
            if (isLastUpdate) {
                double elapsedSeconds = (now - this.m_startTime) / 1000L;
                System.out.println(String.format("Finished in %.1f seconds", elapsedSeconds));
            }
        }
    }
}

