/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.mapping.ArgumentEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ClassMapping;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.FieldMapping;
import cuchaz.enigma.mapping.IllegalNameException;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MethodEntry;
import cuchaz.enigma.mapping.MethodMapping;
import cuchaz.enigma.mapping.NameValidator;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.TranslationDirection;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPOutputStream;

public class MappingsRenamer {
    private JarIndex m_index;
    private Mappings m_mappings;

    public MappingsRenamer(JarIndex index, Mappings mappings) {
        this.m_index = index;
        this.m_mappings = mappings;
    }

    public void setClassName(ClassEntry obf, String deobfName) {
        deobfName = NameValidator.validateClassName(deobfName, !obf.isInnerClass());
        List<ClassMapping> mappingChain = this.getOrCreateClassMappingChain(obf);
        if (mappingChain.size() == 1) {
            if (deobfName != null && (this.m_mappings.containsDeobfClass(deobfName) || this.m_index.containsObfClass(new ClassEntry(deobfName)))) {
                throw new IllegalNameException(deobfName, "There is already a class with that name");
            }
            ClassMapping classMapping = mappingChain.get(0);
            this.m_mappings.setClassDeobfName(classMapping, deobfName);
        } else {
            ClassMapping outerClassMapping = mappingChain.get(mappingChain.size() - 2);
            if (deobfName != null && (outerClassMapping.hasInnerClassByDeobf(deobfName) || outerClassMapping.hasInnerClassByObfSimple(deobfName))) {
                throw new IllegalNameException(deobfName, "There is already a class with that name");
            }
            outerClassMapping.setInnerClassName(obf, deobfName);
        }
    }

    public void removeClassMapping(ClassEntry obf) {
        this.setClassName(obf, null);
    }

    public void markClassAsDeobfuscated(ClassEntry obf) {
        String deobfName = obf.isInnerClass() ? obf.getInnermostClassName() : obf.getName();
        List<ClassMapping> mappingChain = this.getOrCreateClassMappingChain(obf);
        if (mappingChain.size() == 1) {
            ClassMapping classMapping = mappingChain.get(0);
            this.m_mappings.setClassDeobfName(classMapping, deobfName);
        } else {
            ClassMapping outerClassMapping = mappingChain.get(mappingChain.size() - 2);
            outerClassMapping.setInnerClassName(obf, deobfName);
        }
    }

    public void setFieldName(FieldEntry obf, String deobfName) {
        deobfName = NameValidator.validateFieldName(deobfName);
        FieldEntry targetEntry = new FieldEntry(obf.getClassEntry(), deobfName, obf.getType());
        if (this.m_mappings.containsDeobfField(obf.getClassEntry(), deobfName, obf.getType()) || this.m_index.containsObfField(targetEntry)) {
            throw new IllegalNameException(deobfName, "There is already a field with that name");
        }
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.setFieldName(obf.getName(), obf.getType(), deobfName);
    }

    public void removeFieldMapping(FieldEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.removeFieldMapping(classMapping.getFieldByObf(obf.getName(), obf.getType()));
    }

    public void markFieldAsDeobfuscated(FieldEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.setFieldName(obf.getName(), obf.getType(), obf.getName());
    }

    public void setMethodTreeName(MethodEntry obf, String deobfName) {
        Set<MethodEntry> implementations = this.m_index.getRelatedMethodImplementations(obf);
        deobfName = NameValidator.validateMethodName(deobfName);
        for (MethodEntry entry : implementations) {
            Signature deobfSignature = this.m_mappings.getTranslator(TranslationDirection.Deobfuscating, this.m_index.getTranslationIndex()).translateSignature(obf.getSignature());
            MethodEntry targetEntry = new MethodEntry(entry.getClassEntry(), deobfName, deobfSignature);
            if (!this.m_mappings.containsDeobfMethod(entry.getClassEntry(), deobfName, entry.getSignature()) && !this.m_index.containsObfBehavior(targetEntry)) continue;
            String deobfClassName = this.m_mappings.getTranslator(TranslationDirection.Deobfuscating, this.m_index.getTranslationIndex()).translateClass(entry.getClassName());
            throw new IllegalNameException(deobfName, "There is already a method with that name and signature in class " + deobfClassName);
        }
        for (MethodEntry entry : implementations) {
            this.setMethodName(entry, deobfName);
        }
    }

    public void setMethodName(MethodEntry obf, String deobfName) {
        deobfName = NameValidator.validateMethodName(deobfName);
        MethodEntry targetEntry = new MethodEntry(obf.getClassEntry(), deobfName, obf.getSignature());
        if (this.m_mappings.containsDeobfMethod(obf.getClassEntry(), deobfName, obf.getSignature()) || this.m_index.containsObfBehavior(targetEntry)) {
            String deobfClassName = this.m_mappings.getTranslator(TranslationDirection.Deobfuscating, this.m_index.getTranslationIndex()).translateClass(obf.getClassName());
            throw new IllegalNameException(deobfName, "There is already a method with that name and signature in class " + deobfClassName);
        }
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.setMethodName(obf.getName(), obf.getSignature(), deobfName);
    }

    public void removeMethodTreeMapping(MethodEntry obf) {
        for (MethodEntry implementation : this.m_index.getRelatedMethodImplementations(obf)) {
            this.removeMethodMapping(implementation);
        }
    }

    public void removeMethodMapping(MethodEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.setMethodName(obf.getName(), obf.getSignature(), null);
    }

    public void markMethodTreeAsDeobfuscated(MethodEntry obf) {
        for (MethodEntry implementation : this.m_index.getRelatedMethodImplementations(obf)) {
            this.markMethodAsDeobfuscated(implementation);
        }
    }

    public void markMethodAsDeobfuscated(MethodEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.setMethodName(obf.getName(), obf.getSignature(), obf.getName());
    }

    public void setArgumentName(ArgumentEntry obf, String deobfName) {
        deobfName = NameValidator.validateArgumentName(deobfName);
        if (this.m_mappings.containsArgument(obf.getBehaviorEntry(), deobfName)) {
            throw new IllegalNameException(deobfName, "There is already an argument with that name");
        }
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.setArgumentName(obf.getMethodName(), obf.getMethodSignature(), obf.getIndex(), deobfName);
    }

    public void removeArgumentMapping(ArgumentEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.removeArgumentName(obf.getMethodName(), obf.getMethodSignature(), obf.getIndex());
    }

    public void markArgumentAsDeobfuscated(ArgumentEntry obf) {
        ClassMapping classMapping = this.getOrCreateClassMapping(obf.getClassEntry());
        classMapping.setArgumentName(obf.getMethodName(), obf.getMethodSignature(), obf.getIndex(), obf.getName());
    }

    public boolean moveFieldToObfClass(ClassMapping classMapping, FieldMapping fieldMapping, ClassEntry obfClass) {
        classMapping.removeFieldMapping(fieldMapping);
        ClassMapping targetClassMapping = this.getOrCreateClassMapping(obfClass);
        if (!targetClassMapping.containsObfField(fieldMapping.getObfName(), fieldMapping.getObfType())) {
            if (!targetClassMapping.containsDeobfField(fieldMapping.getDeobfName(), fieldMapping.getObfType())) {
                targetClassMapping.addFieldMapping(fieldMapping);
                return true;
            }
            System.err.println("WARNING: deobf field was already there: " + obfClass + "." + fieldMapping.getDeobfName());
        }
        return false;
    }

    public boolean moveMethodToObfClass(ClassMapping classMapping, MethodMapping methodMapping, ClassEntry obfClass) {
        classMapping.removeMethodMapping(methodMapping);
        ClassMapping targetClassMapping = this.getOrCreateClassMapping(obfClass);
        if (!targetClassMapping.containsObfMethod(methodMapping.getObfName(), methodMapping.getObfSignature())) {
            if (!targetClassMapping.containsDeobfMethod(methodMapping.getDeobfName(), methodMapping.getObfSignature())) {
                targetClassMapping.addMethodMapping(methodMapping);
                return true;
            }
            System.err.println("WARNING: deobf method was already there: " + obfClass + "." + methodMapping.getDeobfName() + methodMapping.getObfSignature());
        }
        return false;
    }

    public void write(OutputStream out) throws IOException {
        GZIPOutputStream gzipout = new GZIPOutputStream(out);
        ObjectOutputStream oout = new ObjectOutputStream(gzipout);
        oout.writeObject(this);
        gzipout.finish();
    }

    private ClassMapping getOrCreateClassMapping(ClassEntry obfClassEntry) {
        List<ClassMapping> mappingChain = this.getOrCreateClassMappingChain(obfClassEntry);
        return mappingChain.get(mappingChain.size() - 1);
    }

    private List<ClassMapping> getOrCreateClassMappingChain(ClassEntry obfClassEntry) {
        List<ClassEntry> classChain = obfClassEntry.getClassChain();
        List<ClassMapping> mappingChain = this.m_mappings.getClassMappingChain(obfClassEntry);
        int i = 0;
        while (i < classChain.size()) {
            ClassEntry classEntry = classChain.get(i);
            ClassMapping classMapping = mappingChain.get(i);
            if (classMapping == null) {
                classMapping = new ClassMapping(classEntry.getName());
                mappingChain.set(i, classMapping);
                if (i == 0) {
                    this.m_mappings.addClassMapping(classMapping);
                } else {
                    mappingChain.get(i - 1).addInnerClassMapping(classMapping);
                }
            }
            ++i;
        }
        return mappingChain;
    }
}

