/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.convert.ClassMatches;
import cuchaz.enigma.convert.MemberMatches;
import cuchaz.enigma.gui.ClassSelector;
import cuchaz.enigma.gui.CodeReader;
import cuchaz.enigma.gui.DeobfuscatedHighlightPainter;
import cuchaz.enigma.gui.GuiTricks;
import cuchaz.enigma.gui.ObfuscatedHighlightPainter;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import de.sciss.syntaxpane.DefaultSyntaxKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.text.Highlighter;

public class MemberMatchingGui<T extends Entry> {
    private JFrame m_frame;
    private Map<SourceType, JRadioButton> m_sourceTypeButtons;
    private ClassSelector m_sourceClasses;
    private CodeReader m_sourceReader;
    private CodeReader m_destReader;
    private JButton m_matchButton;
    private JButton m_unmatchableButton;
    private JLabel m_sourceLabel;
    private JLabel m_destLabel;
    private Highlighter.HighlightPainter m_unmatchedHighlightPainter;
    private Highlighter.HighlightPainter m_matchedHighlightPainter;
    private ClassMatches m_classMatches;
    private MemberMatches<T> m_memberMatches;
    private Deobfuscator m_sourceDeobfuscator;
    private Deobfuscator m_destDeobfuscator;
    private SaveListener<T> m_saveListener;
    private SourceType m_sourceType;
    private ClassEntry m_obfSourceClass;
    private ClassEntry m_obfDestClass;
    private T m_obfSourceEntry;
    private T m_obfDestEntry;

    public MemberMatchingGui(ClassMatches classMatches, MemberMatches<T> fieldMatches, Deobfuscator sourceDeobfuscator, Deobfuscator destDeobfuscator) {
        this.m_classMatches = classMatches;
        this.m_memberMatches = fieldMatches;
        this.m_sourceDeobfuscator = sourceDeobfuscator;
        this.m_destDeobfuscator = destDeobfuscator;
        this.m_frame = new JFrame("Enigma - Member Matcher");
        Container pane = this.m_frame.getContentPane();
        pane.setLayout(new BorderLayout());
        JPanel classesPanel = new JPanel();
        classesPanel.setLayout(new BoxLayout(classesPanel, 3));
        classesPanel.setPreferredSize(new Dimension(200, 0));
        pane.add((Component)classesPanel, "West");
        classesPanel.add(new JLabel("Classes"));
        JPanel sourceTypePanel = new JPanel();
        classesPanel.add(sourceTypePanel);
        sourceTypePanel.setLayout(new BoxLayout(sourceTypePanel, 3));
        ActionListener sourceTypeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MemberMatchingGui.this.setSourceType(SourceType.valueOf(event.getActionCommand()));
            }
        };
        ButtonGroup sourceTypeButtons = new ButtonGroup();
        this.m_sourceTypeButtons = Maps.newHashMap();
        SourceType[] sourceTypeArray = SourceType.values();
        int n = sourceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SourceType sourceType = sourceTypeArray[n2];
            JRadioButton button = sourceType.newRadio(sourceTypeListener, sourceTypeButtons);
            this.m_sourceTypeButtons.put(sourceType, button);
            sourceTypePanel.add(button);
            ++n2;
        }
        this.m_sourceClasses = new ClassSelector(ClassSelector.DeobfuscatedClassEntryComparator);
        this.m_sourceClasses.setListener(new ClassSelector.ClassSelectionListener(){

            @Override
            public void onSelectClass(ClassEntry classEntry) {
                MemberMatchingGui.this.setSourceClass(classEntry);
            }
        });
        JScrollPane sourceScroller = new JScrollPane(this.m_sourceClasses);
        classesPanel.add(sourceScroller);
        DefaultSyntaxKit.initKit();
        this.m_sourceReader = new CodeReader();
        this.m_sourceReader.setSelectionListener(new CodeReader.SelectionListener(){

            @Override
            public void onSelect(EntryReference<Entry, Entry> reference) {
                if (reference != null) {
                    MemberMatchingGui.this.onSelectSource((Entry)reference.entry);
                } else {
                    MemberMatchingGui.this.onSelectSource(null);
                }
            }
        });
        this.m_destReader = new CodeReader();
        this.m_destReader.setSelectionListener(new CodeReader.SelectionListener(){

            @Override
            public void onSelect(EntryReference<Entry, Entry> reference) {
                if (reference != null) {
                    MemberMatchingGui.this.onSelectDest((Entry)reference.entry);
                } else {
                    MemberMatchingGui.this.onSelectDest(null);
                }
            }
        });
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                switch (event.getKeyCode()) {
                    case 77: {
                        MemberMatchingGui.this.m_matchButton.doClick();
                    }
                }
            }
        };
        this.m_sourceReader.addKeyListener(keyListener);
        this.m_destReader.addKeyListener(keyListener);
        JSplitPane splitRight = new JSplitPane(1, true, new JScrollPane(this.m_sourceReader), new JScrollPane(this.m_destReader));
        splitRight.setResizeWeight(0.5);
        JSplitPane splitLeft = new JSplitPane(1, true, classesPanel, splitRight);
        splitLeft.setResizeWeight(0.0);
        pane.add((Component)splitLeft, "Center");
        splitLeft.resetToPreferredSizes();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout());
        pane.add((Component)bottomPanel, "South");
        this.m_matchButton = new JButton();
        this.m_unmatchableButton = new JButton();
        this.m_sourceLabel = new JLabel();
        bottomPanel.add(this.m_sourceLabel);
        bottomPanel.add(this.m_matchButton);
        bottomPanel.add(this.m_unmatchableButton);
        this.m_destLabel = new JLabel();
        bottomPanel.add(this.m_destLabel);
        pane.doLayout();
        this.m_frame.setSize(1024, 576);
        this.m_frame.setMinimumSize(new Dimension(640, 480));
        this.m_frame.setVisible(true);
        this.m_frame.setDefaultCloseOperation(2);
        this.m_unmatchedHighlightPainter = new ObfuscatedHighlightPainter();
        this.m_matchedHighlightPainter = new DeobfuscatedHighlightPainter();
        this.m_saveListener = null;
        this.m_obfSourceClass = null;
        this.m_obfDestClass = null;
        this.m_obfSourceEntry = null;
        this.m_obfDestEntry = null;
        this.setSourceType(SourceType.getDefault());
        this.updateButtons();
    }

    protected void setSourceType(SourceType val) {
        this.m_sourceType = val;
        this.updateSourceClasses();
    }

    public void setSaveListener(SaveListener<T> val) {
        this.m_saveListener = val;
    }

    private void updateSourceClasses() {
        String selectedPackage = this.m_sourceClasses.getSelectedPackage();
        ArrayList deobfClassEntries = Lists.newArrayList();
        for (ClassEntry entry : this.m_sourceType.getObfSourceClasses(this.m_memberMatches)) {
            deobfClassEntries.add(this.m_sourceDeobfuscator.deobfuscateEntry(entry));
        }
        this.m_sourceClasses.setClasses(deobfClassEntries);
        if (selectedPackage != null) {
            this.m_sourceClasses.expandPackage(selectedPackage);
        }
        SourceType[] sourceTypeArray = SourceType.values();
        int n = sourceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SourceType sourceType = sourceTypeArray[n2];
            this.m_sourceTypeButtons.get((Object)sourceType).setText(String.format("%s (%d)", sourceType.name(), sourceType.getObfSourceClasses(this.m_memberMatches).size()));
            ++n2;
        }
    }

    protected void setSourceClass(ClassEntry sourceClass) {
        this.m_obfSourceClass = this.m_sourceDeobfuscator.obfuscateEntry(sourceClass);
        this.m_obfDestClass = (ClassEntry)this.m_classMatches.getUniqueMatches().get((Object)this.m_obfSourceClass);
        if (this.m_obfDestClass == null) {
            throw new Error("No matching dest class for source class: " + this.m_obfSourceClass);
        }
        this.m_sourceReader.decompileClass(this.m_obfSourceClass, this.m_sourceDeobfuscator, false, new Runnable(){

            @Override
            public void run() {
                MemberMatchingGui.this.updateSourceHighlights();
            }
        });
        this.m_destReader.decompileClass(this.m_obfDestClass, this.m_destDeobfuscator, false, new Runnable(){

            @Override
            public void run() {
                MemberMatchingGui.this.updateDestHighlights();
            }
        });
    }

    protected void updateSourceHighlights() {
        this.highlightEntries(this.m_sourceReader, this.m_sourceDeobfuscator, this.m_memberMatches.matches().keySet(), this.m_memberMatches.getUnmatchedSourceEntries());
    }

    protected void updateDestHighlights() {
        this.highlightEntries(this.m_destReader, this.m_destDeobfuscator, this.m_memberMatches.matches().values(), this.m_memberMatches.getUnmatchedDestEntries());
    }

    private void highlightEntries(CodeReader reader, Deobfuscator deobfuscator, Collection<T> obfMatchedEntries, Collection<T> obfUnmatchedEntries) {
        Token token;
        Entry deobfT;
        reader.clearHighlights();
        SourceIndex index = reader.getSourceIndex();
        for (Entry obfT : obfMatchedEntries) {
            deobfT = deobfuscator.deobfuscateEntry(obfT);
            token = index.getDeclarationToken(deobfT);
            if (token == null) continue;
            reader.setHighlightedToken(token, this.m_matchedHighlightPainter);
        }
        for (Entry obfT : obfUnmatchedEntries) {
            deobfT = deobfuscator.deobfuscateEntry(obfT);
            token = index.getDeclarationToken(deobfT);
            if (token == null) continue;
            reader.setHighlightedToken(token, this.m_unmatchedHighlightPainter);
        }
    }

    private boolean isSelectionMatched() {
        return this.m_obfSourceEntry != null && this.m_obfDestEntry != null && this.m_memberMatches.isMatched(this.m_obfSourceEntry, this.m_obfDestEntry);
    }

    protected void onSelectSource(Entry source) {
        Entry sourceEntry;
        Entry obfSourceEntry;
        if (this.isSelectionMatched()) {
            this.setDest(null);
        }
        this.setSource(null);
        if (source != null && this.m_memberMatches.hasSource(obfSourceEntry = this.m_sourceDeobfuscator.obfuscateEntry(sourceEntry = source))) {
            this.setSource(obfSourceEntry);
            Entry obfDestEntry = (Entry)this.m_memberMatches.matches().get((Object)obfSourceEntry);
            if (obfDestEntry != null) {
                this.setDest(obfDestEntry);
            }
        }
        this.updateButtons();
    }

    protected void onSelectDest(Entry dest) {
        Entry destEntry;
        Entry obfDestEntry;
        if (this.isSelectionMatched()) {
            this.setSource(null);
        }
        this.setDest(null);
        if (dest != null && this.m_memberMatches.hasDest(obfDestEntry = this.m_destDeobfuscator.obfuscateEntry(destEntry = dest))) {
            this.setDest(obfDestEntry);
            Entry obfSourceEntry = (Entry)this.m_memberMatches.matches().inverse().get((Object)obfDestEntry);
            if (obfSourceEntry != null) {
                this.setSource(obfSourceEntry);
            }
        }
        this.updateButtons();
    }

    private void setSource(T obfEntry) {
        if (obfEntry == null) {
            this.m_obfSourceEntry = obfEntry;
            this.m_sourceLabel.setText("");
        } else {
            this.m_obfSourceEntry = obfEntry;
            this.m_sourceLabel.setText(this.getEntryLabel(obfEntry, this.m_sourceDeobfuscator));
        }
    }

    private void setDest(T obfEntry) {
        if (obfEntry == null) {
            this.m_obfDestEntry = obfEntry;
            this.m_destLabel.setText("");
        } else {
            this.m_obfDestEntry = obfEntry;
            this.m_destLabel.setText(this.getEntryLabel(obfEntry, this.m_destDeobfuscator));
        }
    }

    private String getEntryLabel(T obfEntry, Deobfuscator deobfuscator) {
        T deobfEntry = deobfuscator.deobfuscateEntry(obfEntry);
        return String.format("%s (%s)", deobfEntry.getName(), obfEntry.getName());
    }

    private void updateButtons() {
        GuiTricks.deactivateButton(this.m_matchButton);
        GuiTricks.deactivateButton(this.m_unmatchableButton);
        if (this.m_obfSourceEntry != null && this.m_obfDestEntry != null) {
            if (this.m_memberMatches.isMatched(this.m_obfSourceEntry, this.m_obfDestEntry)) {
                GuiTricks.activateButton(this.m_matchButton, "Unmatch", new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        MemberMatchingGui.this.unmatch();
                    }
                });
            } else if (!this.m_memberMatches.isMatchedSourceEntry(this.m_obfSourceEntry) && !this.m_memberMatches.isMatchedDestEntry(this.m_obfDestEntry)) {
                GuiTricks.activateButton(this.m_matchButton, "Match", new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        MemberMatchingGui.this.match();
                    }
                });
            }
        } else if (this.m_obfSourceEntry != null) {
            GuiTricks.activateButton(this.m_unmatchableButton, "Set Unmatchable", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    MemberMatchingGui.this.unmatchable();
                }
            });
        }
    }

    protected void match() {
        this.m_memberMatches.makeMatch(this.m_obfSourceEntry, this.m_obfDestEntry);
        this.save();
        this.onSelectSource(null);
        this.onSelectDest(null);
        this.updateSourceHighlights();
        this.updateDestHighlights();
        this.updateSourceClasses();
    }

    protected void unmatch() {
        this.m_memberMatches.unmakeMatch(this.m_obfSourceEntry, this.m_obfDestEntry);
        this.save();
        this.onSelectSource(null);
        this.onSelectDest(null);
        this.updateSourceHighlights();
        this.updateDestHighlights();
        this.updateSourceClasses();
    }

    protected void unmatchable() {
        this.m_memberMatches.makeSourceUnmatchable(this.m_obfSourceEntry);
        this.save();
        this.onSelectSource(null);
        this.onSelectDest(null);
        this.updateSourceHighlights();
        this.updateDestHighlights();
        this.updateSourceClasses();
    }

    private void save() {
        if (this.m_saveListener != null) {
            this.m_saveListener.save(this.m_memberMatches);
        }
    }

    public static interface SaveListener<T extends Entry> {
        public void save(MemberMatches<T> var1);
    }

    private static enum SourceType {
        Matched{

            @Override
            public <T extends Entry> Collection<ClassEntry> getObfSourceClasses(MemberMatches<T> matches) {
                return matches.getSourceClassesWithoutUnmatchedEntries();
            }
        }
        ,
        Unmatched{

            @Override
            public <T extends Entry> Collection<ClassEntry> getObfSourceClasses(MemberMatches<T> matches) {
                return matches.getSourceClassesWithUnmatchedEntries();
            }
        };


        public JRadioButton newRadio(ActionListener listener, ButtonGroup group) {
            JRadioButton button = new JRadioButton(this.name(), this == SourceType.getDefault());
            button.setActionCommand(this.name());
            button.addActionListener(listener);
            group.add(button);
            return button;
        }

        public abstract <T extends Entry> Collection<ClassEntry> getObfSourceClasses(MemberMatches<T> var1);

        public static SourceType getDefault() {
            return SourceType.values()[0];
        }
    }
}

