/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cuchaz.enigma.Deobfuscator;
import cuchaz.enigma.convert.ClassIdentifier;
import cuchaz.enigma.convert.ClassIdentity;
import cuchaz.enigma.convert.ClassMatch;
import cuchaz.enigma.convert.ClassMatches;
import cuchaz.enigma.convert.ClassMatching;
import cuchaz.enigma.convert.ClassNamer;
import cuchaz.enigma.convert.MappingsConverter;
import cuchaz.enigma.gui.ClassSelector;
import cuchaz.enigma.gui.ClassSelectorClassNode;
import cuchaz.enigma.gui.ClassSelectorPackageNode;
import cuchaz.enigma.gui.CodeReader;
import cuchaz.enigma.gui.GuiTricks;
import cuchaz.enigma.gui.ScoredClassEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Mappings;
import cuchaz.enigma.mapping.MappingsChecker;
import de.sciss.syntaxpane.DefaultSyntaxKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class ClassMatchingGui {
    private JFrame m_frame;
    private ClassSelector m_sourceClasses;
    private ClassSelector m_destClasses;
    private CodeReader m_sourceReader;
    private CodeReader m_destReader;
    private JLabel m_sourceClassLabel;
    private JLabel m_destClassLabel;
    private JButton m_matchButton;
    private Map<SourceType, JRadioButton> m_sourceTypeButtons;
    private JCheckBox m_advanceCheck;
    private ClassMatches m_classMatches;
    private Deobfuscator m_sourceDeobfuscator;
    private Deobfuscator m_destDeobfuscator;
    private ClassEntry m_sourceClass;
    private ClassEntry m_destClass;
    private SourceType m_sourceType;
    private SaveListener m_saveListener;

    public ClassMatchingGui(ClassMatches matches, Deobfuscator sourceDeobfuscator, Deobfuscator destDeobfuscator) {
        this.m_classMatches = matches;
        this.m_sourceDeobfuscator = sourceDeobfuscator;
        this.m_destDeobfuscator = destDeobfuscator;
        this.m_frame = new JFrame("Enigma - Class Matcher");
        Container pane = this.m_frame.getContentPane();
        pane.setLayout(new BorderLayout());
        JPanel sourcePanel = new JPanel();
        sourcePanel.setLayout(new BoxLayout(sourcePanel, 3));
        sourcePanel.setPreferredSize(new Dimension(200, 0));
        pane.add((Component)sourcePanel, "West");
        sourcePanel.add(new JLabel("Source Classes"));
        JPanel sourceTypePanel = new JPanel();
        sourcePanel.add(sourceTypePanel);
        sourceTypePanel.setLayout(new BoxLayout(sourceTypePanel, 3));
        ActionListener sourceTypeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ClassMatchingGui.this.setSourceType(SourceType.valueOf(event.getActionCommand()));
            }
        };
        ButtonGroup sourceTypeButtons = new ButtonGroup();
        this.m_sourceTypeButtons = Maps.newHashMap();
        SourceType[] sourceTypeArray = SourceType.values();
        int n = sourceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SourceType sourceType = sourceTypeArray[n2];
            JRadioButton button = sourceType.newRadio(sourceTypeListener, sourceTypeButtons);
            this.m_sourceTypeButtons.put(sourceType, button);
            sourceTypePanel.add(button);
            ++n2;
        }
        this.m_sourceClasses = new ClassSelector(ClassSelector.DeobfuscatedClassEntryComparator);
        this.m_sourceClasses.setListener(new ClassSelector.ClassSelectionListener(){

            @Override
            public void onSelectClass(ClassEntry classEntry) {
                ClassMatchingGui.this.setSourceClass(classEntry);
            }
        });
        JScrollPane sourceScroller = new JScrollPane(this.m_sourceClasses);
        sourcePanel.add(sourceScroller);
        JPanel destPanel = new JPanel();
        destPanel.setLayout(new BoxLayout(destPanel, 3));
        destPanel.setPreferredSize(new Dimension(200, 0));
        pane.add((Component)destPanel, "West");
        destPanel.add(new JLabel("Destination Classes"));
        this.m_destClasses = new ClassSelector(ClassSelector.DeobfuscatedClassEntryComparator);
        this.m_destClasses.setListener(new ClassSelector.ClassSelectionListener(){

            @Override
            public void onSelectClass(ClassEntry classEntry) {
                ClassMatchingGui.this.setDestClass(classEntry);
            }
        });
        JScrollPane destScroller = new JScrollPane(this.m_destClasses);
        destPanel.add(destScroller);
        JButton autoMatchButton = new JButton("AutoMatch");
        autoMatchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ClassMatchingGui.this.autoMatch();
            }
        });
        destPanel.add(autoMatchButton);
        DefaultSyntaxKit.initKit();
        this.m_sourceReader = new CodeReader();
        this.m_destReader = new CodeReader();
        JSplitPane splitLeft = new JSplitPane(1, true, sourcePanel, new JScrollPane(this.m_sourceReader));
        splitLeft.setResizeWeight(0.0);
        JSplitPane splitRight = new JSplitPane(1, true, new JScrollPane(this.m_destReader), destPanel);
        splitRight.setResizeWeight(1.0);
        JSplitPane splitCenter = new JSplitPane(1, true, splitLeft, splitRight);
        splitCenter.setResizeWeight(0.5);
        pane.add((Component)splitCenter, "Center");
        splitCenter.resetToPreferredSizes();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout());
        this.m_sourceClassLabel = new JLabel();
        this.m_sourceClassLabel.setHorizontalAlignment(4);
        this.m_destClassLabel = new JLabel();
        this.m_destClassLabel.setHorizontalAlignment(2);
        this.m_matchButton = new JButton();
        this.m_advanceCheck = new JCheckBox("Advance to next likely match");
        this.m_advanceCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (ClassMatchingGui.this.m_advanceCheck.isSelected()) {
                    ClassMatchingGui.this.advance();
                }
            }
        });
        bottomPanel.add(this.m_sourceClassLabel);
        bottomPanel.add(this.m_matchButton);
        bottomPanel.add(this.m_destClassLabel);
        bottomPanel.add(this.m_advanceCheck);
        pane.add((Component)bottomPanel, "South");
        pane.doLayout();
        this.m_frame.setSize(1024, 576);
        this.m_frame.setMinimumSize(new Dimension(640, 480));
        this.m_frame.setVisible(true);
        this.m_frame.setDefaultCloseOperation(2);
        this.updateDestMappings();
        this.setSourceType(SourceType.getDefault());
        this.updateMatchButton();
        this.m_saveListener = null;
    }

    public void setSaveListener(SaveListener val) {
        this.m_saveListener = val;
    }

    private void updateDestMappings() {
        Mappings newMappings = MappingsConverter.newMappings(this.m_classMatches, this.m_sourceDeobfuscator.getMappings(), this.m_sourceDeobfuscator, this.m_destDeobfuscator);
        MappingsChecker checker = new MappingsChecker(this.m_destDeobfuscator.getJarIndex());
        checker.dropBrokenMappings(newMappings);
        int numDroppedFields = checker.getDroppedFieldMappings().size();
        int numDroppedMethods = checker.getDroppedMethodMappings().size();
        System.out.println(String.format("%d mappings from matched classes don't match the dest jar:\n\t%5d fields\n\t%5d methods", numDroppedFields + numDroppedMethods, numDroppedFields, numDroppedMethods));
        this.m_destDeobfuscator.setMappings(newMappings);
    }

    protected void setSourceType(SourceType val) {
        this.m_sourceType = val;
        this.m_sourceClasses.setClasses(this.deobfuscateClasses(this.m_sourceType.getSourceClasses(this.m_classMatches), this.m_sourceDeobfuscator));
        SourceType[] sourceTypeArray = SourceType.values();
        int n = sourceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SourceType sourceType = sourceTypeArray[n2];
            this.m_sourceTypeButtons.get((Object)sourceType).setText(String.format("%s (%d)", sourceType.name(), sourceType.getSourceClasses(this.m_classMatches).size()));
            ++n2;
        }
    }

    private Collection<ClassEntry> deobfuscateClasses(Collection<ClassEntry> in, Deobfuscator deobfuscator) {
        ArrayList out = Lists.newArrayList();
        for (ClassEntry entry : in) {
            ClassEntry deobf = deobfuscator.deobfuscateEntry(entry);
            if (entry instanceof ScoredClassEntry) {
                deobf = new ScoredClassEntry(deobf, ((ScoredClassEntry)entry).getScore());
            }
            out.add(deobf);
        }
        return out;
    }

    protected void setSourceClass(ClassEntry classEntry) {
        Runnable onGetDestClasses = null;
        if (this.m_advanceCheck.isSelected()) {
            onGetDestClasses = new Runnable(){

                @Override
                public void run() {
                    ClassMatchingGui.this.pickBestDestClass();
                }
            };
        }
        this.setSourceClass(classEntry, onGetDestClasses);
    }

    protected void setSourceClass(ClassEntry classEntry, final Runnable onGetDestClasses) {
        this.m_sourceClass = classEntry;
        this.m_sourceClassLabel.setText(this.m_sourceClass != null ? this.m_sourceClass.getName() : "");
        if (this.m_sourceClass != null) {
            ClassMatch match = this.m_classMatches.getMatchBySource(this.m_sourceDeobfuscator.obfuscateEntry(this.m_sourceClass));
            assert (match != null);
            if (match.destClasses.isEmpty()) {
                this.m_destClasses.setClasses(null);
                new Thread(){

                    @Override
                    public void run() {
                        ClassMatchingGui.this.m_destClasses.setClasses(ClassMatchingGui.this.deobfuscateClasses(ClassMatchingGui.this.getLikelyMatches(ClassMatchingGui.this.m_sourceClass), ClassMatchingGui.this.m_destDeobfuscator));
                        ClassMatchingGui.this.m_destClasses.expandAll();
                        if (onGetDestClasses != null) {
                            onGetDestClasses.run();
                        }
                    }
                }.start();
            } else {
                this.m_destClasses.setClasses(this.deobfuscateClasses(match.destClasses, this.m_destDeobfuscator));
                this.m_destClasses.expandAll();
                if (onGetDestClasses != null) {
                    onGetDestClasses.run();
                }
            }
        }
        this.setDestClass(null);
        this.m_sourceReader.decompileClass(this.m_sourceClass, this.m_sourceDeobfuscator, new Runnable(){

            @Override
            public void run() {
                ClassMatchingGui.this.m_sourceReader.navigateToClassDeclaration(ClassMatchingGui.this.m_sourceClass);
            }
        });
        this.updateMatchButton();
    }

    private Collection<ClassEntry> getLikelyMatches(ClassEntry sourceClass) {
        ClassEntry obfSourceClass = this.m_sourceDeobfuscator.obfuscateEntry(sourceClass);
        ClassNamer namer = new ClassNamer(this.m_classMatches.getUniqueMatches());
        ClassIdentifier sourceIdentifier = new ClassIdentifier(this.m_sourceDeobfuscator.getJar(), this.m_sourceDeobfuscator.getJarIndex(), namer.getSourceNamer(), true);
        ClassIdentifier destIdentifier = new ClassIdentifier(this.m_destDeobfuscator.getJar(), this.m_destDeobfuscator.getJarIndex(), namer.getDestNamer(), true);
        try {
            ClassIdentity sourceIdentity = sourceIdentifier.identify(obfSourceClass);
            ArrayList scoredDestClasses = Lists.newArrayList();
            for (ClassEntry unmatchedDestClass : this.m_classMatches.getUnmatchedDestClasses()) {
                ClassIdentity destIdentity = destIdentifier.identify(unmatchedDestClass);
                float score = 100.0f * (float)(sourceIdentity.getMatchScore(destIdentity) + destIdentity.getMatchScore(sourceIdentity)) / (float)(sourceIdentity.getMaxMatchScore() + destIdentity.getMaxMatchScore());
                scoredDestClasses.add(new ScoredClassEntry(unmatchedDestClass, score));
            }
            return scoredDestClasses;
        }
        catch (ClassNotFoundException ex) {
            throw new Error("Unable to find class " + ex.getMessage());
        }
    }

    protected void setDestClass(ClassEntry classEntry) {
        this.m_destClass = classEntry;
        this.m_destClassLabel.setText(this.m_destClass != null ? this.m_destClass.getName() : "");
        this.m_destReader.decompileClass(this.m_destClass, this.m_destDeobfuscator, new Runnable(){

            @Override
            public void run() {
                ClassMatchingGui.this.m_destReader.navigateToClassDeclaration(ClassMatchingGui.this.m_destClass);
            }
        });
        this.updateMatchButton();
    }

    private void updateMatchButton() {
        ClassEntry obfSource = this.m_sourceDeobfuscator.obfuscateEntry(this.m_sourceClass);
        ClassEntry obfDest = this.m_destDeobfuscator.obfuscateEntry(this.m_destClass);
        BiMap<ClassEntry, ClassEntry> uniqueMatches = this.m_classMatches.getUniqueMatches();
        boolean twoSelected = this.m_sourceClass != null && this.m_destClass != null;
        boolean isMatched = uniqueMatches.containsKey((Object)obfSource) && uniqueMatches.containsValue((Object)obfDest);
        boolean canMatch = !uniqueMatches.containsKey((Object)obfSource) && !uniqueMatches.containsValue((Object)obfDest);
        GuiTricks.deactivateButton(this.m_matchButton);
        if (twoSelected) {
            if (isMatched) {
                GuiTricks.activateButton(this.m_matchButton, "Unmatch", new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        ClassMatchingGui.this.onUnmatchClick();
                    }
                });
            } else if (canMatch) {
                GuiTricks.activateButton(this.m_matchButton, "Match", new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        ClassMatchingGui.this.onMatchClick();
                    }
                });
            }
        }
    }

    private void onMatchClick() {
        ClassEntry obfSource = this.m_sourceDeobfuscator.obfuscateEntry(this.m_sourceClass);
        ClassEntry obfDest = this.m_destDeobfuscator.obfuscateEntry(this.m_destClass);
        this.m_classMatches.removeSource(obfSource);
        this.m_classMatches.removeDest(obfDest);
        this.m_classMatches.add(new ClassMatch(obfSource, obfDest));
        ClassEntry nextClass = null;
        if (this.m_advanceCheck.isSelected()) {
            nextClass = this.m_sourceClasses.getNextClass(this.m_sourceClass);
        }
        this.save();
        this.updateMatches();
        if (nextClass != null) {
            this.advance(nextClass);
        }
    }

    private void onUnmatchClick() {
        ClassEntry obfSource = this.m_sourceDeobfuscator.obfuscateEntry(this.m_sourceClass);
        this.m_classMatches.removeSource(obfSource);
        this.m_classMatches.add(new ClassMatch(obfSource, null));
        this.save();
        this.updateMatches();
    }

    private void updateMatches() {
        this.updateDestMappings();
        this.setDestClass(null);
        this.m_destClasses.setClasses(null);
        this.updateMatchButton();
        String packageName = this.m_sourceClasses.getSelectedPackage();
        this.setSourceType(this.m_sourceType);
        this.m_sourceClasses.expandPackage(packageName);
    }

    private void save() {
        if (this.m_saveListener != null) {
            this.m_saveListener.save(this.m_classMatches);
        }
    }

    private void autoMatch() {
        System.out.println("Automatching...");
        ClassMatching matching = MappingsConverter.computeMatching(this.m_sourceDeobfuscator.getJar(), this.m_sourceDeobfuscator.getJarIndex(), this.m_destDeobfuscator.getJar(), this.m_destDeobfuscator.getJarIndex(), this.m_classMatches.getUniqueMatches());
        ClassMatches newMatches = new ClassMatches(matching.matches());
        System.out.println(String.format("Automatch found %d new matches", newMatches.getUniqueMatches().size() - this.m_classMatches.getUniqueMatches().size()));
        this.m_classMatches = newMatches;
        this.save();
        this.updateMatches();
    }

    private void advance() {
        this.advance(null);
    }

    private void advance(ClassEntry sourceClass) {
        if (sourceClass == null) {
            sourceClass = this.m_sourceClasses.getSelectedClass();
            sourceClass = sourceClass != null ? this.m_sourceClasses.getNextClass(sourceClass) : this.m_sourceClasses.getFirstClass();
        }
        this.setSourceClass(sourceClass, new Runnable(){

            @Override
            public void run() {
                ClassMatchingGui.this.pickBestDestClass();
            }
        });
        this.m_sourceClasses.setSelectionClass(sourceClass);
    }

    private void pickBestDestClass() {
        ClassEntry firstClass = null;
        ClassEntry bestDestClass = null;
        for (ClassSelectorPackageNode packageNode : this.m_destClasses.packageNodes()) {
            for (ClassSelectorClassNode classNode : this.m_destClasses.classNodes(packageNode)) {
                if (firstClass == null) {
                    firstClass = classNode.getClassEntry();
                }
                if (!(classNode.getClassEntry() instanceof ScoredClassEntry)) continue;
                ScoredClassEntry scoredClass = (ScoredClassEntry)classNode.getClassEntry();
                if (bestDestClass != null && !(((ScoredClassEntry)bestDestClass).getScore() < scoredClass.getScore())) continue;
                bestDestClass = scoredClass;
            }
        }
        ClassEntry destClass = null;
        if (bestDestClass != null) {
            destClass = bestDestClass;
        } else if (firstClass != null) {
            destClass = firstClass;
        }
        this.setDestClass(destClass);
        this.m_destClasses.setSelectionClass(destClass);
    }

    public static interface SaveListener {
        public void save(ClassMatches var1);
    }

    private static enum SourceType {
        Matched{

            @Override
            public Collection<ClassEntry> getSourceClasses(ClassMatches matches) {
                return matches.getUniqueMatches().keySet();
            }
        }
        ,
        Unmatched{

            @Override
            public Collection<ClassEntry> getSourceClasses(ClassMatches matches) {
                return matches.getUnmatchedSourceClasses();
            }
        }
        ,
        Ambiguous{

            @Override
            public Collection<ClassEntry> getSourceClasses(ClassMatches matches) {
                return matches.getAmbiguouslyMatchedSourceClasses();
            }
        };


        public JRadioButton newRadio(ActionListener listener, ButtonGroup group) {
            JRadioButton button = new JRadioButton(this.name(), this == SourceType.getDefault());
            button.setActionCommand(this.name());
            button.addActionListener(listener);
            group.add(button);
            return button;
        }

        public abstract Collection<ClassEntry> getSourceClasses(ClassMatches var1);

        public static SourceType getDefault() {
            return SourceType.values()[0];
        }
    }
}

