/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import cuchaz.enigma.convert.ClassMatch;
import cuchaz.enigma.convert.ClassMatches;
import cuchaz.enigma.convert.MemberMatches;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.FieldEntry;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;

public class MatchesWriter {
    public static void writeClasses(ClassMatches matches, File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter out = new FileWriter(file);){
            for (ClassMatch match : matches) {
                MatchesWriter.writeClassMatch(out, match);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void writeClassMatch(FileWriter out, ClassMatch match) throws IOException {
        MatchesWriter.writeClasses(out, match.sourceClasses);
        out.write(":");
        MatchesWriter.writeClasses(out, match.destClasses);
        out.write("\n");
    }

    private static void writeClasses(FileWriter out, Iterable<ClassEntry> classes) throws IOException {
        boolean isFirst = true;
        for (ClassEntry entry : classes) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.write(",");
            }
            out.write(entry.toString());
        }
    }

    public static <T extends Entry> void writeMembers(MemberMatches<T> matches, File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter out = new FileWriter(file);){
            for (Map.Entry match : matches.matches().entrySet()) {
                MatchesWriter.writeMemberMatch(out, (Entry)match.getKey(), (Entry)match.getValue());
            }
            for (Entry entry : matches.getUnmatchedSourceEntries()) {
                MatchesWriter.writeMemberMatch(out, entry, null);
            }
            for (Entry entry : matches.getUnmatchedDestEntries()) {
                MatchesWriter.writeMemberMatch(out, null, entry);
            }
            for (Entry entry : matches.getUnmatchableSourceEntries()) {
                MatchesWriter.writeUnmatchableEntry(out, entry);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static <T extends Entry> void writeMemberMatch(FileWriter out, T source, T dest) throws IOException {
        if (source != null) {
            MatchesWriter.writeEntry(out, source);
        }
        out.write(":");
        if (dest != null) {
            MatchesWriter.writeEntry(out, dest);
        }
        out.write("\n");
    }

    private static <T extends Entry> void writeUnmatchableEntry(FileWriter out, T entry) throws IOException {
        out.write("!");
        MatchesWriter.writeEntry(out, entry);
        out.write("\n");
    }

    private static <T extends Entry> void writeEntry(FileWriter out, T entry) throws IOException {
        if (entry instanceof FieldEntry) {
            MatchesWriter.writeField(out, (FieldEntry)entry);
        } else if (entry instanceof BehaviorEntry) {
            MatchesWriter.writeBehavior(out, (BehaviorEntry)entry);
        }
    }

    private static void writeField(FileWriter out, FieldEntry fieldEntry) throws IOException {
        out.write(fieldEntry.getClassName());
        out.write(" ");
        out.write(fieldEntry.getName());
        out.write(" ");
        out.write(fieldEntry.getType().toString());
    }

    private static void writeBehavior(FileWriter out, BehaviorEntry behaviorEntry) throws IOException {
        out.write(behaviorEntry.getClassName());
        out.write(" ");
        out.write(behaviorEntry.getName());
        out.write(" ");
        if (behaviorEntry.getSignature() != null) {
            out.write(behaviorEntry.getSignature().toString());
        }
    }
}

