/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode;

import cuchaz.enigma.bytecode.ClassRenamer;
import cuchaz.enigma.bytecode.ConstPoolEditor;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;
import cuchaz.enigma.mapping.Signature;
import cuchaz.enigma.mapping.Translator;
import cuchaz.enigma.mapping.Type;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.EnclosingMethodAttribute;
import javassist.bytecode.SourceFileAttribute;

public class ClassTranslator {
    private Translator m_translator;

    public ClassTranslator(Translator translator) {
        this.m_translator = translator;
    }

    public void translate(CtClass c) {
        Entry entry;
        ConstPool constants = c.getClassFile().getConstPool();
        ConstPoolEditor editor = new ConstPoolEditor(constants);
        int i = 1;
        while (i < constants.getSize()) {
            switch (constants.getTag(i)) {
                case 9: {
                    Entry entry2 = EntryFactory.getFieldEntry(Descriptor.toJvmName((String)constants.getFieldrefClassName(i)), constants.getFieldrefName(i), constants.getFieldrefType(i));
                    Entry translatedEntry = this.m_translator.translateEntry((FieldEntry)entry2);
                    if (((FieldEntry)entry2).equals((FieldEntry)translatedEntry)) break;
                    editor.changeMemberrefNameAndType(i, ((FieldEntry)translatedEntry).getName(), ((FieldEntry)translatedEntry).getType().toString());
                    break;
                }
                case 10: 
                case 11: {
                    Entry entry2 = EntryFactory.getBehaviorEntry(Descriptor.toJvmName((String)editor.getMemberrefClassname(i)), editor.getMemberrefName(i), editor.getMemberrefType(i));
                    Entry translatedEntry = this.m_translator.translateEntry((BehaviorEntry)entry2);
                    if (entry2.equals(translatedEntry)) break;
                    editor.changeMemberrefNameAndType(i, translatedEntry.getName(), translatedEntry.getSignature().toString());
                }
            }
            ++i;
        }
        ClassEntry classEntry = new ClassEntry(Descriptor.toJvmName((String)c.getName()));
        CtField[] ctFieldArray = c.getDeclaredFields();
        int n = ctFieldArray.length;
        int translatedEntry = 0;
        while (translatedEntry < n) {
            CtField field = ctFieldArray[translatedEntry];
            entry = EntryFactory.getFieldEntry(field);
            String translatedName = this.m_translator.translate((FieldEntry)entry);
            if (translatedName != null) {
                field.setName(translatedName);
            }
            Type translatedType = this.m_translator.translateType(((FieldEntry)entry).getType());
            field.getFieldInfo().setDescriptor(translatedType.toString());
            ++translatedEntry;
        }
        ctFieldArray = c.getDeclaredBehaviors();
        n = ctFieldArray.length;
        translatedEntry = 0;
        while (translatedEntry < n) {
            CtField behavior = ctFieldArray[translatedEntry];
            entry = EntryFactory.getBehaviorEntry((CtBehavior)behavior);
            if (behavior instanceof CtMethod) {
                CtMethod method = (CtMethod)behavior;
                String translatedName = this.m_translator.translate(entry);
                if (translatedName != null) {
                    method.setName(translatedName);
                }
            }
            if (entry.getSignature() != null) {
                Signature translatedSignature = this.m_translator.translateSignature(entry.getSignature());
                behavior.getMethodInfo().setDescriptor(translatedSignature.toString());
            }
            ++translatedEntry;
        }
        EnclosingMethodAttribute enclosingMethodAttr = (EnclosingMethodAttribute)c.getClassFile().getAttribute("EnclosingMethod");
        if (enclosingMethodAttr != null) {
            if (enclosingMethodAttr.methodIndex() == 0) {
                BehaviorEntry obfBehaviorEntry = EntryFactory.getBehaviorEntry(Descriptor.toJvmName((String)enclosingMethodAttr.className()));
                BehaviorEntry deobfBehaviorEntry = this.m_translator.translateEntry(obfBehaviorEntry);
                c.getClassFile().addAttribute((AttributeInfo)new EnclosingMethodAttribute(constants, deobfBehaviorEntry.getClassName()));
            } else {
                BehaviorEntry obfBehaviorEntry = EntryFactory.getBehaviorEntry(Descriptor.toJvmName((String)enclosingMethodAttr.className()), enclosingMethodAttr.methodName(), enclosingMethodAttr.methodDescriptor());
                BehaviorEntry deobfBehaviorEntry = this.m_translator.translateEntry(obfBehaviorEntry);
                c.getClassFile().addAttribute((AttributeInfo)new EnclosingMethodAttribute(constants, deobfBehaviorEntry.getClassName(), deobfBehaviorEntry.getName(), deobfBehaviorEntry.getSignature().toString()));
            }
        }
        ClassRenamer.renameClasses(c, this.m_translator);
        ClassEntry deobfClassEntry = this.m_translator.translateEntry(classEntry);
        if (deobfClassEntry != null) {
            String sourceFile = String.valueOf(Descriptor.toJvmName((String)deobfClassEntry.getOutermostClassName())) + ".java";
            c.getClassFile().addAttribute((AttributeInfo)new SourceFileAttribute(constants, sourceFile));
        }
    }
}

