/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.EnumValueDeclaration;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import cuchaz.enigma.analysis.SourceIndex;
import cuchaz.enigma.analysis.SourceIndexBehaviorVisitor;
import cuchaz.enigma.analysis.SourceIndexVisitor;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ConstructorEntry;
import cuchaz.enigma.mapping.EntryFactory;
import cuchaz.enigma.mapping.FieldEntry;

public class SourceIndexClassVisitor
extends SourceIndexVisitor {
    private ClassEntry m_classEntry;

    public SourceIndexClassVisitor(ClassEntry classEntry) {
        this.m_classEntry = classEntry;
    }

    @Override
    public Void visitTypeDeclaration(TypeDeclaration node, SourceIndex index) {
        TypeDefinition def = (TypeDefinition)node.getUserData(Keys.TYPE_DEFINITION);
        ClassEntry classEntry = new ClassEntry(def.getInternalName());
        if (!classEntry.equals(this.m_classEntry)) {
            index.addDeclaration((AstNode)node.getNameToken(), classEntry);
            return (Void)node.acceptVisitor((IAstVisitor)new SourceIndexClassVisitor(classEntry), (Object)index);
        }
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitSimpleType(SimpleType node, SourceIndex index) {
        TypeReference ref = (TypeReference)node.getUserData(Keys.TYPE_REFERENCE);
        if (node.getIdentifierToken().getStartLocation() != TextLocation.EMPTY) {
            ClassEntry classEntry = new ClassEntry(ref.getInternalName());
            index.addReference((AstNode)node.getIdentifierToken(), classEntry, this.m_classEntry);
        }
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration node, SourceIndex index) {
        ConstructorEntry constructorEntry;
        MethodDefinition def = (MethodDefinition)node.getUserData(Keys.METHOD_DEFINITION);
        BehaviorEntry behaviorEntry = EntryFactory.getBehaviorEntry(def);
        Identifier tokenNode = node.getNameToken();
        if (behaviorEntry instanceof ConstructorEntry && (constructorEntry = (ConstructorEntry)behaviorEntry).isStatic()) {
            tokenNode = node.getModifiers().firstOrNullObject();
        }
        index.addDeclaration((AstNode)tokenNode, behaviorEntry);
        return (Void)node.acceptVisitor((IAstVisitor)new SourceIndexBehaviorVisitor(behaviorEntry), (Object)index);
    }

    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration node, SourceIndex index) {
        MethodDefinition def = (MethodDefinition)node.getUserData(Keys.METHOD_DEFINITION);
        ConstructorEntry constructorEntry = EntryFactory.getConstructorEntry(def);
        index.addDeclaration((AstNode)node.getNameToken(), constructorEntry);
        return (Void)node.acceptVisitor((IAstVisitor)new SourceIndexBehaviorVisitor(constructorEntry), (Object)index);
    }

    @Override
    public Void visitFieldDeclaration(FieldDeclaration node, SourceIndex index) {
        FieldDefinition def = (FieldDefinition)node.getUserData(Keys.FIELD_DEFINITION);
        FieldEntry fieldEntry = EntryFactory.getFieldEntry(def);
        assert (node.getVariables().size() == 1);
        VariableInitializer variable = (VariableInitializer)node.getVariables().firstOrNullObject();
        index.addDeclaration((AstNode)variable.getNameToken(), fieldEntry);
        return this.recurse((AstNode)node, index);
    }

    @Override
    public Void visitEnumValueDeclaration(EnumValueDeclaration node, SourceIndex index) {
        FieldDefinition def = (FieldDefinition)node.getUserData(Keys.FIELD_DEFINITION);
        FieldEntry fieldEntry = EntryFactory.getFieldEntry(def);
        index.addDeclaration((AstNode)node.getNameToken(), fieldEntry);
        return this.recurse((AstNode)node, index);
    }
}

