/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.strobel.decompiler.languages.Region;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.Identifier;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.Token;
import cuchaz.enigma.mapping.Entry;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SourceIndex {
    private String m_source;
    private TreeMap<Token, EntryReference<Entry, Entry>> m_tokenToReference;
    private Multimap<EntryReference<Entry, Entry>, Token> m_referenceToTokens;
    private Map<Entry, Token> m_declarationToToken;
    private List<Integer> m_lineOffsets;
    private boolean m_ignoreBadTokens;

    public SourceIndex(String source) {
        this(source, true);
    }

    public SourceIndex(String source, boolean ignoreBadTokens) {
        this.m_source = source;
        this.m_ignoreBadTokens = ignoreBadTokens;
        this.m_tokenToReference = Maps.newTreeMap();
        this.m_referenceToTokens = HashMultimap.create();
        this.m_declarationToToken = Maps.newHashMap();
        this.m_lineOffsets = Lists.newArrayList();
        this.m_lineOffsets.add(0);
        int i = 0;
        while (i < source.length()) {
            if (source.charAt(i) == '\n') {
                this.m_lineOffsets.add(i + 1);
            }
            ++i;
        }
    }

    public String getSource() {
        return this.m_source;
    }

    public Token getToken(AstNode node) {
        Region region;
        String name = "";
        if (node instanceof Identifier) {
            name = ((Identifier)node).getName();
        }
        if ((region = node.getRegion()).getBeginLine() == 0 || region.getEndLine() == 0) {
            System.err.println(String.format("WARNING: %s \"%s\" has invalid region: %s", node.getNodeType(), name, region));
            return null;
        }
        Token token = new Token(this.toPos(region.getBeginLine(), region.getBeginColumn()), this.toPos(region.getEndLine(), region.getEndColumn()), this.m_source);
        if (token.start == 0) {
            System.err.println(String.format("WARNING: %s \"%s\" has invalid start: %s", node.getNodeType(), name, region));
            return null;
        }
        if (name.lastIndexOf(36) >= 0 && this.m_ignoreBadTokens) {
            System.err.println(String.format("WARNING: %s \"%s\" is probably a bad token. It was ignored", node.getNodeType(), name));
            return null;
        }
        return token;
    }

    public void addReference(AstNode node, Entry deobfEntry, Entry deobfContext) {
        Token token = this.getToken(node);
        if (token != null) {
            EntryReference<Entry, Entry> deobfReference = new EntryReference<Entry, Entry>(deobfEntry, token.text, deobfContext);
            this.m_tokenToReference.put(token, deobfReference);
            this.m_referenceToTokens.put(deobfReference, (Object)token);
        }
    }

    public void addDeclaration(AstNode node, Entry deobfEntry) {
        Token token = this.getToken(node);
        if (token != null) {
            EntryReference reference = new EntryReference(deobfEntry, token.text);
            this.m_tokenToReference.put(token, reference);
            this.m_referenceToTokens.put(reference, (Object)token);
            this.m_declarationToToken.put(deobfEntry, token);
        }
    }

    public Token getReferenceToken(int pos) {
        Token token = this.m_tokenToReference.floorKey(new Token(pos, pos, null));
        if (token != null && token.contains(pos)) {
            return token;
        }
        return null;
    }

    public Collection<Token> getReferenceTokens(EntryReference<Entry, Entry> deobfReference) {
        return this.m_referenceToTokens.get(deobfReference);
    }

    public EntryReference<Entry, Entry> getDeobfReference(Token token) {
        if (token == null) {
            return null;
        }
        return this.m_tokenToReference.get(token);
    }

    public void replaceDeobfReference(Token token, EntryReference<Entry, Entry> newDeobfReference) {
        EntryReference<Entry, Entry> oldDeobfReference = this.m_tokenToReference.get(token);
        this.m_tokenToReference.put(token, newDeobfReference);
        Collection tokens = this.m_referenceToTokens.get(oldDeobfReference);
        this.m_referenceToTokens.removeAll(oldDeobfReference);
        this.m_referenceToTokens.putAll(newDeobfReference, (Iterable)tokens);
    }

    public Iterable<Token> referenceTokens() {
        return this.m_tokenToReference.keySet();
    }

    public Iterable<Token> declarationTokens() {
        return this.m_declarationToToken.values();
    }

    public Iterable<Entry> declarations() {
        return this.m_declarationToToken.keySet();
    }

    public Token getDeclarationToken(Entry deobfEntry) {
        return this.m_declarationToToken.get(deobfEntry);
    }

    public int getLineNumber(int pos) {
        int line = 0;
        for (Integer offset : this.m_lineOffsets) {
            if (offset > pos) break;
            ++line;
        }
        return line;
    }

    public int getColumnNumber(int pos) {
        return pos - this.m_lineOffsets.get(this.getLineNumber(pos) - 1) + 1;
    }

    private int toPos(int line, int col) {
        return this.m_lineOffsets.get(line - 1) + col - 1;
    }
}

