/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.io.CharStreams;
import java.awt.Desktop;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.jar.JarFile;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.bytecode.Descriptor;

public class Util {
    public static int combineHashesOrdered(Object ... objs) {
        return Util.combineHashesOrdered(Arrays.asList(objs));
    }

    public static int combineHashesOrdered(Iterable<Object> objs) {
        int prime = 67;
        int result = 1;
        for (Object obj : objs) {
            result *= 67;
            if (obj == null) continue;
            result += obj.hashCode();
        }
        return result;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String readStreamToString(InputStream in) throws IOException {
        return CharStreams.toString((Readable)new InputStreamReader(in, "UTF-8"));
    }

    public static String readResourceToString(String path) throws IOException {
        InputStream in = Util.class.getResourceAsStream(path);
        if (in == null) {
            throw new IllegalArgumentException("Resource not found! " + path);
        }
        return Util.readStreamToString(in);
    }

    public static void openUrl(String url) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(url));
            }
            catch (IOException ex) {
                throw new Error(ex);
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    public static void writeClass(CtClass c) {
        String name = Descriptor.toJavaName((String)c.getName());
        File file = new File(String.valueOf(name) + ".class");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream out = new FileOutputStream(file);){
                out.write(c.toBytecode());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CannotCompileException ex) {
            throw new Error(ex);
        }
    }
}

