/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.TestEntryFactory;
import cuchaz.enigma.TokenChecker;
import cuchaz.enigma.mapping.ConstructorEntry;
import java.util.jar.JarFile;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class TestTokensConstructors
extends TokenChecker {
    public TestTokensConstructors() throws Exception {
        super(new JarFile("build/testConstructors.obf.jar"));
    }

    @Test
    public void baseDeclarations() {
        MatcherAssert.assertThat((Object)this.getDeclarationToken(TestEntryFactory.newConstructor("none/a", "()V")), (Matcher)Matchers.is((Object)"a"));
        MatcherAssert.assertThat((Object)this.getDeclarationToken(TestEntryFactory.newConstructor("none/a", "(I)V")), (Matcher)Matchers.is((Object)"a"));
    }

    @Test
    public void subDeclarations() {
        MatcherAssert.assertThat((Object)this.getDeclarationToken(TestEntryFactory.newConstructor("none/d", "()V")), (Matcher)Matchers.is((Object)"d"));
        MatcherAssert.assertThat((Object)this.getDeclarationToken(TestEntryFactory.newConstructor("none/d", "(I)V")), (Matcher)Matchers.is((Object)"d"));
        MatcherAssert.assertThat((Object)this.getDeclarationToken(TestEntryFactory.newConstructor("none/d", "(II)V")), (Matcher)Matchers.is((Object)"d"));
        MatcherAssert.assertThat((Object)this.getDeclarationToken(TestEntryFactory.newConstructor("none/d", "(III)V")), (Matcher)Matchers.is((Object)"d"));
    }

    @Test
    public void subsubDeclarations() {
        MatcherAssert.assertThat((Object)this.getDeclarationToken(TestEntryFactory.newConstructor("none/e", "(I)V")), (Matcher)Matchers.is((Object)"e"));
    }

    @Test
    public void defaultDeclarations() {
        MatcherAssert.assertThat((Object)this.getDeclarationToken(TestEntryFactory.newConstructor("none/c", "()V")), (Matcher)Matchers.nullValue());
    }

    @Test
    public void baseDefaultReferences() {
        ConstructorEntry source = TestEntryFactory.newConstructor("none/a", "()V");
        MatcherAssert.assertThat(this.getReferenceTokens(TestEntryFactory.newBehaviorReferenceByMethod(source, "none/b", "a", "()V")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"a"}));
        MatcherAssert.assertThat(this.getReferenceTokens(TestEntryFactory.newBehaviorReferenceByConstructor(source, "none/d", "()V")), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(this.getReferenceTokens(TestEntryFactory.newBehaviorReferenceByConstructor(source, "none/d", "(III)V")), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void baseIntReferences() {
        ConstructorEntry source = TestEntryFactory.newConstructor("none/a", "(I)V");
        MatcherAssert.assertThat(this.getReferenceTokens(TestEntryFactory.newBehaviorReferenceByMethod(source, "none/b", "b", "()V")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"a"}));
    }

    @Test
    public void subDefaultReferences() {
        ConstructorEntry source = TestEntryFactory.newConstructor("none/d", "()V");
        MatcherAssert.assertThat(this.getReferenceTokens(TestEntryFactory.newBehaviorReferenceByMethod(source, "none/b", "c", "()V")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"d"}));
        MatcherAssert.assertThat(this.getReferenceTokens(TestEntryFactory.newBehaviorReferenceByConstructor(source, "none/d", "(I)V")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"this"}));
    }

    @Test
    public void subIntReferences() {
        ConstructorEntry source = TestEntryFactory.newConstructor("none/d", "(I)V");
        MatcherAssert.assertThat(this.getReferenceTokens(TestEntryFactory.newBehaviorReferenceByMethod(source, "none/b", "d", "()V")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"d"}));
        MatcherAssert.assertThat(this.getReferenceTokens(TestEntryFactory.newBehaviorReferenceByConstructor(source, "none/d", "(II)V")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"this"}));
        MatcherAssert.assertThat(this.getReferenceTokens(TestEntryFactory.newBehaviorReferenceByConstructor(source, "none/e", "(I)V")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"super"}));
    }

    @Test
    public void subIntIntReferences() {
        ConstructorEntry source = TestEntryFactory.newConstructor("none/d", "(II)V");
        MatcherAssert.assertThat(this.getReferenceTokens(TestEntryFactory.newBehaviorReferenceByMethod(source, "none/b", "e", "()V")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"d"}));
    }

    @Test
    public void subsubIntReferences() {
        ConstructorEntry source = TestEntryFactory.newConstructor("none/e", "(I)V");
        MatcherAssert.assertThat(this.getReferenceTokens(TestEntryFactory.newBehaviorReferenceByMethod(source, "none/b", "f", "()V")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"e"}));
    }

    @Test
    public void defaultConstructableReferences() {
        ConstructorEntry source = TestEntryFactory.newConstructor("none/c", "()V");
        MatcherAssert.assertThat(this.getReferenceTokens(TestEntryFactory.newBehaviorReferenceByMethod(source, "none/b", "g", "()V")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"c"}));
    }
}

