/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.TestEntryFactory;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.JarIndex;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.ConstructorEntry;
import java.io.File;
import java.util.Collection;
import java.util.jar.JarFile;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class TestJarIndexConstructorReferences {
    private JarIndex m_index;
    private ClassEntry m_baseClass = TestEntryFactory.newClass("none/a");
    private ClassEntry m_subClass = TestEntryFactory.newClass("none/d");
    private ClassEntry m_subsubClass = TestEntryFactory.newClass("none/e");
    private ClassEntry m_defaultClass = TestEntryFactory.newClass("none/c");
    private ClassEntry m_callerClass = TestEntryFactory.newClass("none/b");

    public TestJarIndexConstructorReferences() throws Exception {
        File jarFile = new File("build/testConstructors.obf.jar");
        this.m_index = new JarIndex();
        this.m_index.indexJar(new JarFile(jarFile), false);
    }

    @Test
    public void obfEntries() {
        MatcherAssert.assertThat(this.m_index.getObfClassEntries(), (Matcher)Matchers.containsInAnyOrder((Object[])new ClassEntry[]{TestEntryFactory.newClass("cuchaz/enigma/inputs/Keep"), this.m_baseClass, this.m_subClass, this.m_subsubClass, this.m_defaultClass, this.m_callerClass}));
    }

    @Test
    public void baseDefault() {
        ConstructorEntry source = TestEntryFactory.newConstructor(this.m_baseClass, "()V");
        Collection<EntryReference<BehaviorEntry, BehaviorEntry>> references = this.m_index.getBehaviorReferences(source);
        MatcherAssert.assertThat(references, (Matcher)Matchers.containsInAnyOrder((Object[])new EntryReference[]{TestEntryFactory.newBehaviorReferenceByMethod(source, this.m_callerClass.getName(), "a", "()V"), TestEntryFactory.newBehaviorReferenceByConstructor(source, this.m_subClass.getName(), "()V"), TestEntryFactory.newBehaviorReferenceByConstructor(source, this.m_subClass.getName(), "(III)V")}));
    }

    @Test
    public void baseInt() {
        ConstructorEntry source = TestEntryFactory.newConstructor(this.m_baseClass, "(I)V");
        MatcherAssert.assertThat(this.m_index.getBehaviorReferences(source), (Matcher)Matchers.containsInAnyOrder((Object[])new EntryReference[]{TestEntryFactory.newBehaviorReferenceByMethod(source, this.m_callerClass.getName(), "b", "()V")}));
    }

    @Test
    public void subDefault() {
        ConstructorEntry source = TestEntryFactory.newConstructor(this.m_subClass, "()V");
        MatcherAssert.assertThat(this.m_index.getBehaviorReferences(source), (Matcher)Matchers.containsInAnyOrder((Object[])new EntryReference[]{TestEntryFactory.newBehaviorReferenceByMethod(source, this.m_callerClass.getName(), "c", "()V"), TestEntryFactory.newBehaviorReferenceByConstructor(source, this.m_subClass.getName(), "(I)V")}));
    }

    @Test
    public void subInt() {
        ConstructorEntry source = TestEntryFactory.newConstructor(this.m_subClass, "(I)V");
        MatcherAssert.assertThat(this.m_index.getBehaviorReferences(source), (Matcher)Matchers.containsInAnyOrder((Object[])new EntryReference[]{TestEntryFactory.newBehaviorReferenceByMethod(source, this.m_callerClass.getName(), "d", "()V"), TestEntryFactory.newBehaviorReferenceByConstructor(source, this.m_subClass.getName(), "(II)V"), TestEntryFactory.newBehaviorReferenceByConstructor(source, this.m_subsubClass.getName(), "(I)V")}));
    }

    @Test
    public void subIntInt() {
        ConstructorEntry source = TestEntryFactory.newConstructor(this.m_subClass, "(II)V");
        MatcherAssert.assertThat(this.m_index.getBehaviorReferences(source), (Matcher)Matchers.containsInAnyOrder((Object[])new EntryReference[]{TestEntryFactory.newBehaviorReferenceByMethod(source, this.m_callerClass.getName(), "e", "()V")}));
    }

    @Test
    public void subIntIntInt() {
        ConstructorEntry source = TestEntryFactory.newConstructor(this.m_subClass, "(III)V");
        MatcherAssert.assertThat(this.m_index.getBehaviorReferences(source), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void subsubInt() {
        ConstructorEntry source = TestEntryFactory.newConstructor(this.m_subsubClass, "(I)V");
        MatcherAssert.assertThat(this.m_index.getBehaviorReferences(source), (Matcher)Matchers.containsInAnyOrder((Object[])new EntryReference[]{TestEntryFactory.newBehaviorReferenceByMethod(source, this.m_callerClass.getName(), "f", "()V")}));
    }

    @Test
    public void defaultConstructable() {
        ConstructorEntry source = TestEntryFactory.newConstructor(this.m_defaultClass, "()V");
        MatcherAssert.assertThat(this.m_index.getBehaviorReferences(source), (Matcher)Matchers.containsInAnyOrder((Object[])new EntryReference[]{TestEntryFactory.newBehaviorReferenceByMethod(source, this.m_callerClass.getName(), "g", "()V")}));
    }
}

