/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import cuchaz.enigma.Util;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Signature;
import java.io.Serializable;

public class MethodEntry
implements BehaviorEntry,
Serializable {
    private static final long serialVersionUID = 4770915224467247458L;
    private ClassEntry m_classEntry;
    private String m_name;
    private Signature m_signature;

    public MethodEntry(ClassEntry classEntry, String name, Signature signature) {
        if (classEntry == null) {
            throw new IllegalArgumentException("Class cannot be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Method name cannot be null!");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Method signature cannot be null!");
        }
        if (name.startsWith("<")) {
            throw new IllegalArgumentException("Don't use MethodEntry for a constructor!");
        }
        this.m_classEntry = classEntry;
        this.m_name = name;
        this.m_signature = signature;
    }

    public MethodEntry(MethodEntry other) {
        this.m_classEntry = new ClassEntry(other.m_classEntry);
        this.m_name = other.m_name;
        this.m_signature = other.m_signature;
    }

    public MethodEntry(MethodEntry other, String newClassName) {
        this.m_classEntry = new ClassEntry(newClassName);
        this.m_name = other.m_name;
        this.m_signature = other.m_signature;
    }

    @Override
    public ClassEntry getClassEntry() {
        return this.m_classEntry;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Signature getSignature() {
        return this.m_signature;
    }

    @Override
    public String getClassName() {
        return this.m_classEntry.getName();
    }

    @Override
    public MethodEntry cloneToNewClass(ClassEntry classEntry) {
        return new MethodEntry(this, classEntry.getName());
    }

    public int hashCode() {
        return Util.combineHashesOrdered(this.m_classEntry, this.m_name, this.m_signature);
    }

    public boolean equals(Object other) {
        if (other instanceof MethodEntry) {
            return this.equals((MethodEntry)other);
        }
        return false;
    }

    public boolean equals(MethodEntry other) {
        return this.m_classEntry.equals(other.m_classEntry) && this.m_name.equals(other.m_name) && this.m_signature.equals(other.m_signature);
    }

    public String toString() {
        return String.valueOf(this.m_classEntry.getName()) + "." + this.m_name + this.m_signature;
    }
}

