/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import cuchaz.enigma.Util;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Entry;
import cuchaz.enigma.mapping.Type;
import java.io.Serializable;

public class FieldEntry
implements Entry,
Serializable {
    private static final long serialVersionUID = 3004663582802885451L;
    private ClassEntry m_classEntry;
    private String m_name;
    private Type m_type;

    public FieldEntry(ClassEntry classEntry, String name, Type type) {
        if (classEntry == null) {
            throw new IllegalArgumentException("Class cannot be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Field name cannot be null!");
        }
        if (type == null) {
            throw new IllegalArgumentException("Field type cannot be null!");
        }
        this.m_classEntry = classEntry;
        this.m_name = name;
        this.m_type = type;
    }

    public FieldEntry(FieldEntry other) {
        this(other, new ClassEntry(other.m_classEntry));
    }

    public FieldEntry(FieldEntry other, ClassEntry newClassEntry) {
        this.m_classEntry = newClassEntry;
        this.m_name = other.m_name;
        this.m_type = other.m_type;
    }

    @Override
    public ClassEntry getClassEntry() {
        return this.m_classEntry;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getClassName() {
        return this.m_classEntry.getName();
    }

    public Type getType() {
        return this.m_type;
    }

    @Override
    public FieldEntry cloneToNewClass(ClassEntry classEntry) {
        return new FieldEntry(this, classEntry);
    }

    public int hashCode() {
        return Util.combineHashesOrdered(this.m_classEntry, this.m_name, this.m_type);
    }

    public boolean equals(Object other) {
        if (other instanceof FieldEntry) {
            return this.equals((FieldEntry)other);
        }
        return false;
    }

    public boolean equals(FieldEntry other) {
        return this.m_classEntry.equals(other.m_classEntry) && this.m_name.equals(other.m_name) && this.m_type.equals(other.m_type);
    }

    public String toString() {
        return String.valueOf(this.m_classEntry.getName()) + "." + this.m_name + ":" + this.m_type;
    }
}

