/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.mapping;

import cuchaz.enigma.Util;
import cuchaz.enigma.mapping.BehaviorEntry;
import cuchaz.enigma.mapping.ClassEntry;
import cuchaz.enigma.mapping.Signature;
import java.io.Serializable;

public class ConstructorEntry
implements BehaviorEntry,
Serializable {
    private static final long serialVersionUID = -868346075317366758L;
    private ClassEntry m_classEntry;
    private Signature m_signature;

    public ConstructorEntry(ClassEntry classEntry) {
        this(classEntry, null);
    }

    public ConstructorEntry(ClassEntry classEntry, Signature signature) {
        if (classEntry == null) {
            throw new IllegalArgumentException("Class cannot be null!");
        }
        this.m_classEntry = classEntry;
        this.m_signature = signature;
    }

    public ConstructorEntry(ConstructorEntry other) {
        this.m_classEntry = new ClassEntry(other.m_classEntry);
        this.m_signature = other.m_signature;
    }

    public ConstructorEntry(ConstructorEntry other, String newClassName) {
        this.m_classEntry = new ClassEntry(newClassName);
        this.m_signature = other.m_signature;
    }

    @Override
    public ClassEntry getClassEntry() {
        return this.m_classEntry;
    }

    @Override
    public String getName() {
        if (this.isStatic()) {
            return "<clinit>";
        }
        return "<init>";
    }

    public boolean isStatic() {
        return this.m_signature == null;
    }

    @Override
    public Signature getSignature() {
        return this.m_signature;
    }

    @Override
    public String getClassName() {
        return this.m_classEntry.getName();
    }

    @Override
    public ConstructorEntry cloneToNewClass(ClassEntry classEntry) {
        return new ConstructorEntry(this, classEntry.getName());
    }

    public int hashCode() {
        if (this.isStatic()) {
            return Util.combineHashesOrdered(this.m_classEntry);
        }
        return Util.combineHashesOrdered(this.m_classEntry, this.m_signature);
    }

    public boolean equals(Object other) {
        if (other instanceof ConstructorEntry) {
            return this.equals((ConstructorEntry)other);
        }
        return false;
    }

    public boolean equals(ConstructorEntry other) {
        if (this.isStatic() != other.isStatic()) {
            return false;
        }
        if (this.isStatic()) {
            return this.m_classEntry.equals(other.m_classEntry);
        }
        return this.m_classEntry.equals(other.m_classEntry) && this.m_signature.equals(other.m_signature);
    }

    public String toString() {
        if (this.isStatic()) {
            return String.valueOf(this.m_classEntry.getName()) + "." + this.getName();
        }
        return String.valueOf(this.m_classEntry.getName()) + "." + this.getName() + this.m_signature;
    }
}

