/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.convert;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cuchaz.enigma.convert.ClassIdentifier;
import cuchaz.enigma.convert.ClassIdentity;
import cuchaz.enigma.mapping.ClassEntry;
import java.util.Collection;

public class ClassForest {
    private ClassIdentifier m_identifier;
    private Multimap<ClassIdentity, ClassEntry> m_forest;

    public ClassForest(ClassIdentifier identifier) {
        this.m_identifier = identifier;
        this.m_forest = HashMultimap.create();
    }

    public void addAll(Iterable<ClassEntry> entries) {
        for (ClassEntry entry : entries) {
            this.add(entry);
        }
    }

    public void add(ClassEntry entry) {
        try {
            this.m_forest.put((Object)this.m_identifier.identify(entry), (Object)entry);
        }
        catch (ClassNotFoundException ex) {
            throw new Error("Unable to find class " + entry.getName());
        }
    }

    public Collection<ClassIdentity> identities() {
        return this.m_forest.keySet();
    }

    public Collection<ClassEntry> classes() {
        return this.m_forest.values();
    }

    public Collection<ClassEntry> getClasses(ClassIdentity identity) {
        return this.m_forest.get((Object)identity);
    }

    public boolean containsIdentity(ClassIdentity identity) {
        return this.m_forest.containsKey((Object)identity);
    }
}

