/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.bytecode.accessors;

import cuchaz.enigma.bytecode.InfoType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ConstInfoAccessor {
    private static Class<?> m_class;
    private static Field m_index;
    private static Method m_getTag;
    private Object m_item;

    static {
        try {
            m_class = Class.forName("javassist.bytecode.ConstInfo");
            m_index = m_class.getDeclaredField("index");
            m_index.setAccessible(true);
            m_getTag = m_class.getMethod("getTag", new Class[0]);
            m_getTag.setAccessible(true);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public ConstInfoAccessor(Object item) {
        if (item == null) {
            throw new IllegalArgumentException("item cannot be null!");
        }
        this.m_item = item;
    }

    public ConstInfoAccessor(DataInputStream in) throws IOException {
        try {
            String className = in.readUTF();
            int oldIndex = in.readInt();
            in.readByte();
            Constructor<?> constructor = Class.forName(className).getConstructor(DataInputStream.class, Integer.TYPE);
            constructor.setAccessible(true);
            this.m_item = constructor.newInstance(in, oldIndex);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public Object getItem() {
        return this.m_item;
    }

    public int getIndex() {
        try {
            return (Integer)m_index.get(this.m_item);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public void setIndex(int val) {
        try {
            m_index.set(this.m_item, val);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public int getTag() {
        try {
            return (Integer)m_getTag.invoke(this.m_item, new Object[0]);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public ConstInfoAccessor copy() {
        return new ConstInfoAccessor(this.copyItem());
    }

    public Object copyItem() {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(buf);
            this.write(out);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf.toByteArray()));
            Object item = new ConstInfoAccessor(in).getItem();
            in.close();
            return item;
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public void write(DataOutputStream out) throws IOException {
        try {
            out.writeUTF(this.m_item.getClass().getName());
            out.writeInt(this.getIndex());
            Method method = this.m_item.getClass().getMethod("write", DataOutputStream.class);
            method.setAccessible(true);
            method.invoke(this.m_item, out);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public String toString() {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            PrintWriter out = new PrintWriter(buf);
            Method print = this.m_item.getClass().getMethod("print", PrintWriter.class);
            print.setAccessible(true);
            print.invoke(this.m_item, out);
            out.close();
            return buf.toString().replace("\n", "");
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public InfoType getType() {
        return InfoType.getByTag(this.getTag());
    }
}

